#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <limits.h>   /* for FLT_MAX and FLT_MIN (hopefully) */
#include "image.h"

#ifndef FLT_MAX
#define FLT_MAX   ((float)1.0e+30)
#endif

#ifndef FLT_MIN
#define FLT_MIN   ((float)1.0e-30)
#endif

#define imgError(e,p) \
   { char e_s[256]; \
   sprintf(e_s,"%s (%s)",e,p); \
   i_error(e_s); }
#define imgArgError(e,a,p) \
   { char e_s[256]; \
   sprintf(e_s,e,a); \
   fprintf(stderr,"Error: %s (%s).\n",e_s,p); \
   exit(1); }
#define imgStart(p)   fprintf(stderr,"%s: started\n",p);
#define imgFinish(p)   fprintf(stderr,"%s: finished\n",p);
#define imgInitMinMax(min,max) {max= -(FLT_MAX);min=FLT_MAX;}
#define IFHELP  if(argc==2 && argv[1][0]=='-' && argv[1][1]=='h')

#define NEAR_ZERO (FLT_MIN)

/* This token concatenation function may need changing */
#define CAT(a,b)  a##b

/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
