/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgFFTBandPass.c                                              */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:37 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "FFTBandPass"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *im;
  int width,height,x,y,halfwidth,halfheight;
  double u,v,phwc,phhc;
  double omega,sigma,bandwidth,tpb,c1,val,rad;
  it_complex *cpx_ptr;

  IFHELP
    {
      fprintf(stderr,"img%s - Fourier Gaussian bandpass filter\n",
	      PRGNAME);
      fprintf(stderr,"img%s [freq [bandwidth]]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Complex\n");
      fprintf(stderr,"  stdout: Complex\n");
      fprintf(stderr,"  freq is the centre frequency in radians/pixel\n");
      fprintf(stderr,"  bandwidth is the bandwidth at half-height in octaves\n");
      fprintf(stderr,"  defaults: pi/2 1\n");
      exit(0);
    }

  omega=M_PI_2;
  bandwidth=1.0;
  if(argc>3)
    ERROR("invalid arguments");
  if(argc>1)
    omega=atof(argv[1]);
  if(argc>2)
    bandwidth=atof(argv[2]);
  if(bandwidth<=0.0 || omega<=0.0)
    ERROR("arguments out of range");

  imgStart(PRGNAME);
  tpb=pow(2.0,bandwidth);
  sigma=(tpb+1.0)/(tpb-1.0)*sqrt(2.0*M_LN2)/omega;

  /* Loop for all images */
  do {
    im=i_read_image_file(stdin,IT_COMPLEX,IM_FRAGMENT);
    if(im==NULL)
      ERROR("can't import image");
    width=im->width;
    height=im->height;
    halfwidth=width/2;
    halfheight=height/2;
    phwc=M_PI/((double) halfwidth);
    phhc=M_PI/((double) halfheight);
    c1= -sigma*sigma/2.0;
    for(y=0;y<height;y++)
      {
	cpx_ptr=im_complex_row(im,y);
	for(x=0;x<width;x++,cpx_ptr++)
	  {
	    u=phwc*(double) ((x<halfwidth)?(x):(x-width));
	    v=phhc*(double) ((y<halfheight)?(y):(y-height));
	    rad=sqrt(u*u+v*v)-omega;
	    val=exp(rad*rad*c1);
	    cpx_ptr->Re *=val;
	    cpx_ptr->Im *=val;
	  }
      }
    i_write_image_file(stdout,im,IF_BINARY);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
