#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/time.h>

FILE *f;
FILE *of;

typedef struct ratio_dummy{
    char queue[16];
    float avgR;
} ratio_pair_t;
                          
    
#define CRAYYMP 17.5
#define SP2  11.15        
ratio_pair_t ratios[]= { "priority", 11.15,  
                         "longterm", 11.15,
                         "sp2",      11.15,
                          "ibms590",  10.23,
                          "alpha",     3.86,
                          "ibms250",   3.14,
                          "ibms375",   3.02,
                          "hp",        2.68,
                          "ibms550",   2.51,
                          "ibms340",   1.62,
                          "ibms530",   1.52,
                          "ibms320h",  1.28,
                          "jra",       1.28,
                          "ibms320",   1.00,
                          "XXXX",     -1.00  };


void mysort(unsigned long , unsigned long* );
unsigned int mymode(unsigned long , unsigned long* );
float get_ratio(char*, int*);

main(int argc, char **argv)
{
int firsttime, tjobs, stlen, slx, slx2;
int maxdelay, maxwall, maxtime, maxmem, totalmem;
int delay, walltime, cputime, pages, totalwall, totalcpu, totaldelay;
float ratio, fl_cum_scru, ftemp, fractional_usage;
int int_cum_scru, rindex, hours, days, mach_index, max_days;
int i,j;
int total_jobs_per_day[365];
int total_jobs_per_day_per_machine[365][100];
float cum_scru_per_day[365];
float cum_scru_per_day_per_machine[365][100];


char old_cpu[1024];
char old_user[1024];
char instream[1024];
char starttime[256];
char endtime[256];

char *fstatus;
char *tptr,*optr, *ttime;
char fillsp[]="                                        ";

char *names[100];
char cpuname[1024];
char username[1024];
unsigned long wall[20000],cpu[20000],delayV[20000], pgs[20000];
unsigned int wallmedian, wallmode;
unsigned int cpumedian, cpumode;
unsigned int dlymedian, dlymode;
unsigned int pgsmedian, pgsmode;
time_t timethen, timenow, elapsed_time,job_start_time, job_end_time, time_temp;

f= fopen("machine_stats","r");

maxdelay=0;
maxtime=0;
maxmem=0;
tjobs=0;
maxwall=0;
totalwall=0;
totalcpu=0;
totaldelay=0;
totalmem=0;
slx=0;
fl_cum_scru= 0.0;
mach_index=0;


for(i=0;i<365;i++){
    total_jobs_per_day[i]=0;
    cum_scru_per_day[i]=0.0;

    for(j=0;j<100;j++){
       total_jobs_per_day_per_machine[i][j]=0;
       cum_scru_per_day_per_machine[i][j]=0.0;
    }
}



strcpy(old_cpu," ");
firsttime=1;

while(1){
	fstatus= fgets(instream,256,f);

	if(fstatus==NULL) break;

    if( !strncmp(instream,"  timethen=",11) ) {
       tptr= strtok(instream," ");
       if(!tptr) continue;
       tptr= strtok(NULL," ");
       if(!tptr) continue;
       timethen= atoi(tptr);
       
       tptr= strtok(NULL," ");
       if(!tptr) continue;
       tptr= strtok(NULL," ");
       if(!tptr) continue;
       timenow= atoi(tptr);
       elapsed_time= timenow-timethen;
       hours= elapsed_time/3600;
       days= hours/24;
       ttime= ctime(&timethen);
       if(!ttime) continue;
       strcpy(starttime, ttime);
       
       ttime= ctime(&timenow);
       if(!ttime) continue;   
       strcpy(endtime, ttime);
       
       printf("Stats for %s to %stotal elapsed time %d seconds  or about %d hours  or %d days\n\n",
                starttime, endtime, elapsed_time, hours, days);
       printf("machine   \t totjobs   usage    maxdly  maxwall  maxcpu   maxpgs    totdly   totwall   totcpu   avgdly  meddly   moddly  avgwall  medwall  modwall   avgcpu   medcpu   modcpu   avgpgs   medpgs   modpgs\n");
       printf("----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------\n");

       continue;
     }
	

	tptr= strtok(instream," ");
	if(!tptr) break;
	if( firsttime ){
		strcpy(old_cpu,tptr);
		firsttime=0;
	}
	if(strcmp(old_cpu,tptr) ){
		strcpy(cpuname,old_cpu);
		strcat(cpuname,fillsp);
		cpuname[10]='\0';
        names[mach_index]= (char*) malloc(11);
        strcpy(names[mach_index],cpuname);
  
        mysort(slx, wall);
        mysort(slx,cpu);
        mysort(slx,delayV);
        mysort(slx,pgs);
        slx2= slx/2;
        wallmedian= wall[slx2];
        cpumedian= cpu[slx2];
        dlymedian= delayV[slx2];
        pgsmedian= pgs[slx2];
 
        wallmode= mymode(slx, wall);
        cpumode= mymode(slx, cpu);
        dlymode= mymode(slx,delayV);
        pgsmode= mymode(slx, pgs);
        ftemp= elapsed_time;
        fractional_usage=  totalwall;
        fractional_usage=  fractional_usage/ ftemp;
        printf("%s\t %5d    %5.3f %8d %8d %8d %8d  %8d %8d %8d %8d %8d %8d %8d %8d %8d %8d %8d %8d %8d %8d %8d\n",
             cpuname, tjobs,fractional_usage, maxdelay,maxwall,maxtime,maxmem,
             totaldelay, totalwall, totalcpu,
             totaldelay/tjobs, dlymedian, dlymode,
             totalwall/tjobs,wallmedian,wallmode,
             totalcpu/tjobs,cpumedian, cpumode,
             totalmem/tjobs, pgsmedian, pgsmode);
      
		maxdelay=0;
		maxtime=0;
		maxmem=0;
		maxwall=9;
		tjobs=0;
        totalwall=0;
        totalcpu=0;
        totaldelay=0;
        totalmem=0;
        slx=0;
        fl_cum_scru=0.0;
        mach_index++;
	}
	strcpy(old_cpu,tptr);
	tptr= strtok(NULL," ");  /* skip user name */
	if(!tptr) break;

    ratio= get_ratio(old_cpu,&rindex);

	tptr= strtok(NULL," ");  /* skip over complex name */
	if(!tptr) break;

	tptr= strtok(NULL," ");  /*  get delay  */
	if(!tptr) break;

    delay= abs(  atoi(tptr) );
    if(delay>1000000) continue;
    if(delay>maxdelay) maxdelay=delay;
    totaldelay=totaldelay+delay;
    delayV[slx]=delay;
    tptr= strtok(NULL," ");   /* get wallclcock */
    if(!tptr) break;

    if( *(tptr) == '-') walltime=0;
    else    walltime= atoi(tptr);
    if(walltime>1000000) continue;
    if(walltime> maxwall) maxwall=walltime;
    totalwall=totalwall+walltime;
    ftemp= walltime;
    ftemp= ftemp* ratio;
    ftemp= ftemp/SP2;
    fl_cum_scru= fl_cum_scru+ ftemp;
    wall[slx]= walltime;
    tptr= strtok(NULL," ");
    if(!tptr) break;

    if( *(tptr) == '-') cputime=0;
    else     cputime= atoi(tptr);
    if(cputime>1000000)continue;
    if(cputime> maxtime) maxtime= cputime;
    totalcpu=totalcpu+cputime;
    cpu[slx]=cputime;
    tptr= strtok(NULL," ");
    if(!tptr) break;

    if( *(tptr) == '-') pages=0;
    else     pages= atoi(tptr);
    if(pages>1000000) continue;

    pgs[slx]= pages;

    if(pages>maxmem) maxmem= pages;
    totalmem=totalmem+pages;

    tptr= strtok(NULL," ");
    if(!tptr) break;
    
    if( *(tptr) == '-') job_start_time=0;
    else     job_start_time= atoi(tptr);
    
    
    tptr= strtok(NULL," ");
    if(!tptr) break;
    
    if( *(tptr) == '-') job_end_time=0;
    else     job_end_time= atoi(tptr);
    
    time_temp= job_start_time - timethen; /* compute offset in seconds */
    
    time_temp= time_temp/86400;  /* compute offset in days */
    
    i= time_temp;
    
    if( (i<0) || (i>365) ) i=365;
    else {
        if(i> max_days) max_days=i;
    }
    
    
    total_jobs_per_day[i] ++;
    total_jobs_per_day_per_machine[i][mach_index] ++;
    
    cum_scru_per_day[i]= cum_scru_per_day[i] + ftemp; /* ftemp holds this cumsc  */
    cum_scru_per_day_per_machine[i][mach_index] = cum_scru_per_day_per_machine[i][mach_index] + ftemp;

    


    slx++;
    tjobs++;    	
}
of= fopen("machineline.txt","w");
if(!of) return;
fprintf(of,"Stats for %s to %stotal elapsed time %d seconds  or about %d hours or %d days\n\n",
                starttime, endtime, elapsed_time, hours, days);

fprintf(of,"Day   Total Jobs   Cum_Scru     ");
for(i=0;i<mach_index;i++){
    fprintf(of,"%s      ",names[i]);
}
fprintf(of,"\n");

for(i=0;i<max_days;i++){
    fprintf(of,"%4d     %4d    %7.3e  ", i, total_jobs_per_day[i], cum_scru_per_day[i]);
    for(j=0;j<mach_index;j++){
        fprintf(of,"%3d  %7.3e  ",total_jobs_per_day_per_machine[i][j],
                                cum_scru_per_day_per_machine[i][j]);
        }
    fprintf(of,"\n");
}


}

void mysort(unsigned long n, unsigned long uia[])
{
    unsigned long i,ir,j,l;
    unsigned long ruia;

    if (n < 2) return;
    l=(n >> 1)+1;
    ir=n;
    for (;;) {
        if (l > 1) {
            ruia=uia[--l];
        } else {
            ruia=uia[ir];
            uia[ir]=uia[1];
            if (--ir == 1) {
                uia[1]=ruia;
                break;
            }
        }
        i=l;
        j=l+l;
        while (j <= ir) {
            if (j < ir && uia[j] < uia[j+1]) j++;
            if (ruia < uia[j]) {
                uia[i]=uia[j];
                i=j;
                j <<= 1;
            } else j=ir+1;
        }
        uia[i]=ruia;
    }
}

unsigned int mymode(unsigned long n, unsigned long uia[])
{
float predictor, estimate, temp, ratio;
unsigned int rmode;
int predx, i;
int J=3;

predictor=0.0;
predx=0.0;
ratio= J;
ratio= ratio/n;

if(n<=J) return uia[1];
for (i=0;i< (n-J) ;i++){
    temp= uia[i+J]-uia[i];
    
    estimate= ratio * temp;
    if(estimate > predictor){
      predictor= estimate;
      rmode= (uia[i+J] + uia[i])/2;
    }
}
return rmode;

}
float get_ratio(char *name, int *indx)
{   
    
int i, n_len;
float ratio;
    
if(!name) return -1.0;            /* error */

    
for(i=0;i<100;i++){
    n_len= strlen(ratios[i].queue);
    if( !strcmp(ratios[i].queue,"XXXX") )break;
    if(!strncmp(name,ratios[i].queue,n_len) )break;
}
ratio= ratios[i].avgR;
*indx=i;
return ratio;

}   

