
/***********************************************************
 * globals.h - include file for qmon
 *
 * Version 3.3 by Jeff Snyder
 * Date: 6/24/92
 *
 * Versions 3.4 & 3.5 by Lakhamraju R. Raju
 * Date: 11/02/93
 *
 * Major modifications: Removed motif calls and replaced 
 *	               with athena widget set calls.
 *
 * Copyright 1992, 1993, 1994
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 **********************************************************/
#include "globals.h"

static Widget           queue_popup;
static Widget           widget_queuerc;
static Widget           widget_queuelabel;
static Widget           widget_queueframe;
static Widget           widget_queuemenu;
static Widget           widget_queuemain;
static Widget           widget_queueexec;
static Widget           widget_queueclear;
static Widget           widget_queueclose;
static Widget           widget_queueseparator;
static Widget           widget_queueopt;
static Widget           addqueueopen=0;
static Widget           locqconfopen=0;

struct optionstruct queuemenu[]={
  0,"Cell        ","-cell",MENUTYPE,NULL,NULL,
  0,"Show Queue List","-sql",ACTIONTYPE,NULL,NULL,
  0,"Add Queue      ","-aq",ACTIONTYPE,NULL,NULL,
  0,"Modify Queue   ","-MQ",ACTIONTYPE,NULL,NULL,
  0,"Clean Queue    ","-cq",ACTIONTYPE,NULL,NULL,
  0,"Delete Queue   ","-dq",ACTIONTYPE,NULL,NULL,
  0,"Show Queue     ","-sq",ACTIONTYPE,NULL,NULL,
  0,"Queue Name  ",NULL,MENUTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_queueexec - Activate callback for exec
 */
XtCallbackProc pb_queueexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  int ii;
  char          command[MAX_STRING_SIZE];
  
  sprintf(command,"%s -cell %s",QCONF_BINARY,current_cell);
  buildcommand(command,queuemenu,0);
  sleep(1);
  UnMapIconWin ();
  refreshicons ();
  pb_setupcompact(w,(int)NULL,NULL);
  MapIconWin ();
/*  check if this is needed for dec terms ---
  pb_setupcompact(w,NULL,NULL);
*/
}


/***********************************************************
 * pb_queueclear - Activate callback for clear
 */
XtCallbackProc pb_queueclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  int ii;
  Arg args[5];

/*
  clearsubmenu(queuemenu);
*/
  QmonTextSetString(queuemenu[0].widgetid ,current_cell );
  if(queue_list) 
  	QmonTextSetString(queuemenu[7].widgetid ,current_destination );
}


/***********************************************************
 * pb_queueclose - Activate callback for close
 */
XtCallbackProc pb_queueclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closesubmenuwin();
}


/***********************************************************
 * queueaction - Activate callback for action type menu
 */
XtCallbackProc queueaction(Widget w, caddr_t client_data, caddr_t call_data)
{
  char            command[IOBUFLEN];
  int             ii;
  int             n;
  Arg             args[32];
  char		  *ptr=NULL;
  char		  *ptr1=NULL;

  ptr=QmonTextGetString(queuemenu[7].widgetid); 
  ptr1=QmonTextGetString(queuemenu[0].widgetid); 
  for(ii=0;queuemenu[ii].name;ii++) {
    if(w==queuemenu[ii].widgetid) {
      /*
       * This is the addqueue option and we need to handle
       * this option slightly different
       */
      if(ii==2||ii==3) {
      if(ii==2) {
	if(addqueueopen) {
	  closeaddqueuemenuwin();
	}
	else {
	  n=0;
	  XtSetArg(args[n],XtNforeground,defaultbackground(w)); n++;
	  XtSetArg(args[n],XtNbackground,defaultforeground(w)); n++;
	  XtSetValues(w,args,n);
	  
	  openwidget_addqueuesub(w,NULL,NULL);
	  addqueueopen=w;
	}
      }
      if(ii==3) {
        create_sorry_dialog(w,NULL, NULL);
        openwidget_sorry();
	break;


	if(locqconfopen) {
	  closelocqconfmenuwin();
	}
	else {
	  n=0;
	  XtSetArg(args[n],XtNforeground,defaultbackground(w)); n++;
	  XtSetArg(args[n],XtNbackground,defaultforeground(w)); n++;
	  XtSetValues(w,args,n);
	  
	  openwidget_locqconfsub(w,ptr,NULL);
	  locqconfopen=w;
	}
      }
      }
      else {
	sprintf(command,"%s -cell %s %s %s &",QCONF_BINARY,ptr1,queuemenu[ii].flag,ptr);
	printf("%s\n",command);
	execit(command);
      }
      break;
    }
  }
}


/***********************************************************
 * create_queue_dialog - Create widgets used for the queue menu
 */
int create_queue_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        queue_form;
  Position    x, y;
  Dimension   width, height;
  Widget  exec, clear, close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  queuemenu[0].list = cell_list;
  queuemenu[7].list = queue_list;

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  queue_popup = XtCreatePopupShell("queuepop", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  queue_form = XtCreateManagedWidget("form", formWidgetClass, queue_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_queuelabel=
        XtCreateManagedWidget("Configure Queue",labelWidgetClass,queue_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_queuelabel); ii++;
  widget_queuemain=XtCreateManagedWidget("box",formWidgetClass,queue_form,
                                        args,ii);
/*
 exec=QmonAddButtonN(widget_queuemain,NULL,"Exec",(XtCallbackProc)pb_queueexec,NULL);
*/
 clear=QmonAddButtonN(widget_queuemain,NULL,"Reset",(XtCallbackProc)pb_queueclear,NULL);
 close=QmonAddButtonN(widget_queuemain,clear,"Close",(XtCallbackProc)pb_queueclose,NULL);

  widget_queueopt=createmenuoptions(queue_form,widget_queuemain,queuemenu,(XtCallbackProc)queueaction);
}


/***********************************************************
 * openwidget_queuesub - Open the queue menu
 */
int openwidget_queuesub()
{
  pb_queueclear(NULL,NULL,NULL);
  XtPopup(queue_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_queuesub - Close the queue menu
 */
int closewidget_queuesub()
{
  int             ii;
  Arg             args[32];
  if(addqueueopen)  
    closeaddqueuemenuwin();
  if(locqconfopen)  
    closelocqconfmenuwin();
   
  XtPopdown(queue_popup);
}


/***********************************************************
 * closeaddqueuemenuwin - Close the addqueue menu
 */
int closeaddqueuemenuwin()
{
  int             ii;
  Arg             args[32];

  ii=0;
  XtSetArg(args[ii],XtNforeground,defaultbackground(addqueueopen)); ii++;
  XtSetArg(args[ii],XtNbackground,defaultforeground(addqueueopen)); ii++;
  XtSetValues(addqueueopen,args,ii);
  
  addqueueopen=0;
  closewidget_addqueuesub();
}
/***********************************************************
 * closelocqconfmenuwin - Close the locqconf menu
 */
int closelocqconfmenuwin()
{
  int             ii;
  Arg             args[32];

  ii=0;
  XtSetArg(args[ii],XtNforeground,defaultbackground(locqconfopen)); ii++;
  XtSetArg(args[ii],XtNbackground,defaultforeground(locqconfopen)); ii++;
  XtSetValues(locqconfopen,args,ii);
  
  locqconfopen=0;
  closewidget_locqconfsub();
}
/***********************************************************
 * closeglobqconfmenuwin - Close the globqconf menu
int closeglobqconfmenuwin()
{
  int             ii;
  Arg             args[32];

  ii=0;
  XtSetArg(args[ii],XtNforeground,defaultbackground(globqconfopen)); ii++;
  XtSetArg(args[ii],XtNbackground,defaultforeground(globqconfopen)); ii++;
  XtSetValues(globqconfopen,args,ii);
  
  globqconfopen=0;
  closewidget_globqconfsub();
}

 */
