static char     iconwin_rcsid[] = "iconwin.c,v 1.2 1994/11/28 16:55:00 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  iconwin.c,v
 * Revision 1.2  1994/11/28  16:55:00  kerce
 * *** empty log message ***
 *
 * Revision 1.6  1994/09/13  18:01:59  raju
 * prototyepe declarations
 *
 * Revision 1.5  1994/08/21  02:57:34  raju
 * *** empty log message ***
 *
 * Revision 1.4  1994/07/20  01:01:35  raju
 * added a couple of functions
 *
 * Revision 1.3  1994/07/15  18:12:20  raju
 * indented ,
 *
 * Revision 1.2  1994/07/15  17:35:08  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:02  raju
 * Initial revision
 *
 *
 *
 **********************************************************/

#include "globals.h"
#include "qmonerrs.h"

queueiconstruct *queueicon = NULL;
queuepixstruct *queuepix = NULL;
extern char    *currconfigfile;
extern char    *grpconfigfile;
extern XtAppContext app_context;
int             startup = 0;
XImage         *createimage();
int             max_icons = 0;
int             max_usergrps = 0;
int             bmcnt = 0;
Widget          iconwin;
Widget          blankwin;
Widget          viewicon;
static char    *grouparray[MAX_GROUPS];
char           *usergrparray[MAX_GROUPS];
int             totalgroups = 0;
STACK_NODE	*queue_list=NULL;


/***********************************************************
 * pushbutton_bgpmicon - Activate callback for a background
 *                       pixmap icon
 */
XtCallbackProc pushbutton_bgpmicon(Widget w,caddr_t client_data,caddr_t call_data)
{
	int             ii;
	char            cmdline[1024];
	char           *displayname;
	char           *getenv();

	displayname = getenv("DISPLAY");
	/*
	 * if(strcmp(displayname,"unix0:0")) { printf("unix0:0\n");
	 * free(displayname); displayname=getenv("HOSTNAME");
	 * strcat(displayname,":0.0"); } 
	 */
	for (ii = 0; ii < max_icons; ii++)
		if (queueicon[ii].bgpixmap == w) {
		/*
		 * Get the top(1) distribution from one of the
		 * archive servers 
		 */
		sprintf(cmdline, "rsh %s \"xterm -display %s -title %s -e %s >& /dev/null &\" &", queueicon[ii].hostname, displayname, queueicon[ii].name,TOP_BINARY);
		execit(cmdline);
		break;
	}
}
/***********************************************************
 * pushbutton_pmicon - Activate callback for a pushme icon
 */
XtCallbackProc pushbutton_pmicon(Widget w,caddr_t client_data,caddr_t call_data)
{
	int             ii;
	char            cmdline[1024];

   for (ii = 0; ii < max_icons; ii++)
   if (queueicon[ii].pushme == w) {
     sprintf(cmdline, "%s -cell %s -q %s -u %s &", 
		QSTAT_BINARY, current_cell,queueicon[ii].name, current_user);
     execit(cmdline);
     break;
   }
}
/***********************************************************
 * initiconwin - Setup the icon window
 */
void initiconwin(Widget paned)
{
	char            errmsg[MAX_STRING_SIZE];
	char            bmconfigfile[MAX_STRING_SIZE];
	char            bmfile[MAX_STRING_SIZE];
	char            buffer1[MAX_STRING_SIZE];
	char            imagename[MAX_STRING_SIZE];
	char            tmpc;
	int             gethex;
	int             ii;
	Arg             args[32];
	FILE           *bmfp1;
	FILE           *bmfp2;
	char           *tmpptr = NULL;


	for (ii = 0; ii < MAX_GROUPS; ii++) {
		usergrparray[ii] = NULL;
	}
	/*
	 * Qmonalloc (); 
	 */

	if (startup) {

	   if ((bmfp1 = fopen(grpconfigfile, "r")) == NULL) {
		sprintf(errmsg, ERROR_102,grpconfigfile);
			logerr(errmsg);
	   } 
	   else {
		for (ii = 0; ii < max_usergrps; ii++) {
		    fscanf(bmfp1, "%s", buffer1);
		    tmpptr = malloc(strlen(buffer1) + 1);
		    strcpy(tmpptr, buffer1);
		    usergrparray[ii] = tmpptr;
		}
	   }
	   fclose(bmfp1);

	usergroup_setup();
	}
	/*
	 * Create Viewport widget for iconwindow 
	 */
	ii = 0;
	XtSetArg(args[ii], XtNallowVert, True);
	ii++;
	viewicon = XtCreateManagedWidget("viewicon", viewportWidgetClass, paned, args, ii);

	/*
	 * Create window for icons 
	 */
	ii = 0;
	XtSetArg(args[ii], XtNwidth, 500);
	ii++;
	XtSetArg(args[ii], XtNheight, 500);
	ii++;
	XtSetArg(args[ii], XtNorientation, XtorientVertical);
	ii++;
	iconwin = XtCreateManagedWidget("iconwin", boxWidgetClass, viewicon, args, ii);

	/*
	 * Read the bitmap configuration file that maps queues, groups, or
	 * architectures to bitmaps
	 * sprintf(bmconfigfile,"%s/%s",BITMAPDIR,BITMAPCONF); 
	 */
	if ((bmfp1 = fopen(currconfigfile, "r")) == NULL) {
	   sprintf(errmsg, ERROR_102, currconfigfile);
	   logerr(errmsg);
	} 
	else {
	/*
	 * Create the default bitmap 
	 */
	     sprintf(bmfile, "%s/%s", BITMAPDIR, "default.bm");
	     if ((bmfp2 = fopen(bmfile, "r")) == NULL) {
		sprintf(errmsg, ERROR_102, bmfile);
		logerr(errmsg);
	     } 
	     else {
		  while ((tmpc = fgetc(bmfp2)) != '{');
		       for (ii = 0; (ii < BITMAPBITS) && (tmpc != EOF) && (tmpc != '}'); ii++) {
			    while (tmpc != 'x' && tmpc != '}')
			    tmpc = fgetc(bmfp2);
			    fscanf(bmfp2, "%x", &gethex);
			    queuepix[bmcnt].bits[ii] = (char) gethex;
			    tmpc = fgetc(bmfp2);
			}
			fclose(bmfp2);
			/*
			 * Create and install the bitmap image 
			 */


			bmcnt++;
		}
		/*
		 * Read each line entry for a matching identifier (i.e. arc,
		 * group, or queue) and a bitmap file 
		 */
		for (; (bmcnt < max_icons) && (fgets(buffer1, MAX_STRING_SIZE, bmfp1) != NULL);) {
		/*
		 * Ignore lines that begin with # 
		 */
		    if (buffer1[0] && buffer1[0] != '#') {
			sscanf(buffer1, "%s %s", queuepix[bmcnt].ident, queuepix[bmcnt].bitmap);
			sprintf(bmfile, "%s/%s", BITMAPDIR, queuepix[bmcnt].bitmap);
			if ((bmfp2 = fopen(bmfile, "r")) == NULL) {
			   sprintf(errmsg, ERROR_102, bmfile);
			   logerr(errmsg);
			   continue;
			} 
	 		else {
			     while ((tmpc = fgetc(bmfp2)) != '{');
			     for (ii = 0; (ii < BITMAPBITS) && (tmpc != EOF) && (tmpc != '}'); ii++) {
				while (tmpc != 'x' && tmpc != '}')
				tmpc = fgetc(bmfp2);
				fscanf(bmfp2, "%x", &gethex);
				queuepix[bmcnt].bits[ii] = (char) gethex;
				tmpc = fgetc(bmfp2);
			      }
			     fclose(bmfp2);
			/*
			 * Create and install the bitmap
			 * image 
			 */

			    }
			} 
			else {
				continue;
			}
			bmcnt++;
		}
		fclose(bmfp1);
	}

}


/***********************************************************
 * getbmarr - Return an index to the bitmap array
 *            for a given queue
 */
int getbmarr(queueiconstruct *queueicon)
{
	char            pixmapname[MAX_STRING_SIZE];
	char           *iconptr = "default.bm";
	char           *ptr;
	int             ii;
	int             indx;


	indx = 0;
	for (ii = 1; ii < bmcnt; ii++) {
		if (!strcmp(queueicon->name, queuepix[ii].ident))
			indx = ii;
		else if (!strcmp(queueicon->group, queuepix[ii].ident))
			indx = ii;
	}

	return indx;
}


/***********************************************************
 * getbmstr - Return a pointer to the name of bitmap
 *            for a given queue
 */
char * getbmstr(queueiconstruct *queueicon)
{
	char            pixmapname[MAX_STRING_SIZE];
	char           *iconptr = "default.bm";
	char           *ptr;
	int             ii;


	for (ii = 0; ii < bmcnt; ii++) {
		if (!strcmp(queueicon->name, queuepix[ii].ident))
			iconptr = queuepix[ii].bitmap;
		else if (!strcmp(queueicon->group, queuepix[ii].ident))
			iconptr = queuepix[ii].bitmap;
	}

	ptr = iconptr;


	return ptr;
}


/***********************************************************
 * mapit - Return 1 if the icon should be mapped
 */
int mapit(queueiconstruct *queueicon)
{
	if (queueicon->alarm)
		return showalarmqueues() && showgroup(queueicon->cmplx_list);
	else if (queueicon->idle)
		return showidlequeues() && showgroup(queueicon->cmplx_list);
	else if (queueicon->suspended)
		return showsuspendedqueues() && showgroup(queueicon->cmplx_list);
	else if (queueicon->running)
		return showrunningqueues() && showgroup(queueicon->cmplx_list);
	else if (queueicon->sus_on_comp)
		return showsuscompqueues() && showgroup(queueicon->cmplx_list);

}

/***********************************************************
 * addicon - Add icon to the icon window
 */
void addicon(queueiconstruct *queueicon, queuepixstruct *queuepix)
{
	char           *iconptr;
	char            infostr[MAX_STRING_SIZE];
	int             ii;
	Arg             args[32];
	Pixel           fg;
	Pixel           bg;
	Pixmap          pixmap;
	static GC       gc = NULL;
	XGCValues       xgcval;
	int             index = 0;
	int             same;
	int             status_changed;
	Widget          box;
	Drawable        drawble;

	/*
	 * If we are using a color display 
	 */
	same = 0;
	if (!queueicon->outer) {
		ii = 0;
		XtSetArg(args[ii], XtNborderWidth, (Dimension) 1);
		ii++;
		XtSetArg(args[ii], XtNorientation, XtorientVertical);
		ii++;
		XtSetArg(args[ii], XtNmappedWhenManaged, False);
		ii++;
		queueicon->outer = XtCreateManagedWidget(queueicon->name, boxWidgetClass,
							 iconwin, args, ii);
		queueicon->managed = 1;
		if (mapit(queueicon)) {
			XtMapWidget(queueicon->outer);
			queueicon->mapped = 1;
		} else {
			queueicon->mapped = 0;
		}

		ii = 0;
		queueicon->bgpixmap = XtCreateManagedWidget(queueicon->name,
			    commandWidgetClass, queueicon->outer, args, ii);
		XtAddCallback(queueicon->bgpixmap, XtNcallback, (XtCallbackProc) pushbutton_bgpmicon, (XtPointer) NULL);

		ii = 0;
		XtSetArg(args[ii], XtNorientation, XtorientHorizontal);
		ii++;
		XtSetArg(args[ii], XtNborderWidth, (Dimension) 0);
		ii++;
		XtSetArg(args[ii], XtNresizable, True);
		ii++;
		queueicon->info_form = XtCreateManagedWidget(queueicon->name,
				boxWidgetClass, queueicon->outer, args, ii);
		ii = 0;
		XtSetArg(args[ii], XtNborderWidth, (Dimension) 0);
		ii++;
		queueicon->info_label = XtCreateManagedWidget(INFOLABEL,
			  labelWidgetClass, queueicon->info_form, args, ii);
		sprintf(infostr, "%d/%d\n%.2f\n%s", queueicon->active_jobs, queueicon->max_jobs, queueicon->loadavg / 100.0, queueicon->state);
		infostr[strlen(infostr)] = 0;
		ii = 0;
		XtSetArg(args[ii], XtNborderWidth, (Dimension) 0);
		ii++;
		queueicon->info = XtCreateManagedWidget(infostr,
			  labelWidgetClass, queueicon->info_form, args, ii);
		ii = 0;
		queueicon->pushme = XtCreateManagedWidget("pushme",
			    commandWidgetClass, queueicon->outer, args, ii);
		XtAddCallback(queueicon->pushme, XtNcallback, (XtCallbackProc) pushbutton_pmicon, (XtPointer) NULL);
	} else if (!queueicon->mapped) {
		if (mapit(queueicon)) {
			XtMapWidget(queueicon->outer);
			queueicon->mapped = 1;
		}
	} else if (queueicon->mapped) {
		if (!mapit(queueicon)) {
			XtUnmapWidget(queueicon->outer);
			queueicon->mapped = 0;
		}
	}
	/*
	 * Adjust for a new name 
	 */
	if (strcmp(queueicon->name, queueicon->oldname)) {
		XtUnmanageChild(queueicon->pushme);
		ii = 0;
		XtSetArg(args[ii], XtNlabel, (String) queueicon->name);
		ii++;
		XtSetValues(queueicon->pushme, args, ii);
		strcpy(queueicon->oldname, queueicon->name);
		XtManageChild(queueicon->pushme);
		same = 1;
	}
	/*
	 * Update the status color of the background pixmap 
	 */

	bg = defaultbackground(iconwin);
	/*
	 * Find the background color of the icon 
	 */
	if (queueicon->idle)
		fg = getpixelval(getidlecolor());
	else if (queueicon->running)
		fg = getpixelval(getrunningcolor());
	else if (queueicon->suspended)
		fg = getpixelval(getsuspendedcolor());
	else if (queueicon->sus_on_comp)
		fg = getpixelval(getsuscompcolor());


	ii = 0;
	XtSetArg(args[ii], XtNbackground, bg);
	ii++;
	XtSetArg(args[ii], XtNforeground, fg);
	ii++;
	XtSetValues(queueicon->bgpixmap, args, ii);

	/* this is for not refreshing if the icons have not changed */

	if (strcmp(queueicon->oldstate, queueicon->state) || (same != 0)) {
		if (queueicon->pix) {
			XFreePixmap(XtDisplay(iconwin), queueicon->pix);
		}
		queuepix->pix_data.gc = get_graphics_context(queueicon->bgpixmap);
		queuepix->pix_data.width = 40;
		queuepix->pix_data.height = 32;
		queueicon->pix = create_machine_logo(queueicon->bgpixmap,
				      queuepix->pix_data.gc, (char *)queuepix->bits,
		       queuepix->pix_data.width, queuepix->pix_data.height);
		ii = 0;
		XtSetArg(args[ii], XtNbitmap, queueicon->pix);
		ii++;
		XtSetValues(queueicon->bgpixmap, args, ii);
	}
	/*
	 * Change the info label if needed 
	 */
	if ((queueicon->active_jobs != queueicon->old_active_jobs) ||
	    (queueicon->max_jobs != queueicon->old_max_jobs) ||
	    (queueicon->old_loadavg != queueicon->loadavg) ||
	    strcmp(queueicon->oldstate, queueicon->state)) {

	    sprintf(infostr, "%d/%d\n%.2f\n%s", queueicon->active_jobs, queueicon->max_jobs, queueicon->loadavg / 100.0, queueicon->state);
	    infostr[strlen(infostr)] = 0;
	    ii = 0;
	    XtSetArg(args[ii], XtNlabel, (String) infostr);
	    ii++;
	    XtSetValues(queueicon->info, args, ii);
	}
	/*
	 * XtSetArg(args[ii],XtNforeground,getpixelval("black")); ii++; 
	 */

	if (queueicon->alarm)
		bg = getpixelval(getalarmcolor());
	else
		bg = defaultbackground(iconwin);

	ii = 0;
	XtSetArg(args[ii], XtNbackground, bg);
	ii++;
	XtSetValues(queueicon->pushme, args, ii);

	queueicon->old_active_jobs = queueicon->active_jobs;
	queueicon->old_max_jobs = queueicon->max_jobs;
	queueicon->old_loadavg = queueicon->loadavg;
	strcpy(queueicon->oldstate, queueicon->state);


}

void UnMapIconWin()
{
	XtUnmapWidget(viewicon);
	XtUnmapWidget(iconwin);
}
void MapIconWin()
{
	XtMapWidget(iconwin);
	XtMapWidget(viewicon);
}
void background_refresh()
{

	/*
	 * Refresh the icon window in the background 
	 */

	refreshicons();

}

/***********************************************************
 * refreshicons - Updates the icon window 
 */
int refreshicons()
{
	char            buffer[MAX_STRING_SIZE];
	char            tmp_buffer[MAX_STRING_SIZE];
	char            tmp_buffer_char[MAX_STRING_SIZE];
	char            cmdline[MAX_STRING_SIZE];
	char           *iconptr;
	char           *tmpptr = NULL;
	char           *ptr1 = NULL;
	char           *ptr2 = NULL;
	char           *tmp_grp = NULL;
	int             ii;
	int             totalicons;
	FILE           *pfp;
	unsigned        jj;

	/*
	 * qconf -qmon returns all of icons and their current state 
	 */

	busycursor();
	sprintf(cmdline, "%s -cell %s -qmon", QCONF_BINARY,current_cell);
/*
	printf("refreshicons: %s\n",cmdline);
	if (!(pfp = popen(GETQUEUES, "r")))
*/
	if (!(pfp = popen(cmdline, "r")))
		logerr(ERROR_103);
	else {
	     totalicons = 0;
	     while (fgets(buffer, MAX_STRING_SIZE, pfp)) {
		   buffer[strlen(buffer) - 1] = 0;
		   sscanf(buffer, "\n%[^:]", tmp_buffer);
		   if (!strcmp(tmp_buffer, "###")) {
		      strcpy(tmp_buffer, "");
		      ptr1 = strstr(buffer, "::");
		      if (!ptr1) {
			 sscanf(buffer, SCANFORMAT,
				 queueicon[totalicons].magic_cookie,
			        &queueicon[totalicons].seqnum,
				 queueicon[totalicons].hostname,
				 queueicon[totalicons].name,
				&queueicon[totalicons].loadavg,
				&queueicon[totalicons].max_jobs,
				&queueicon[totalicons].active_jobs,
				 queueicon[totalicons].cmplx_list,
				 queueicon[totalicons].state,
				 tmp_buffer_char);
		      } 
		      else
			 sscanf(buffer, SCANFORMAT1,
				 queueicon[totalicons].magic_cookie,
				&queueicon[totalicons].seqnum,
				 queueicon[totalicons].hostname,
				 queueicon[totalicons].name,
				&queueicon[totalicons].loadavg,
				&queueicon[totalicons].max_jobs,
				&queueicon[totalicons].active_jobs,
				 queueicon[totalicons].state,
				 tmp_buffer_char);

		      ptr1 = NULL;

		      if (queueicon[totalicons].cmplx_list) {

			  ptr2 = strstr(queueicon[totalicons].cmplx_list, ",");
			  jj = strlen(queueicon[totalicons].cmplx_list);
			  if ((ptr1 = malloc(jj + 1)) == NULL) {
				printf(ERROR_104);
				exit(0);
			  }
			  bzero(ptr1, jj + 1);
			  strncpy(ptr1, queueicon[totalicons].cmplx_list, jj);
			  ptr1[jj] = 0;
			  while (ptr2) {
				jj = strlen(ptr1) - strlen(ptr2);
				if (tmp_grp)
				free(tmp_grp);
				if ((tmp_grp = malloc(jj + 1)) == NULL) {
				printf(ERROR_104);
				exit(0);
			  }
			  bzero(tmp_grp, jj + 1);
			  strncpy(tmp_grp, ptr1, jj);
			  tmp_grp[jj] = 0;


			  if (hteadd(tmp_grp)) {
			     tmp_grp[jj] = 0;
			     if ((tmpptr = malloc(jj + 1)) == NULL) {
				printf(ERROR_104);
				exit(0);
			     }
			     strncpy(tmpptr, tmp_grp, jj);
			     tmpptr[jj] = 0;
			     grouparray[totalgroups++] = tmpptr;
			/*
			 * add_to_setup (); 
			 */
			  }
			  ptr1 = strstr(ptr1, ",");
			  ptr1++;
			  ptr2 = NULL;
			  ptr2 = strstr(ptr1, ",");

		     }

		     jj = strlen(ptr1);

		     if (!ptr2) {
			if (tmp_grp)
			   free(tmp_grp);
			if ((tmp_grp = malloc(jj + 1)) == NULL) {
			    printf(ERROR_104);
			    exit(0);
			}
			bzero(tmp_grp, jj + 1);
			strncpy(tmp_grp, ptr1, jj);
			tmp_grp[jj] = 0;
		     }
		     jj = strlen(tmp_grp);

		     if (hteadd(tmp_grp)) {
			tmp_grp[jj] = 0;
			if ((tmpptr = malloc(jj + 1)) == NULL) {
			    printf(ERROR_104);
			    exit(0);
			}
			bzero(tmpptr, jj + 1);
			strncpy(tmpptr, tmp_grp, jj);
			tmpptr[jj] = 0;
			grouparray[totalgroups++] = tmpptr;
			/*
			 * add_to_setup (); 
			 */
		     }
		}
		ptr1 = ptr2 = NULL;

		/*
		 * Find the states of the queue 
		 */
		queueicon[totalicons].alarm =
			queueicon[totalicons].running =
			queueicon[totalicons].suspended =
			queueicon[totalicons].sus_on_comp =
				queueicon[totalicons].idle = False;

		if (queueicon[totalicons].state) {
		    if (ptr1 = strstr(queueicon[totalicons].state, "a"))
			queueicon[totalicons].alarm = True;
		    if (ptr1 = strstr(queueicon[totalicons].state, "r"))
		        queueicon[totalicons].running = True;
		    if (ptr1 = strstr(queueicon[totalicons].state, "s"))
			queueicon[totalicons].suspended = True;
		    if (ptr1 = strstr(queueicon[totalicons].state, "c"))
			queueicon[totalicons].sus_on_comp = True;
		    if (!(queueicon[totalicons].running || queueicon[totalicons].suspended || queueicon[totalicons].sus_on_comp))
			queueicon[totalicons].idle = True;
		}
		addicon(&queueicon[totalicons], &queuepix[getbmarr(&queueicon[totalicons])]);
		totalicons++;
	}
      }
      pclose(pfp);
      for (; totalicons < max_icons; totalicons++)
	if (queueicon[totalicons].mapped) {
	   XtUnmapWidget(queueicon[totalicons].outer);
	   queueicon[totalicons].mapped = 0;
	}
      }
      defaultcursor();
}


/***********************************************************
 * outputwinproc - This function is called every ICON_REFRESH_RATE
 *                milliseconds.
 */
XtTimerCallbackProc 
outputwinproc(XtPointer client_data,XtIntervalId *id)
{
	static unsigned int counter = 0;

	/*
	 * See if there is any stdout or stderr that needs to be redirected
	 * to the output window 
	 */
	updateoutputwindow();

	/*
	 * Create a recurring timer callback 
	 */
	if (counter == ICON_REFRESH_RATE) {
		XtAppAddTimeOut(app_context, OUTPUTWIN_REFRESH_RATE, (XtTimerCallbackProc) intervalproc, (XtPointer) NULL);
	} else {
		XtAppAddTimeOut(app_context, OUTPUTWIN_REFRESH_RATE, (XtTimerCallbackProc) outputwinproc, (XtPointer) NULL);
		counter++;
	}
}

/***********************************************************
 * initproc - This function is called every ICON_REFRESH_RATE
 *                milliseconds.
 */
XtTimerCallbackProc 
initproc(XtPointer client_data,XtIntervalId  *id)
{
	static unsigned int counter = 0;

	/*
	 * Refresh the icon window 
	 */

	UnMapIconWin();
	refreshicons();
	pb_setupcompact((Widget)NULL,(int) NULL,(caddr_t) NULL);
	MapIconWin();
	startup = 1;

	/*
	 * See if there is any stdout or stderr that needs to be redirected
	 * to the output window 
	 */
	updateoutputwindow();

	/*
	 * Create a recurring timer callback 
	 */
	XtAppAddTimeOut(app_context, OUTPUTWIN_REFRESH_RATE, (XtTimerCallbackProc) outputwinproc, (XtPointer) NULL);
}


/***********************************************************
 * intervalproc - This function is called every ICON_REFRESH_RATE
 *                milliseconds.
 */
XtTimerCallbackProc 
intervalproc(XtPointer client_data,XtIntervalId  *id)
{
	static unsigned int counter = 0;
	static unsigned int i = 0;

	/*
	 * Refresh the icon window 
	 */
	if ((counter % ICON_REFRESH_RATE) == 0) {
		refreshicons();
		counter = 0;
	}
	/*
	 * See if there is any stdout or stderr that needs to be redirected
	 * to the output window 
	 */
	updateoutputwindow();

	/*
	 * Create a recurring timer callback 
	 */
	XtAppAddTimeOut(app_context, OUTPUTWIN_REFRESH_RATE, (XtTimerCallbackProc) intervalproc, (XtPointer) NULL);
	counter++;
}



/***********************************************************
 * initgroup - Find the names of each different group
 * 	from qmon3.5 this will use complexes instead of groups
 */
int initgroup()
{
	char            errmsg[MAX_STRING_SIZE];
	char            buffer[MAX_STRING_SIZE];
	char            tmp_buffer[MAX_STRING_SIZE];
	char            buffer1[MAX_STRING_SIZE];
	char            cmdline[MAX_STRING_SIZE];
	char            dummys[MAX_STRING_SIZE];
	char            queue[MAX_STRING_SIZE];
	char           *groupname = NULL;
	char           *tmpptr = NULL;
	int             dummyi;
	int             ii;
	unsigned        jj;
	char           *ptr1 = NULL;
	char           *ptr2 = NULL;
	int             totalicons;
	FILE           *pfp;
	FILE           *bmfp1;
	STACK_NODE     *p=NULL;
	STACK_NODE     *q=NULL;
	STACK_NODE     *r=NULL;

	for (ii = 0; ii < MAX_GROUPS; ii++) {
		grouparray[ii] = (char *) NULL;
	}
	/*
	 * qconf -qmon returns all of icons and their current state 
	 */

        for( r = cell_list; r != NULL; r = r->next ) {

	    sprintf(cmdline, "%s -cell %s -qmon", QCONF_BINARY,r->name);

	    if (!(pfp = popen(cmdline, "r"))) {
		logerr(ERROR_109);
	    }
	    else {     /* main if loop */
	         totalicons = 0;
	         while (fgets(buffer, MAX_STRING_SIZE, pfp)) {  /* read file loop */
		       buffer[strlen(buffer) - 1] = 0;
		       sscanf(buffer, "\n%[^:]", tmp_buffer);
		       if (!strcmp(tmp_buffer, "###")) {  /* magic cookie */
	   	          strcpy(tmp_buffer, "");
		          ptr1 = strstr(buffer, "::");
		          if (!ptr1) {
			    q = (STACK_NODE *)malloc(sizeof(STACK_NODE));
			    if(q == NULL) {
	  		       printf(ERROR_105); exit(0);
			    }
			  p = (STACK_NODE *)malloc(sizeof(STACK_NODE));
			  if(p == NULL) {
	  		    printf(ERROR_105); exit(0);
			  }
		          sscanf(buffer, SCANFORMAT,
			       dummys,
			      &dummyi,
		              p->name,
			        queue,
			      &dummyi,
			      &dummyi,
			      &dummyi,
			   tmp_buffer,
			       dummys,
			       dummys);
 			  /* experiments with stack  */
	       		  /* push if stack_search fails */
			  sprintf(q->name,"%s@%s",queue,r->name);
	    		  if(!stack_search(&queue_list,q))
	    		     stack_push(&queue_list,q);
		

			  /* check if only one complex name */
		          if (tmp_buffer) {
			     ptr2 = strstr(tmp_buffer, ",");
			     jj = strlen(tmp_buffer);
			     if ((ptr1 = malloc(jj + 1)) == NULL) {
			        printf(ERROR_105);
				exit(0);
			     }
			     bzero(ptr1, jj + 1);
			     strncpy(ptr1, tmp_buffer, jj);
			     ptr1[jj] = 0;
			     while (ptr2) {
			         jj = strlen(ptr1) - strlen(ptr2);
				 if (groupname)
				    free(groupname);
				 if ((groupname = malloc(jj + 1)) == NULL) {
			        	printf(ERROR_105);
					exit(0);
				 }
				 bzero(groupname, jj + 1);
				 strncpy(groupname, ptr1, jj);
				 groupname[jj] = 0;

				 jj = strlen(groupname);
				 if (hteadd(groupname)) {
				    groupname[jj] = 0;
				    if ((tmpptr = malloc(jj + 1)) == NULL) {
			        	printf(ERROR_105);
					exit(0);
				    }
				    strncpy(tmpptr, groupname, jj);
				    tmpptr[jj] = 0;
				    grouparray[totalgroups++] = tmpptr;
				 }
				 ptr1 = strstr(ptr1, ",");
				 ptr1++;
				 ptr2 = NULL;
				 ptr2 = strstr(ptr1, ",");
			   }/* while(ptr2) loop */

			  jj = strlen(ptr1);
			  if (!ptr2) {
			     if (groupname)
				free(groupname);
			     if ((groupname = malloc(jj + 1)) == NULL) {
			        printf(ERROR_105);
				exit(0);
			     }
			     bzero(groupname, jj + 1);
			     strncpy(groupname, ptr1, jj);
			     groupname[jj] = 0;
			  }
			  jj = strlen(groupname);
			  if (hteadd(groupname)) {
			      groupname[jj] = 0;
			     if ((tmpptr = malloc(jj + 1)) == NULL) {
			        printf(ERROR_105);
				exit(0);
			     }
			     bzero(tmpptr, jj + 1);
			     strncpy(tmpptr, groupname, jj);
			     tmpptr[jj] = 0;
			     grouparray[totalgroups++] = tmpptr;
			  }
			  ptr1 = ptr2 = NULL;

		     }
	         } 

	      }/* end magic cookie */ 

	    }/* end read file loop */ 

	  pclose(pfp);

          } /* end main if loop */

        }  /* enf of for loop for cell_list */
}

/***********************************************************
 * getgroup - Return a pointer to the indexed group
 */
char *getgroup(int index)
{
	return grouparray[index];
}


/***********************************************************
 * unmanageallicons - Unmanage all of the queue icons
 */
int unmanageallicons()
{
	int             ii;

	/*
	 * Do this in reverse order because the RowColumn reordering is slow
	 * as sh*t!!! 
	 */
	for (ii = max_icons - 1; ii >= 0; ii--) {
		if (queueicon[ii].managed) {
			XtUnmanageChild(queueicon[ii].outer);
			queueicon[ii].managed = 0;
		}
	}
}


/***********************************************************
 * mapmanagedicons - Map all of the queue icons that are managed
 */
int mapmanagedicons()
{
	int             ii;

	for (ii = 0; ii < max_icons; ii++) {
		if (queueicon[ii].mapped) {
			XtManageChild(queueicon[ii].outer);
			queueicon[ii].managed = 1;
		}
	}
}


/**************
get_graphics_context ();
*********/

GC get_graphics_context(Widget w)
{


	int             n;
	Arg             wargs[5];
	GC              gc;
	XGCValues       values;

	n = 0;
	XtSetArg(wargs[n], XtNforeground, &values.foreground);
	n++;
	XtSetArg(wargs[n], XtNbackground, &values.background);
	n++;
	XtGetValues(w, wargs, n);

	gc = XtGetGC(w, GCForeground | GCBackground, &values);

	return gc;
}
/*
 * Create the machine log 
 */

Pixmap 
create_machine_logo(Widget w, GC gc,char *bits,int width,int height)
{
	Pixmap          bitmap, pix;
	/*
	 * Create a bitmap from the data. 
	 */
	bitmap = XCreateBitmapFromData(XtDisplay(w),
				       RootWindowOfScreen(XtScreen(w)),
				       bits, width, height);
	/*
	 * Create a pixmap of the same depth as the default screen. 
	 */
	pix = XCreatePixmap(XtDisplay(w),
			    RootWindowOfScreen(XtScreen(w)),
			    width, height,
			    DefaultDepthOfScreen(XtScreen(w)));
	/*
	 * Copy the contents of plane 1 of the bitmap to the pixmap, using
	 * the widget's colors. 
	 */
	XCopyPlane(XtDisplay(w), bitmap, pix, gc, 0, 0,
		   width, height, 0, 0, 1);
	/*
	 * We don't need the bitmap anymore, so free it. 
	 */
	XFreePixmap(XtDisplay(w), bitmap);
	return pix;
}

/***********************************************************
 * createimage - Create images to be used for background
 *               pixmaps
 */
XImage   *createimage(char *bits,int width,int height)
{
	XImage         *image;

	image = (XImage *) XtMalloc(sizeof(XImage));
	image->width = width;
	image->height = height;
	image->data = bits;
	image->depth = 1;
	image->xoffset = 0;
	image->format = XYBitmap;
	image->byte_order = LSBFirst;
	image->bitmap_unit = 8;
	image->bitmap_bit_order = LSBFirst;
	image->bitmap_pad = 8;
	image->bytes_per_line = (width + 7) / 8;
	return (image);
}
