static char display_rcsid[]="display.c,v 1.2 1994/11/28 16:54:49 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  display.c,v
 * Revision 1.2  1994/11/28  16:54:49  kerce
 * *** empty log message ***
 *
 * Revision 1.2  1994/09/13  18:01:59  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 *
 **********************************************************/

#include "globals.h"

static Display *display;
static int blackandwhite;
static int screen;
extern Widget toplevel;


/***********************************************************
 * initdisplay - Gets the values for display and screen
 */
void initdisplay()
{

  display=XtDisplay(toplevel);
  if(!display) {
    XtWarning("%s: can't open display, exiting...");
    exit (0);
  }
  
  /*
   * Get screen
   */
  screen=DefaultScreen(display);

  /*
   * Determine if we're using a monochrome monitor
   */
  if(DisplayPlanes(display,screen)==1) {
    blackandwhite=1;
  }

}


/***********************************************************
 * getdpy - Returns display for qmon
 */
Display *getdpy()
{
  return display;
}


/***********************************************************
 * getscr - Returns screen for qmon
 */
int getscr()
{
  return screen;
}


/***********************************************************
 * isblackandwhite - Returns 1 is monitor is monochrome
 */
int isblackandwhite()
{
  return blackandwhite==1;
}
