static char cwd_rcsid[]="cwd.c,v 1.2 1994/11/28 16:54:46 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *
 *  cwd.c,v
 * Revision 1.2  1994/11/28  16:54:46  kerce
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/13  18:01:59  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/21  02:57:09  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 **********************************************************/

#include "globals.h"
static Widget            cwd_popup;
static Widget           widget_cwdrc;
static Widget           widget_cwdlabel;
static Widget           widget_cwdframe;
static Widget           widget_cwdmenu;
static Widget           widget_cwdmain;
static Widget           widget_cwdexec;
static Widget           widget_cwdclear;
static Widget           widget_cwdclose;
static Widget           widget_cwdseparator;
static Widget           widget_cwdopt;

char *currentdirectory= NULL;

struct optionstruct cwdmenu[]={
  0,"New Directory",NULL,INPUTTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_cwdexec - Activate callback for exec
 */
XtCallbackProc pb_cwdexec(Widget w,caddr_t client_data,caddr_t call_data)
{
  char            *ptr=NULL;
  int    flag;

  ptr=QmonTextGetString(cwdmenu[0].widgetid);
  if((flag=chdir(ptr))==-1)
    fprintf(stderr,"cannot change directory to <%s>\n",ptr);
  else
    printf("cwd to %s\n",ptr);
  settitlebar();
}


/***********************************************************
 * pb_cwdclear - Activate callback for clear
 */
XtCallbackProc pb_cwdclear(Widget w,caddr_t client_data,caddr_t call_data)
{
  clearsubmenu(cwdmenu);
}


/***********************************************************
 * pb_cwdclose - Activate callback for close
 */

XtCallbackProc pb_cwdclose(Widget w,caddr_t client_data,caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_cwd_dialog - Create widgets used for the cwd menu
 */
void create_cwd_dialog(Widget w,XtPointer client_data,XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        cwd_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  currentdirectory=getcurdir();

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  cwd_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  cwd_form = XtCreateManagedWidget("form", formWidgetClass, cwd_popup,args,
ii);


  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_cwdlabel=
        XtCreateManagedWidget("Cwd",labelWidgetClass,cwd_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_cwdlabel); ii++;
  widget_cwdmain=XtCreateManagedWidget("box",formWidgetClass,cwd_form,
                                        args,ii);

 exec=QmonAddButtonN(widget_cwdmain,NULL,"Exec",(XtCallbackProc)pb_cwdexec,NULL);
 clear=QmonAddButtonN(widget_cwdmain,exec,"Clear",(XtCallbackProc)pb_cwdclear,NULL);
 close=QmonAddButtonN(widget_cwdmain,clear,"Close",(XtCallbackProc)pb_cwdclose,NULL);

  widget_cwdopt=createmenuoptions(cwd_form,widget_cwdmain,cwdmenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_cwd - Open the cwd menu
 */
void openwidget_cwd()
{
  XtPopup(cwd_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_cwd - Close the cwd menu
 */
void closewidget_cwd()
{
  XtPopdown(cwd_popup);
}
