#!/bin/csh

# this script can be submitted by "qsub generic.sh"
#
# or if you'd like to see what you are requesting "qsub -verify generic.sh"
# and of course you can add other stuff on the command line

# This script assumes the queues "ibm1" and "ds3" are set up
# and that there are at least 4 other queues set up with complexes
# with "mem" at least 128 amd "group=ibm"

# make the CWD same as now
#$ -cwd

# we are going to be running a "generic" parallel job and we want
# want instantiations on ALL hosts + starting the script

#$ -par generic_all


# alternately had we had only wanted instantiations only on the
# remote machines + starting the script we could have
#$ -par generic_sla

# we want the master to be either the queue "ibm1" or "ds3"
# only 1 "master" request is ever filled...
# Note that we want the "remote_info" filled in at runtime
# note also that you have the following wildcards available that will be
# filled in at runtime
# "%execer_id" "%master_host" "%my_hostname" "%my_nodenum" "%total_numnodes" "%remote_info"
# "%remote_info" is ignored by everyone except the "master"

#$ -master ibm11-exec.eq."/usr/local/DQS/bin/dqs_random3 ibm11 %remote_info",ds3-exec.eq."/usr/local/DQS/bin/dqs_random3 ds3 %remote_info"

# we need at least 4 more machines with at least 128 MB and of the
# group "ibm"

#$ -l qty.eq.4,mem.ge.128,group.eq.ibm,-exec.eq."/usr/local/DQS/bin/dqs_random3 im_hard -master_host %master_host -my_nodenum %my_nodenum more_args_if_you_like"



# if possible lets grab a couple extra queues IFF they are available
# but don't block the job waiting on them

#$ -soft -l qty.eq.2,mem.ge.128,group.eq.ibm,-exec.eq."/usr/local/DQS/bin/dqs_random3 im_soft -master_host %master_host -my_nodenum %my_nodenum more_args_if_you_like"



# now for the script

printenv

# note that we want the "REMOTE_INFO" filled in at runtime

/usr/local/DQS/bin/dqs_random3 $REMOTE_INFO

echo "bye"
