static char dqs_select_queue_rcsid[]="$Id: dqs_select_queue.c,v 1.1.1.1 1998/08/18 14:39:13 green Exp $";

/*----------------------------------------------------
 * dqs_select_queue.c Tom Green Mon Jan 31 10:43:01 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_select_queue.c,v $
 * Revision 1.1.1.1  1998/08/18 14:39:13  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.5  1998/08/11 14:00:00  hajnal@scientist.com
 * In dqs_select_queues() cleaned up mem leak. 
 * Inserted FREE(req_el.str0) in the else branch of "if(!rqp)"
 * Freed up the req_resources list at the end of each "while(qp)" cycle.
 *
 * Revision 1.4  1997/12/15 20:40:36  decker
 * Cleaned up Brackets to fix mem leak. (Ron Lee Idea)
 *
 * Revision 1.3  1997/10/15 19:14:31  decker
 * Quick mods, cleanup mostly
 *
 * Revision 1.2  1997/04/12 15:24:52  green
 * applied Martin Harriman's "consumable" patches:
 *
 *  1: When marching through the "consumable_used" list to
 *     remove all resources not relevant to the queue assigned,
 *     forgot do update the consumamble_used pointer itself..
 *
 *  2. When returning consumables forgot to check to see if
 *     one was actuallu used during the job before giving it
 *     back to the system.. thus sometimes causing an increase in
 *     the available consumambles.
 *
 * Revision 1.1.1.1  1997/04/10 15:10:34  green
 * DQS 3.1.3.4.1 Distribution
 *
 * Revision 3.17  1997/03/25 18:13:48  nrl
 * removed redundant definitions and some typing garbage
 *
 * Revision 3.16  1997/03/19 11:16:14  nrl
 * Several repairs courtesy of Marin Harriman..
 *
 * Revision 1.1  1997/02/14 21:16:09  martinh
 * Initial revision
 *
 * Revision 3.15  1996/11/20 22:07:05  nrl
 * Accidenrally overlayed REQUIRED complex code with OOOPS fix..
 * repaired.
 *
 * Revision 3.14  1996/08/26  14:21:00  nrl
 * Incorporated SCRI scheduling changes
 *
 * Revision 3.13  1996/07/19  12:04:06  nrl
 * Changes to fix "non existent resources"
 *
 * Revision 3.12  1996/06/27  01:56:01  nrl
 * changes to accomodate osf gcc
 *
 * Revision 3.11  1996/06/17  02:29:08  nrl
 * Updtaes from Guntram Wolski, Ron Lee, John Makosky and
 * Bodo Beckebach
 *
 * Revision 3.10  1996/04/11  12:12:23  nrl
 * Fixed compiling error discovered in alpha release
 *
 * Revision 3.9  1996/03/22  04:21:10  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.8  1996/03/21  17:07:07  nrl
 * added fortran and "c" syntax to resource requests
 *
 * Revision 3.7  1996/03/19  23:27:28  nrl
 * added capability to clean up consumable resources whenthey
 * get out of sync with reality
 *
 * Revision 3.6  1996/03/17  02:13:22  nrl
 * merged in "Frank Dwyer Fair Play" scheduling scheme to
 * qsub prevalidation process. Removed redundant mail at begining
 * case.
 *
 * Revision 3.5  1996/03/17  00:57:52  nrl
 * merge in qsub prevalidation scheme and consumable restoration
 *
 * Revision 3.4  1996/03/14  03:16:29  nrl
 * merge in subordinate queues and consumable resource changes
 *
 * Revision 3.3  1996/01/19  20:59:03  nrl
 * merged SCRI code and new job and queue structure changes
 *
 * Revision 3.2  1995/02/01  23:17:37  nrl
 * Tidied up and hopefully bulletproofed "tid" management. Reversed
 * tid file naming to sort by time.
 *
 * Revision 3.1  1994/06/03  03:44:05  green
 * updated to support p4/mpi
 *
 * Revision 3.0  1994/03/07  04:14:30  green
 * 3.0 freeze
 *
 * Revision 1.1.1.1  1994/02/01  17:57:46  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"











/************************************************************************/
void dqs_select_queues(req_lp, job)
     dqs_list_type *req_lp; /* linked list of requested resources */
     dqs_job_type  *job;
     /*
       dqs_select_queues - selects suitable queues based on requested resources vs
       specified complexes and consumables.
       
       dqs_select_queues updates the "suitable" field of the Queue_list based
       on the number of "hits" found in the request_chain.
     */
     
{
  
  dqs_list_type *cp;
  dqs_list_type *consp;
  dqs_list_type *qp;
  dqs_list_type *rp;
  dqs_list_type *complex_head;
  dqs_list_type *consumable_head;
  dqs_list_type *req_resources;
  dqs_list_type req_el;
  dqs_list_type *rqp;
  
  u_long32	    now;
  u_long32       old_suitable;
  
  
  DENTER((DQS_EVENT,"dqs_select_queues"));
  now=dqs_get_gmt();
  
  /* if no resource request chain we have been presented with the default  */
  /*    case of "qty.eq.nnn". We must then disqualify any queues which     */
  /*    have REQUIRED complexes.                                           */
  
  if(!req_lp){     
    qp=Queue_head;
    while (qp){
      if ( (job) && (qp->queue->last_user_delay> 0 ) ){
	if (qp->queue->last_user->user) {
	  if (!strcmp(qp->queue->last_user->user,job->owner)) {
	    if (now < qp->queue->last_user->int0) {
	      qp->queue->suitable= -999;  /* definitely NOT suitable */
	      DEXIT;
	      return;
	    }
	  }   
	}
      }
      cp=qp->queue->complex_list;
      while (cp){
	DPRINTF((DQS_EVENT,"searching for complex \"%s\"",cp->str0));
	if(!strcmp(cp->str0,"REQUIRED") ){
	  qp->queue->suitable= -999;  /* definitely NOT suitable */
	  break; /* try another queue */                        
	}
	cp=cp->next;
      }
      consp= qp->queue->consumables;
      while (consp){
	DPRINTF((DQS_EVENT,"searching for consumable \"%s\"",consp->str0));
	if(!strcmp(consp->str0,"REQUIRED")){
	  qp->queue->suitable= -999;   /* definitely not suitable  */
	  break;  /* try another queue   */
	}
	consp=consp->next;
      }
      qp=qp->next;	       
    }
    DEXIT;
    return;
  }   /*   if(!req_lp)     */
  
  
  
  req_resources= NULL;
  
  qp=Queue_head;     
  while (qp){ 
    
    if ( (job) && (qp->queue->last_user_delay> 0 ) ){
      if (qp->queue->last_user->user) {
	if (!strcmp(qp->queue->last_user->user,job->owner)) {
	  if (now < qp->queue->last_user->int0) {
	    qp=qp->next;
	    continue;
	  }
	}   
      }
    }
    
    rp= req_lp;
    while (rp){
      cp=qp->queue->complex_list;
      while (cp){
	bzero((char *)&req_el,sizeof(req_el));              
	DPRINTF((DQS_EVENT,"searching for complex \"%s\"",cp->str0));
	if(!strcmp(cp->str0,"REQUIRED") ){
	  cp=cp->next;   /* go to next name in string  */
	  /*Cleaned up brackets*/
	  if(!cp) {break;}
          /* add all unique required resource names to list  */
	  req_el.str0= dqs_string_insert( (char *) NULL, cp->str0);
	  rqp= dqs_locate_str0(req_resources, cp->str0);
	  DPRINTF((DQS_EVENT,"rqp= %08x %s",cp->str0));                        
	  if(!rqp){
	    req_resources=dqs_insert(DQS_STR0,TAIL,req_resources,&req_el);
	    DPRINTF((DQS_EVENT,"req_resources= %08x %s",req_resources));                                                	
	  }
	  /* Fix to memory hole. req_el.str0 must be free-d if unused. */
	  else{
	    FREE(req_el.str0);
	  } /* if(!rqp) */
	  /* EndFix */
	  old_suitable= qp->queue->suitable+1;
	}
	else {
	  DTRACE;
	  old_suitable=0;
	}
	complex_head=dqs_locate_complex(cp->str0);
	if (!complex_head){
	  ERROR((DQS_EVENT,"DQS_ERROR_0446 error: the complex \"%s\" does not exist",cp->str0));
	  cp=cp->next;
	  continue;
	}
	dqs_select_queue(rp,complex_head->chain,qp->queue);
	rqp= dqs_locate_str0(req_resources, cp->str0);
	/* mark required RESOURCE satisfied   */
	if(rqp){
	  DPRINTF((DQS_EVENT,"old=%d new=%d",old_suitable, qp->queue->suitable));                     /*Fix to brackets*/                        	
	  if(old_suitable <=qp->queue->suitable) {rqp->int0=1;}
	}
	cp=cp->next;
      }
      
      
      consp= qp->queue->consumables;
      while (consp){
	bzero((char *)&req_el,sizeof(req_el));              
	DPRINTF((DQS_EVENT,"searching for consumable \"%s\"",consp->str0));
	if(!strcmp(consp->str0,"REQUIRED")){
	  consp=consp->next;
	  if(!consp) {break;}
	  
          /* add all unique required resource names to list  */		    	
	  req_el.str0= dqs_string_insert( (char *) NULL, consp->str0);
	  rqp= dqs_locate_str0(req_resources, consp->str0);
	  if(!rqp){
	    req_resources=dqs_insert(DQS_STR0,TAIL,req_resources,&req_el);
	  }
	  /* Fix to memory hole. req_el.str0 must be free-d if unused. */
	  else {
	    FREE(req_el.str0);
	  } /* if(!rqp) */
	  /* EndFix */
	  old_suitable= qp->queue->suitable+1;
	}
	else { 
	  old_suitable=0;
	}
	consumable_head=dqs_locate_consumable(consp->str0);
	if (!consumable_head){
	  ERROR((DQS_EVENT,"DQS_ERROR_0447 error: the consumable \"%s\" does not exist",consp->str0));
	  consp=consp->next;
	  continue;
	}
	dqs_select_cons_queue(rp,consumable_head->chain,qp->queue,job);
	rqp= dqs_locate_str0(req_resources, consp->str0);
	/* mark required RESOURCE satisfied   */
	if(rqp){
	  if(old_suitable <=qp->queue->suitable) {rqp->int0=1;}
	}
	consp=consp->next;
	
      }
      rp=rp->next;
    }
    /* Fix to memory leak by saving req_resources ... */
    rqp=req_resources;
    
    if(req_resources){
      while(req_resources){
	DPRINTF((DQS_EVENT,"required= %d  %s",req_resources->int0, req_resources->str0));   
	if(req_resources->int0<=0) {qp->queue->suitable=-999;}
	req_resources= req_resources->next;
      }
    }
    qp=qp->next;	       	 
    /* ... and free-ing the allocated list: it must be done inside the "while(qp)" for each queue! */ 
    req_resources= dqs_free_list(rqp);
  }
  /* EndFix */
  
  DEXIT;
  return;
}


/************************************************************************/
void dqs_select_queue(req_lp,c_lp,q)
     dqs_list_type *req_lp; /* requested element */
     dqs_list_type *c_lp;   /* complex chain */
     dqs_queue_type *q;     /* queue */
     
     /*
       dqs_select_queue - updates suitable queues based on requested resources vs
       specified complexes.
       
       dqs_select_queue updates the "suitable" field of the queue if a hit is
       found in the request.
     */
     
{
  dqs_list_type *lp;
  
  DENTER((DQS_EVENT,"dqs_select_queue"));
  
  while (c_lp){
    DPRINTF((DQS_EVENT,">%s<>%s<",req_lp->str0,c_lp->str0));
    
    if (dqs_complex_el_suitable(req_lp,c_lp))  {q->suitable++;}
    c_lp=c_lp->next;
  }
  DEXIT;
  return;
}
/************************************************************************/
void dqs_select_cons_queue(req_lp,c_lp,q, job)
     dqs_list_type *req_lp; /* requested element */
     dqs_list_type *c_lp;   /* consumable */
     dqs_job_type  *job;
     dqs_queue_type *q;     /* queue */
     
     /*
       dqs_select_queue - updates suitable queues based on requested resources vs
       specified consumable.
       
       dqs_select_queue updates the "suitable" field of the queue if a hit is
       found in the request.
     */
     
{
  dqs_list_type *lp;
  dqs_list_type listel;
  int amount;
  
  DENTER((DQS_EVENT,"dqs_select_cons_queue"));
  bzero((char *)&listel,sizeof(listel));
  while (c_lp){
    DPRINTF((DQS_EVENT,">%s<>%s<",req_lp->str0,c_lp->str0));
    
    if (amount=dqs_cons_el_suitable(req_lp,c_lp))
      {  q->suitable++;
      listel.str0=dqs_string_insert(NULL,req_lp->str0);
      listel.str1= dqs_string_insert(NULL,q->qname);
      listel.int0= amount;
      job->consumable_resources_used =dqs_insert(DQS_STR0,TAIL,job->consumable_resources_used,  &listel);
      
      }                
    c_lp=c_lp->next;
  }
  DEXIT;
  return;
}

/************************************************************************/
int dqs_complex_el_suitable(req_lp,c_lp)
     dqs_list_type *req_lp; /* requested element */
     dqs_list_type *c_lp;   /* complex element */
     
     /*
       dqs_complex_el_suitable - determines whether a complex element actually
       fits a request.
       
       
       returns 0 on failure; 1 on success
       
     */
     
{
  
  DENTER((DQS_EVENT,"dqs_complex_el_suitable"));
  
  if (!req_lp->str0)
    {
      DPRINTF((DQS_EVENT,"empty request string, assume true match"));
      DEXIT;
      return(1);
    }
  
  
  DPRINTF((DQS_EVENT,">>%s<<>>%s<<",req_lp->str0,c_lp->str0));
  if (!dqs_wildmat(req_lp->str0,c_lp->str0))
    {
      DPRINTF((DQS_EVENT,">>%s<<DOES NOT MATCH>>%s<<",req_lp->str0,c_lp->str0));
      DEXITE;
      return(0);
    }
  
  /* note that the complex_el->int0 cannot == 0 by definition */
  if ((req_lp->int0)&&(c_lp->int0))
    {
      if ((req_lp->int1==EQ_OP)&&(c_lp->int0==req_lp->int0))
	{
	  DEXIT;
	  return(1);
	}
      if ((req_lp->int1==GE_OP)&&(c_lp->int0>=req_lp->int0))
	{
	  DEXIT;
	  return(1);
	}
      if ((req_lp->int1==GT_OP)&&(c_lp->int0>req_lp->int0))
	{
	  DEXIT;
	  return(1);
	}
      if ((req_lp->int1==LT_OP)&&(c_lp->int0<req_lp->int0))
	{
	  DEXIT;
	  return(1);
	}
      if ((req_lp->int1==LE_OP)&&(c_lp->int0<=req_lp->int0))
	{
	  DEXIT;
	  return(1);
	}
      if ((req_lp->int1==NE_OP)&&(c_lp->int0!=req_lp->int0))
	{
	  DEXIT;
	  return(1);
	}
    }
  
  if (req_lp->str1&&c_lp->str1)
    {
      DPRINTF((DQS_EVENT,"\n>>>>>>%s<<<<<<<<<<>>>>>>%s<<<<<<<<<<\n",req_lp->str1,c_lp->str1));
      if (dqs_wildmat(req_lp->str1,c_lp->str1))
	{
	  if (req_lp->int1==EQ_OP)
	    {
	      DEXIT;
	      return(1);
	    }
	  else
	    {                   
	      DEXIT;
	      return(0);
	    }
	}
      else
	{
	  if (req_lp->int1==EQ_OP)
	    {
	      DEXIT;
	      return(0);
	    }
	  else
	    {
	      DEXIT;
	      return(1);
	    }
	}
    }
  
  
  /*?*/
  if (!req_lp->str1&&!c_lp->str1&&!req_lp->int0&&!c_lp->int0)
    {
      DEXIT;
      return(1);
    }
  
  DEXITE;
  return(0);
  
}
/************************************************************************/
int dqs_cons_el_suitable(req_lp,cons_lp)
     dqs_list_type *req_lp; /* requested element */
     dqs_list_type *cons_lp;   /* consumable element */
     
     /*
       dqs_consumable_el_suitable - determines whether a consumable element actually
       fits a request.
       
       returns 0 on failure; non-zero amount requested on success
       
     */
     
{
  string tstr;
  char *tptr;
  DENTER((DQS_EVENT,"dqs_consumable_el_suitable"));
  
  if (!req_lp->str0){
    DPRINTF((DQS_EVENT,"empty request string, assume true match"));
    DEXIT;
    return(1);
  }
  strcpy(tstr,cons_lp->str0);
  tptr= strtok(tstr," \n");
  DPRINTF((DQS_EVENT,">>%s<<>>%s<<",req_lp->str0,tstr));
  if (!dqs_wildmat(req_lp->str0,tstr)) {
    DPRINTF(( DQS_EVENT,">>%s<<DOES NOT MATCH>>%s<<\n",req_lp->str0,cons_lp->str0));
    DEXITE;
    return(0);
  }
  
  
  if( cons_lp->int0 ==0)  {
    DPRINTF(( DQS_EVENT,"consumable is empty%s",req_lp->str0));
    DEXITE;
    return(0);
  }
  DPRINTF((DQS_EVENT,"request=%d current=%d",req_lp->int0, cons_lp->int2));     
  if (req_lp->int0 <= 0) {
    if (cons_lp->int2 > 0) {
      return 1;
    }       
    return 0;
  }
  
  if( req_lp->int0 <= cons_lp->int2){
    DPRINTF(( DQS_EVENT,"consumable O..K %s",req_lp->str0));
    DEXIT;
    return(req_lp->int0);   /* return amount of requested resource */     	  
  }
  DPRINTF((DQS_EVENT,"no match exit"));     
  DEXIT;
  return(0);
}

/*****************************************************************/
int dqs_tag_queues( job, qty, exec_str,  length)
     dqs_job_type *job;
     int qty;
     char *exec_str;
     int length;
{
  /*
    dqs_tag_queues - tags queues which are suitable for specified job
    
    should the "suitable" field of the queue be equal to the "length"
    of the requested resources, said queue is a possible match for the
    job.  However, we must also verify the queue is available, has open
    slots and that the user is a vaild user of said queue.
    
    dqs_tag_queues attempts to fill the request with as many different
    queues as possible.
    
    returns number of slots filled.
  */
  
  int hit       =TRUE;
  u_long32      now;
  dqs_list_type *lp;
  dqs_list_type listel;
  
  DENTER((DQS_EVENT,"dqs_tag_queues"));
  
  now=dqs_get_gmt();
  
  while (qty&&hit) {
    hit=FALSE;
    lp=Queue_head;
    while (lp) {
      if (lp->queue->suitable==length){
	if (dqs_queue_available(lp->queue)) {
	  lp=lp->next;
	  continue;
	}
	
	if (!dqs_valid_queue_user(job->owner,lp->queue)) {
	  lp=lp->next;
	  continue;
	}
	DTRACE;
	DPRINTF((DQS_EVENT,"\"%s\" is tagged",lp->queue->qname));
	bzero((char *)&listel,sizeof(listel));
	listel.str0=dqs_string_insert(NULL,lp->queue->qname);
	listel.str1=dqs_string_insert(NULL,lp->queue->qhostname);
	listel.str2=dqs_string_insert(NULL,exec_str);
	listel.int0=GRANTED;
	job->granted_destin_identifier_list=dqs_insert(DQS_STR0,TAIL,
						       job->granted_destin_identifier_list,  &listel);
	hit=TRUE;
	lp->queue->tagged++;
	qty--;
      }
      if (!qty) {
	DEXIT;
	return(qty);
      }
      lp=lp->next;
    }
  }
  if (qty) {
    DEXITE;
    return(qty);
  }
  
  DEXIT;
  return(qty);
}

/*****************************************************************/
void dqs_clear_suitability()
     
     /*
      * dqs_clear_suitability - clears the "suitability field on all queues.
      */
     
{
  
  dqs_list_type *lp;
  
  DENTER((DQS_EVENT,"dqs_clear_suitability"));
  
  lp=Queue_head;
  while (lp)
    {
      lp->queue->suitable=0;
      lp=lp->next;
    }
  
  DEXIT;
  return;
  
}

/*****************************************************************/
int dqs_queue_available(q)
     dqs_queue_type *q;
     
{
  
  u_long32 now;
  
  DENTER((DQS_EVENT,"dqs_queue_available"));
  
  now=dqs_get_gmt();
  
  if (VALID(UNKNOWN,q->state))
    {
      DEXITE;
      return(-1);
    }
  
  if (VALID(DISABLED,q->state))
    {
      DEXITE;
      return(-1);
    }
  
  if (VALID(SUSPENDED,q->state))
    {
      DEXITE;
      return(-1);
    }
  
  if (VALID(SUBORDINATED,q->state))
    {
      DEXITE;
      return(-1);
    }
  
  if ((q->qty_active+q->tagged)>=q->qty)
    {
      DEXITE;
      return(-1);
    }
  
  DEXIT;
  return(0);
}
/*************************************************************/
void dqs_mark_subordinated( q)
     dqs_queue_type *q;
     
{
  dqs_queue_type *mrk_q;
  dqs_list_type *sub_list;
  
  DENTER((DQS_EVENT,"dqs_mark_subordinated"));
  if( !q->subordinate_list) return;
  
  sub_list= q->subordinate_list;
  
  while(sub_list){
    mrk_q= dqs_locate_queue( sub_list->str0);
    if (!mrk_q) {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0448 error: unable to locate queue \"%s\"",sub_list->str0));
      DEXITE;
      return;
    }
    dqs_signal_queue(DQS_SIGSTOP, mrk_q,0);
    CLEARBIT(RUNNING,mrk_q->state); 
    SETBIT(SUSPENDED,mrk_q->state);
    SETBIT(SUBORDINATED,mrk_q->state);
    dqs_write_queue_to_disk(mrk_q);
    sub_list= sub_list->next;
  }
}
/****************************************************************************/
void dqs_clear_subordinated(q)
     dqs_queue_type *q;
{
  dqs_queue_type *mrk_q;
  dqs_list_type *sub_list;
  
  DENTER((DQS_EVENT,"dqs_mark_subordinated"));
  if( !q->subordinate_list) return;
  
  sub_list= q->subordinate_list;
  
  while(sub_list){
    mrk_q= dqs_locate_queue( sub_list->str0);
    if (!mrk_q) {
      CRITICAL((DQS_EVENT,"DQS_ERROR_0449 error: unable to locate queue \"%s\"",sub_list->str0));
      DEXITE;
      return;
    }
    dqs_signal_queue(DQS_SIGCONT, mrk_q,0);
    SETBIT(RUNNING,mrk_q->state); 
    CLEARBIT(SUSPENDED,mrk_q->state);
    CLEARBIT(SUBORDINATED,mrk_q->state);
    dqs_write_queue_to_disk(mrk_q);
    sub_list= sub_list->next;
  }
}

/*******************************************************************/
int dqs_consume_resource(job)
     dqs_job_type *job;
{
  dqs_list_type *lp;
  dqs_list_type *cons_lp;
  dqs_list_type  *cp;
  dqs_list_type *prev;
  DENTER((DQS_EVENT,"dqs_consume_resource"));
  lp= job->consumable_resources_used;
  prev = NULL;
  while(lp){
    /* discard consumable entries for all but seected queue */
    DPRINTF((DQS_EVENT,"consumables_used=%s",lp->str1));                
    if(strcmp(lp->str1,job->master_queue)){
      cp = lp->next;
      if (prev) {
	prev->next = cp;
      }else {
	job->consumable_resources_used = cp;
      }
      lp->next = NULL;
      dqs_free_list(lp);
      lp = cp;
      continue;
    }
    cons_lp=dqs_locate_consumable(lp->str0);
    if (!cons_lp){
      ERROR((DQS_EVENT,"DQS_ERROR_0450 error: the consumable \"%s\" does not exist",lp->str0));
      cp = lp->next;
      if (prev) {
	prev->next = cp;
      }else {
	job->consumable_resources_used = cp;
      }
      lp->next = NULL;
      dqs_free_list(lp);
      lp = cp;
      continue;
    }
    cp= cons_lp->chain;
    if(!cp){
      ERROR((DQS_EVENT,"DQS_ERROR_0451 error: consumable chain corrupt %s",lp->str0));
      cp = lp->next;
      if (prev) {
	prev->next = cp;
      }else {
	job->consumable_resources_used = cp;
      }
      lp->next = NULL;
      dqs_free_list(lp);
      lp = cp;
      continue;
    }
    DPRINTF((DQS_EVENT,"reducing current %d", cp->int2));		    
    cp->int2= cp->int2-lp->int0; /* reduce current amount*/
    if(cp->int2 <0) {cp->int2 =0;} /* cannot be negative  */
    dqs_replace_consumable(cons_lp);
    prev = lp;
    lp = lp->next;
  }
  DEXIT;
  return 0;
}

/********************************************************/
int dqs_restore_consumable(job)
     dqs_job_type *job;
{
  dqs_list_type *lp;
  dqs_list_type *cons_lp;
  dqs_list_type *cp;
  DENTER((DQS_EVENT,"dqs_restore_consumable"));
  lp= job->consumable_resources_used;
  
  while(lp){
    cons_lp=dqs_locate_consumable(lp->str0);
    if (!cons_lp){
      ERROR((DQS_EVENT,"DQS_ERROR_0452 error: the consumable \"%s\" does not exist",lp->str0));
      lp=lp->next;
      continue;
    }
    cp= cons_lp->chain;
    if (lp->int0) {
      cp->int2 += lp->int0; /* update consumable*/
    } else {
      cp->int2 += 1;
    }                     
    if(cp->int2 > cp->int0) {
      cp->int2 =cp->int0;
    }  /* cannot exceed available */
    dqs_replace_consumable(cons_lp);
    lp= lp->next;
  }
  DEXIT;
  return 1;
}		


/******************************************************************/
int dqs_return_consumable(job, cname,  amount)
     dqs_job_type *job;
     char *cname;
     int amount;
{
  dqs_list_type *cons_lp;
  dqs_list_type *lp;
  dqs_list_type *cp;
  DENTER((DQS_EVENT,"dqs_return_consumable"));
  
  cons_lp=dqs_locate_consumable(cname);
  if (!cons_lp){
    ERROR((DQS_EVENT,"DQS_ERROR_0453 error: the consumable \"%s\" does not exist",lp->str0));
    DEXITE;		 
    return 0;
  }
  cp= cons_lp->chain;
  cp->int2= cp->int2 + amount; 
  /* cannot exceed available */        
  if(cp->int2 > cp->int0) { cp->int2 =cp->int0;} 
  dqs_replace_consumable(cons_lp);
  
  /* update the job's values for this consumable */
  if(job){
    
    lp= job->consumable_resources_used;
    while(lp){
      if( !strcmp(lp->str0, cname) ) {lp->int2= lp->int2 - amount;}
      if(lp->int2 <0 ) {lp->int2=0;}
      dqs_write_job_to_disk(job);
      lp= lp->next;
    }
  }
  DEXIT;
  return 1;
}		



/************************************************************/
int dqs_reset_consumable(cname)
     char *cname;
{
  dqs_list_type *cons_lp;
  dqs_list_type *cp;
  DENTER((DQS_EVENT,"dqs_reset_consumable"));
  cons_lp=dqs_locate_consumable(cname);
  if (!cons_lp){
    ERROR((DQS_EVENT,"DQS_ERROR_0454 error: the consumable \"%s\" does not exist",cons_lp->str0));
    return;		 
  }
  cp= cons_lp->chain;
  cp->int2= cp->int0;  /* restore to available */
  dqs_replace_consumable(cons_lp);
  DEXIT;
  return;
}	    

/*********************************************************************/
int dqs_validate_resources(job, missing_resources)
     dqs_job_type *job;
     dqs_list_type *missing_resources;
{
  /*  this routine pre-validates the submitted jobrequest before  */
  /* committing it to the queueing system						 */
  /*  this is a kind of fuzzy mirror of dqs_do_schedule			 */
  
  dqs_list_type  *lp1;
  dqs_list_type  *lp2;
  dqs_list_type  listel;
  dqs_list_type  *cp;
  dqs_list_type  *qjobp;
  dqs_list_type  *consp;
  dqs_list_type *complex_head;
  dqs_list_type *consumable_head;
  dqs_list_type *qp;
  
  int found, found_count,errors, searched;
  int max_jobs_permitted, jobs_running; 
  string str1, str2, tstr;
  char *  tptr;
  
  DENTER((DQS_EVENT,"dqs_validate_resources"));
  
  bzero((char *)&listel,sizeof(listel) );
  
  /* first check hard master request  */
  errors=0;
  max_jobs_permitted= conf.maxujobs; /* system wide maximum */
  lp1= job->hard_master_list;
  if(!lp1) {
    found= TRUE;
  } else {
    found= FALSE;
  }
  strcpy(str1,"Hard Master ");
  DPRINTF((DQS_EVENT,"hard_master_list= %08x",lp1));
  while(lp1){
    lp2= Queue_head;
    while(lp2){
      if(dqs_wildmat(lp1->str0, lp2->queue->qname) ){
	max_jobs_permitted = lp2->queue->max_user_jobs; 
	found=TRUE;
	break;
      }
      lp2=lp2->next;
    }
    if(found) {break;}
    /* build error string in case we need it */
    strcat(str1, lp1->str0);
    strcat(str1," ");
    lp1= lp1->next;
  }
  
  if(!found){
    listel.str0=dqs_string_insert(NULL,str1);
    missing_resources= dqs_insert(DQS_STR0,TAIL,missing_resources,  &listel);
    DPRINTF((DQS_EVENT,"no hard resource = %s",listel.str0));                                 
    DEXITE;
    return 0;
  }                                 
  
  /* check hard queue requests           */
  lp1= job->hard_queue_list;
  DPRINTF((DQS_EVENT,"Hard queue request %08x",lp1));
  if(!lp1) {
    found=TRUE;
  }else {
    found= FALSE;
  }
  strcpy(str1,"Hard queue ");
  while(lp1){
    lp2= Queue_head;
    while(lp2){
      if(dqs_wildmat(lp1->str0, lp2->queue->qname) ){
	if(max_jobs_permitted >  lp2->queue->max_user_jobs){
	  max_jobs_permitted= lp2->queue->max_user_jobs; 
	}	
	found=TRUE;
	break;
      }
      lp2= lp2->next;
    }
    if(found) {break;}
    /* build error string in case we need it */
    strcat(str1, lp1->str0);
    strcat(str1," ");
    lp1= lp1->next;
  }
  
  if(!found){
    listel.str0=dqs_string_insert(NULL,str1);
    missing_resources= dqs_insert(DQS_STR0,TAIL,missing_resources,  &listel);
    DPRINTF((DQS_EVENT,"no hard queue = %s",listel.str0));
    DEXITE;
    return 0;
  }                                 
  
  /** check for hard resource requests    ***/
  
  lp1= job->hard_resource_list;
  
  if(lp1) {lp1=lp1->chain;}
  if(!lp1) 
    {found=1;}   /* no request so the search is satistfied */
  
  else {found= 0;}
  
  
  strcpy(str1,"Hard Resource ");
  searched=0;
  found_count=0;
  while (lp1){
    
    /* check for default qty.eq.1 case  */
    if(!strcmp(lp1->str0,"qty") ){
      if( (lp1->int0==1 )&&(lp1->str1==NULL) ){
	found++;
	found_count++;
	searched++;
	continue;
      }
    }
    
    qp=Queue_head;
    while (qp){
      
      cp=qp->queue->complex_list;
      while (cp){
	if(!strcmp(cp->str0,"REQUIRED")){
	  cp=cp->next;
	  if(!cp) {break;}
	}
	DPRINTF((DQS_EVENT,"searching for complex \"%s\"",cp->str0));
	complex_head=dqs_locate_complex(cp->str0);
	if (!complex_head){
	  ERROR((DQS_EVENT,"DQS_ERROR_0455 error: the complex \"%s\" does not exist",cp->str0));
	  cp=cp->next;
	  continue;
	}
	lp2=complex_head->chain;
	while(lp2){
	  if (dqs_complex_el_suitable(lp1,lp2)){
	    
	    found++;
	    break;
	  }
	  lp2= lp2->next;
	}
	if(found)  {break;}
	cp=cp->next;		/* try next complex  */
      }
      if(found) {break;}
      /* look in the consumables list    */
      
      
      consp= qp->queue->consumables;
      while (consp){
	if(!strcmp(consp->str0,"REQUIRED")){
	  consp=consp->next;
	  if(!consp) {break;}
	}
	DPRINTF((DQS_EVENT,"searching for consumable \"%s\"",consp->str0));
	consumable_head=dqs_locate_consumable(consp->str0);
	if (!consumable_head){
	  ERROR((DQS_EVENT,"DQS_ERROR_0456 error: the consumable \"%s\" does not exist",consp->str0));
	  DPRINTF((DQS_EVENT,"no consumable  resource = %s",consp->str0));  
	  consp=consp->next;
	  continue;
	}
	lp2=consumable_head->chain;
	while(lp2){
	  
	  strcpy(tstr,lp2->str0);
	  tptr= strtok(tstr," \n");
	  DPRINTF((DQS_EVENT,">>%s<<>>%s<<",lp1->str0,tstr));
	  if (!dqs_wildmat(lp1->str0,tstr)) {
	    DPRINTF(( DQS_EVENT,">>%s<<DOES NOT MATCH>>%s<<\n",lp1->str0,lp2->str0));
	  }
	  else{
	    DPRINTF((DQS_EVENT,"found cons"));  	                	
	    found++;
	    break;
	  }
	  lp2= lp2->next;
	}
	if(found)  {break;}
	consp=consp->next;
      }
      if(found) {break;}
      qp=qp->next;
    }
    if(found){
      found_count++;
      DPRINTF((DQS_EVENT,"found count= %d",found_count))         
	if(max_jobs_permitted> qp->queue->max_user_jobs)
	  {max_jobs_permitted= qp->queue->max_user_jobs;}
    }
    else{
      strcat(str1,lp1->str0);
      strcat(str1," ");		/*  add unfound resource  */
    }
    searched++;
    DPRINTF((DQS_EVENT,"searched=%d", searched));	  
    lp1= lp1->next;
  }
  DPRINTF((DQS_EVENT," found=%d searched=%d", found_count, searched));     
  if(found_count!= searched){
    listel.str0=dqs_string_insert(NULL,str1);
    missing_resources= dqs_insert(DQS_STR0,TAIL, missing_resources,  &listel);
    DPRINTF((DQS_EVENT,"no resource = %s",listel.str0));
    DEXITE;
    return 0;
  }
  
#ifdef SCRI
  /******   check for scheduling exclusions      *******/
  /*** the following is an example used by SCRI   *******/
  /*   a user may not submit a job is they have *******/
  /**  a number of jobs executing equal to or greater  ***/
  /**  than the small MAX USER JOBS permitted    ******/
  /**  in queues for which this submitted jobs is eleigile **/
  /** this may sound convoluted but it provides a  ******/
  /** fair use policy for heterogeneous collectios   ****/
  /** of systems and users                           ****/
  /*** if you wish to understand the philopsophy     ****/
  /*** consult the documentation or contact either   ****/
  /***  jeff bauer (jtbauer@scri.fsu.edu)  or        ****/
  /***  frank dwyer (dwyer@scri.fsu.edu)             *****/
  
  /** at this point we know the limit of jobs which  ****/
  /*** we will accept for this user                   ****/
  /* now count the jobs actually running for this user ***/
  
  qjobp= Job_head;
  jobs_running=0;
  while(qjobp){
    if( qjobp->job->uid == job->uid ){
      if(qjobp->job->status==RUNNING) {jobs_running++;}
    }
    qjobp= qjobp->next;
  }
  
  if(jobs_running>= max_jobs_permitted){
    sprintf(str1,"job will exceed max jobs %d allowed for this user.\nJob will not be scheduled until number of running jobs equals %d",max_jobs_permitted,max_jobs_permitted);
    listel.str0=dqs_string_insert(NULL,str1);
    missing_resources= dqs_insert(DQS_STR0,TAIL,missing_resources,  &listel);
    DEXITE;
    return 0;
  }
  
#endif
  
  DEXIT;
  return 1;
  
}





























