static char dqs_queue_rcsid[]="$Id: dqs_queue.c,v 1.1.1.1 1998/08/18 14:39:12 green Exp $";

/*----------------------------------------------------
 * dqs_queue.c Tom Green Mon Jan 31 10:42:57 1994
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 * $Log: dqs_queue.c,v $
 * Revision 1.1.1.1  1998/08/18 14:39:12  green
 * DQS 3.2.0.5 WIP Import
 *
 * Revision 1.2  1997/04/10 15:33:27  green
 * commited nrl's last_user initialization fix
 *
 * Revision 3.9  1997/04/02 14:43:41  nrl
 * last_user was not initialized.. caused crashes when
 * last_user_delay was non zero.
 *
 * Revision 3.8  1996/08/26  14:20:52  nrl
 * Incorporated SCRI scheduling changes
 *
 * Revision 3.7  1996/03/22  04:20:58  nrl
 * Added error cataloguing number to all routines
 *
 * Revision 3.6  1996/03/19  23:27:22  nrl
 * added capability to clean up consumable resources whenthey
 * get out of sync with reality
 *
 * Revision 3.5  1996/02/19  19:02:18  nrl
 * added a separate subpriority field, pluys scheduling_flags and
 * job_seq_number to remove the 3.1.2.4 kludges , modified the
 * scheduling algorith once again
 *
 * Revision 3.4  1996/01/19  20:58:58  nrl
 * merged SCRI code and new job and queue structure changes
 *
 * Revision 3.3  1995/05/29  18:08:53  nrl
 * More solaris stuff GAGGHH had to differentiate more cases of
 * solaris2.3 and solaris2.4 stuff
 *
 * Revision 3.2  1995/05/14  18:28:53  nrl
 * Plugged one hole in dqs_execd and qmaster handhsaking...
 * added gethostbyname calls to overcome problems with some
 * systems
 *
 * Revision 3.1  1995/02/22  14:29:31  nrl
 * added "FREE" macro to make sure all freed pointers are NULL,
 * replaced all calls to free( ) with FREE.
 *
 * Revision 3.0  1994/03/07  04:14:19  green
 * 3.0 freeze
 *
 * Revision 1.2  1994/02/02  20:22:15  green
 * cleaned up "qconf.c" to sync with docs
 *
 * Revision 1.1.1.1  1994/02/01  17:57:45  green
 * DQS 3.0 ALPHA
 *
 *--------------------------------------------------*/


#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "dqs_errno.h"

/**********************************************************************/
char *dqs_write_qconf(write_2_stdout,file_prefix,file_name,q)
     int            write_2_stdout;
     char           *file_prefix;
     char           *file_name;
     dqs_queue_type *q;
     
{
  FILE          *fp;
  char          *cp=NULL;
  string        str;
  dqs_list_type *tmp;
  
  DENTER((DQS_EVENT,"dqs_write_qconf"));
  
  if (write_2_stdout)
    {
      fp=stdout;
    }
  else
    {
      if (!file_name)
	{
	  cp=(char *)tmpnam(str);
	  if (!cp)
	    {
	      CRITICAL((DQS_EVENT,"DQS_ERROR_0346 error: generating tmpnam()"));
	      abort();
	    }
	  sprintf(str,"%s",cp);
	}
      else if (file_prefix)
	sprintf(str,"%s/%s",file_prefix,file_name);
      else
	sprintf(str,"%s",file_name);
      
      fp = fopen(str,"w");
      if (!fp) {
	CRITICAL((DQS_EVENT,"DQS_ERROR_0347 error writing %s\n",str));
	DEXITE;
	abort();
      }
    }
  
  fprintf(fp,"Q_name           %s\n",q->qname);
  fprintf(fp,"hostname         %s\n",q->qhostname);
  fprintf(fp,"seq_no           %d\n",q->seq_no);
  fprintf(fp,"load_masg        %d\n",q->load_massage);
  fprintf(fp,"load_alarm       %d\n",q->load_alarm);
  fprintf(fp,"priority         %d\n",q->priority);
  fprintf(fp,"type             %s\n",queue_type[q->qtype]);
  fprintf(fp,"rerun            %s\n",true_false[q->rerun]);
  fprintf(fp,"quantity         %d\n",q->qty);
  fprintf(fp,"tmpdir           %s\n",q->tmpdir);
  fprintf(fp,"shell            %s\n",q->shell);
  fprintf(fp,"klog             %s\n",q->klog);
  fprintf(fp,"reauth_time      %d\n",q->reauth_time);
  fprintf(fp,"last_user_delay  %d\n",q->last_user_delay);
  fprintf(fp,"max_user_jobs    %d\n",q->max_user_jobs);     
  fprintf(fp,"notify           %d\n",q->notify);
  fprintf(fp,"owner_list       ");
  tmp=q->owner_list;
  if (!tmp)
    fprintf(fp,"NONE");
  else
    {
      while (tmp)
	{
	  fprintf(fp,"%s ",tmp->str0);
	  tmp=tmp->next;
	}
    }
  fprintf(fp,"\n");
  
  fprintf(fp,"user_acl         ");
  tmp=q->acl;
  if (!tmp)
    fprintf(fp,"NONE");
  else
    {
      while (tmp)
	{
	  fprintf(fp,"%s ",tmp->str0);
	  tmp=tmp->next;
	}
    }
  fprintf(fp,"\n");
  
  fprintf(fp,"xuser_acl        ");
  tmp=q->xacl;
  if (!tmp)
    fprintf(fp,"NONE");
  else
    {
      while (tmp)
	{
	  fprintf(fp,"%s ",tmp->str0);
	  tmp=tmp->next;
	}
    }
  fprintf(fp,"\n");
  
  fprintf(fp,"subordinate_list ");
  tmp=q->subordinate_list;
  if (!tmp)
    fprintf(fp,"NONE");
  else
    {
      while (tmp)
	{
	  fprintf(fp,"%s ",tmp->str0);
	  tmp=tmp->next;
	}
    }
  fprintf(fp,"\n");
  
  fprintf(fp,"complex_list     ");
  tmp=q->complex_list;
  if (!tmp)
    fprintf(fp,"NONE");
  else
    {
      while (tmp)
	{
	  fprintf(fp,"%s ",tmp->str0);
	  tmp=tmp->next;
	}
    }
  
  fprintf(fp,"\n");
  fprintf(fp,"consumables      ");
  tmp=q->consumables;
  if (!tmp)
    fprintf(fp,"NONE");
  else
    {
      while (tmp)
	{
	  fprintf(fp,"%s ",tmp->str0);
	  tmp=tmp->next;
	}
    }
  
  fprintf(fp,"\n");
  
  fprintf(fp,"s_rt             %x\n",q->s_rt);
  fprintf(fp,"h_rt             %x\n",q->h_rt);
  fprintf(fp,"s_cpu            %x\n",q->s_cpu);
  fprintf(fp,"h_cpu            %x\n",q->h_cpu);
  fprintf(fp,"s_fsize          %x\n",q->s_fsize);
  fprintf(fp,"h_fsize          %x\n",q->h_fsize);
  fprintf(fp,"s_data           %x\n",q->s_data);
  fprintf(fp,"h_data           %x\n",q->h_data);
  fprintf(fp,"s_stack          %x\n",q->s_stack);
  fprintf(fp,"h_stack          %x\n",q->h_stack);
  fprintf(fp,"s_core           %x\n",q->s_core);
  fprintf(fp,"h_core           %x\n",q->h_core);
  fprintf(fp,"s_rss            %x\n",q->s_rss);
  fprintf(fp,"h_rss            %x\n",q->h_rss);
  
  if (!write_2_stdout)
    fclose(fp);
  
  chmod(str,0744);
  
  cp=dqs_string_insert(NULL,str);
  
  DEXIT;
  return(cp);
  
}

/**********************************************************************/
void dqs_write_generic_qconf(file_prefix,file_name)
     char           *file_prefix;
     char           *file_name;
     
{
  
  FILE *fp;
  string str;
  
  DENTER((DQS_EVENT,"dqs_write_generic_qconf"));
  
  if (file_prefix)
    sprintf(str,"%s/%s",file_prefix,file_name);
  else
    sprintf(str,"%s",file_name);
  
  fp = fopen(str,"w");
  if (!fp) {
    CRITICAL((DQS_EVENT,"DQS_ERROR_0348 error writing %s",str));
    DEXITE;
    abort();
  }
  
  fprintf(fp,"Q_name           ibm11\n");
  fprintf(fp,"hostname         ibm11.scri.fsu.edu\n");
  fprintf(fp,"seq_no           0\n");
  fprintf(fp,"load_masg        1\n");
  fprintf(fp,"load_alarm       175\n");
  fprintf(fp,"priority         0\n");
  fprintf(fp,"type             %s\n",queue_type[1]);
  fprintf(fp,"rerun            %s\n",true_false[0]);
  fprintf(fp,"quantity         1\n");
  fprintf(fp,"tmpdir           /tmp\n");
  fprintf(fp,"shell            /bin/csh\n");
  fprintf(fp,"klog             /usr/local/bin/klog\n");
  fprintf(fp,"reauth_time      6000\n");
  fprintf(fp,"last_user_delay  0\n");
  fprintf(fp,"max_user_jobs    4\n");     
  fprintf(fp,"notify           60\n");
  fprintf(fp,"owner_list       NONE\n");
  fprintf(fp,"user_acl         NONE\n");
  fprintf(fp,"xuser_acl        NONE\n");
  fprintf(fp,"subordinate_list NONE\n");
  fprintf(fp,"complex_list     NONE\n");
  fprintf(fp,"consumables      NONE\n");
  fprintf(fp,"s_rt             7fffffff\n");
  fprintf(fp,"h_rt             7fffffff\n");
  fprintf(fp,"s_cpu            7fffffff\n");
  fprintf(fp,"h_cpu            7fffffff\n");
  fprintf(fp,"s_fsize          7fffffff\n");
  fprintf(fp,"h_fsize          7fffffff\n");
  fprintf(fp,"s_data           7fffffff\n");
  fprintf(fp,"h_data           7fffffff\n");
  fprintf(fp,"s_stack          7fffffff\n");
  fprintf(fp,"h_stack          7fffffff\n");
  fprintf(fp,"s_core           7fffffff\n");
  fprintf(fp,"h_core           7fffffff\n");
  fprintf(fp,"s_rss            7fffffff\n");
  fprintf(fp,"h_rss            7fffffff\n");
  
  fclose(fp);
  chmod(str,0744);
  
  DEXIT;
  return;
  
}

/**********************************************************************/
dqs_queue_type *dqs_read_in_qconf(file_prefix,file_name)
     char           *file_prefix;
     char           *file_name;
     
{
  int i;
  FILE *fp;
  string dummystr,str;
  dqs_queue_type *q;
  dqs_list_type  last_user;
  
  DENTER((DQS_EVENT,"dqs_read_in_qconf"));
  
  if (file_prefix)
    sprintf(str,"%s/%s",file_prefix,file_name);
  else
    sprintf(str,"%s",file_name);
  
  fp=fopen(str,"r");
  if (!fp)
    {
      ERROR((DQS_EVENT,"DQS_ERROR_0349 error: unable to open %s for reading",str));
      DEXITE;
      return(NULL);
    }
  
  q=(dqs_queue_type *)dqs_malloc(sizeof(dqs_queue_type));
  
  if (fscanf(fp,"%s %s\n",dummystr,str)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0350 error: reading conf file: no queue name specified"));
    DEXITE;
    return(NULL);
  }
  /*     fscanf(fp,"\n",dummystr);*/
  q->qname=dqs_string_insert(NULL,str);
  
  if (fscanf(fp,"%s %s\n",dummystr,str)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0351 error: reading conf file: no hostname specified"));
    DEXITE;
    return(NULL);
  }
  q->qhostname=dqs_string_insert(NULL,str);
  q->hostname=dqs_dequalify_hostname(q->hostname,q->qhostname);
  
  if (fscanf(fp,"%s %d\n",dummystr,&q->seq_no)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0352 error: reading conf file: no seq_no specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %d\n",dummystr,&q->load_massage)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0353 error: reading conf file: no load_masg specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %d\n",dummystr,&q->load_alarm)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0354 error: reading conf file: no load_alarm specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %d\n",dummystr,&q->priority)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0355 error: reading conf file: no priority specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %s\n",dummystr,str)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0356 error: reading conf file: no type specified"));
    DEXITE;
    return(NULL);
  }
  for (i=0;i<5;i++) {
    if (!dqs_strncasecmp(str,queue_type[i],4))
      {
	q->qtype=i;
	break;
      }
  }
  if (!q->qtype)
    { 
      FREE(q);
      ERROR((DQS_EVENT,"DQS_ERROR_0357 error: reading conf file: invalid queue type specified"));
      DEXITE;
      return(NULL);
    }
  
  if (fscanf(fp,"%s %s\n",dummystr,str)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0358 error: reading conf file: no rerun specified"));
    DEXITE;
    return(NULL);
  }
  if (!dqs_strncasecmp(str,"TRUE",4))
    {
      q->rerun=i;
    }
  else if(!dqs_strncasecmp(str,"FALSE",4))
    {
      q->rerun=FALSE;
    }
  else
    {
      FREE(q);
      ERROR((DQS_EVENT,"DQS_ERROR_0359 error: reading conf file: invalid rerun option"));
      DEXITE;
      return(NULL);
    }
  
  if (fscanf(fp,"%s %d\n",dummystr,&q->qty)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0360 error: reading conf file: no quantity specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %s\n",dummystr,str)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0361 error: reading conf file: no tmpdir specified"));
    DEXITE;
    return(NULL);
  }
  q->tmpdir=dqs_string_insert(NULL,str);
  
  
  if (fscanf(fp,"%s %s\n",dummystr,str)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0362 error: reading conf file: no shell specified"));
    DEXITE;
    return(NULL);
  }
  q->shell=dqs_string_insert(NULL,str);
  
  if (fscanf(fp,"%s %s\n",dummystr,str)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0363 error: reading conf file: no klog specified"));
    DEXITE;
    return(NULL);
  }
  q->klog=dqs_string_insert(NULL,str);
  DPRINTF((DQS_EVENT,"MQ %s %s %s ",q->tmpdir,q->shell, q->klog));
  if (fscanf(fp,"%s %d\n",dummystr,&q->reauth_time)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0364 error: reading conf file: no reauth_time specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %d\n",dummystr,&q->last_user_delay)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0365 error: reading conf file: no last_user_delay specified"));
    DEXITE;
    return(NULL);
  }
  
  /* check to see if this is DQS 3.1.3 queue definition   */
  if( !strncmp(dummystr,"last_user_delay",15)){
    
    if (fscanf(fp,"%s %d\n",dummystr,&q->max_user_jobs)!=2) {
      FREE(q);
      ERROR((DQS_EVENT,"DQS_ERROR_0366 error: reading conf file: no max_user_jobs specified"));
      DEXITE;
      return(NULL);
    }
    
    if (fscanf(fp,"%s %d\n",dummystr,&q->notify)!=2) {
      FREE(q);
      ERROR((DQS_EVENT,"DQS_ERROR_0367 error: reading conf file: notify specified"));
      DEXITE;
      return(NULL);
    }
  }
  else{
    q->notify= q->last_user_delay;
  }
  bzero(&last_user,sizeof(last_user));
  q->last_user= dqs_insert(DQS_STR0,TAIL,q->last_user, &last_user);
  
  bzero(str,sizeof(str));
  if (fscanf(fp,"%s %[^\n]",dummystr,str)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0368 error: reading conf file: no owner_list specified"));
    DEXITE;
    return(NULL);
  }
  
  fscanf(fp,"\n",dummystr);
  q->owner_list=dqs_string2list(str);
  if (!dqs_strcasecmp("NONE",q->owner_list->str0))
    {
      q->owner_list=dqs_free_list(q->owner_list);
    }
  
  bzero(str,sizeof(str));
  if (fscanf(fp,"%s %[^\n]",dummystr,str)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0369 error: reading conf file: no user_acl specified"));
    DEXITE;
    return(NULL);
  }
  fscanf(fp,"\n",dummystr);
  q->acl=dqs_string2list(str);
  if (!dqs_strcasecmp("NONE",q->acl->str0))
    {
      q->acl=dqs_free_list(q->acl);
    }
  
  bzero(str,sizeof(str));
  if (fscanf(fp,"%s %[^\n]",dummystr,str)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0370 error: reading conf file: no xacl specified"));
    DEXITE;
    return(NULL);
  }
  fscanf(fp,"\n",dummystr);
  q->xacl=dqs_string2list(str);
  if (!dqs_strcasecmp("NONE",q->xacl->str0))
    {
      q->xacl=dqs_free_list(q->xacl);
    }
  
  bzero(str,sizeof(str));
  if (fscanf(fp,"%s %[^\n]",dummystr,str)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0371 error: reading conf file: no subordinate_list specified"));
    DEXITE;
    return(NULL);
  }
  fscanf(fp,"\n",dummystr);
  q->subordinate_list=dqs_string2list(str);
  if (!dqs_strcasecmp("NONE",q->subordinate_list->str0))
    {
      q->subordinate_list=dqs_free_list(q->subordinate_list);
    }
  
  bzero(str,sizeof(str));
  if (fscanf(fp,"%s %[^\n]",dummystr,str)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0372 error: reading conf file: no complex_list specified"));
    DEXITE;
    return(NULL);
  }
  fscanf(fp,"\n",dummystr);
  q->complex_list=dqs_string2list(str);
  if (!dqs_strcasecmp("NONE",q->complex_list->str0))
    {
      q->complex_list=dqs_free_list(q->complex_list);
    }
  
  
  bzero(str,sizeof(str));
  if (fscanf(fp,"%s %[^\n]",dummystr,str)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0373 error: reading conf file: no consumables specified"));
    DEXITE;
    return(NULL);
  }
  
  fscanf(fp,"\n",dummystr);
  q->consumables=dqs_string2list(str);
  if (!dqs_strcasecmp("NONE",q->consumables->str0))
    {
      q->consumables=dqs_free_list(q->consumables);
    }
  
  if (fscanf(fp,"%s %x\n",dummystr,&q->s_rt)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0374 error: reading conf file: no s_rt specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %x\n",dummystr,&q->h_rt)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0375 error: reading conf file: no h_rt specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %x\n",dummystr,&q->s_cpu)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0376 error: reading conf file: no s_cpu specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %x\n",dummystr,&q->h_cpu)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0377 error: reading conf file: no h_cpu specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %x\n",dummystr,&q->s_fsize)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0378 error: reading conf file: no s_fsize specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %x\n",dummystr,&q->h_fsize)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0379 error: reading conf file: no h_fsize specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %x\n",dummystr,&q->s_data)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0380 error: reading conf file: no s_data specified"));
    DEXITE;
    return(NULL);
  }
  
  
  if (fscanf(fp,"%s %x\n",dummystr,&q->h_data)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0381 error: reading conf file: no h_data specified"));
    DEXITE;
    
    return(NULL);
  }
  
  if (fscanf(fp,"%s %x\n",dummystr,&q->s_stack)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0382 error: reading conf file: no s_stack specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %x\n",dummystr,&q->h_stack)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0383 error: reading conf file: no h_stack specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %x\n",dummystr,&q->s_core)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0384 error: reading conf file: no s_core specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %x\n",dummystr,&q->h_core)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0385 error: reading conf file: no h_core specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %x\n",dummystr,&q->s_rss)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0386 error: reading conf file: no s_rss specified"));
    DEXITE;
    return(NULL);
  }
  
  if (fscanf(fp,"%s %x\n",dummystr,&q->h_rss)!=2) {
    FREE(q);
    ERROR((DQS_EVENT,"DQS_ERROR_0387 error: reading conf file: no h_rss specified"));
    DEXITE;
    return(NULL);
  }
  
  fclose(fp);
  
  DEXIT;
  return(q);
  
}

/**********************************************************************/
void dqs_show_queue(q)
     dqs_queue_type *q;
     
{
  
  dqs_list_type *lp;
  dqs_list_type *lp2;
  dqs_list_type *lp3;
  
  DENTER((DQS_EVENT,"dqs_show_queue"));
  
  fflush(stdout);
  fflush(stderr);
  
  printf("qname\t\t%s\t",q->qname);
  dqs_show_states(DQS_STDOUT,q->state);
  printf("\n");
  printf("qhostname\t%s\n",q->qhostname);
  printf("hostname\t%s\n",q->hostname);
  printf("seq_no\t\t%d\n",q->seq_no);
  printf("load_massage\t%d\n",q->load_massage);
  printf("load_alarm\t%d\n",q->load_alarm);
  printf("priority\t%d\n",q->priority);
  printf("qtype\t\t%s\n",queue_type[q->qtype]);
  printf("rerun\t\t%s\n",true_false[q->rerun]);
  printf("qty\t\t%d\n",q->qty);
  printf("tmpdir\t\t%s\n",q->tmpdir);
  printf("shell\t\t%s\n",q->shell);
  printf("klog\t\t%s\n",q->klog);
  printf("reauth_time\t%d\n",q->reauth_time);
  printf("last_user_delay\t\t%d\n",q->last_user_delay);
  printf("max_user_jobs\t\t%d\n",q->max_user_jobs);     
  printf("notify\t\t%d\n",q->notify);
  printf("s_rt\t\t%x\n",q->s_rt);
  printf("h_rt\t\t%x\n",q->h_rt);
  printf("s_cpu\t\t%x\n",q->s_cpu);
  printf("h_cpu\t\t%x\n",q->h_cpu);
  printf("s_fsize\t\t%x\n",q->s_fsize);
  printf("h_fsize\t\t%x\n",q->h_fsize);
  printf("s_data\t\t%x\n",q->s_data);
  printf("h_data\t\t%x\n",q->h_data);
  printf("s_stack\t\t%x\n",q->s_stack);
  printf("h_stack\t\t%x\n",q->h_stack);
  printf("s_core\t\t%x\n",q->s_core);
  printf("h_core\t\t%x\n",q->h_core);
  printf("s_rss\t\t%x\n",q->s_rss);
  printf("h_rss\t\t%x\n",q->h_rss);
  printf("status\t\t%d\n",q->status);
  printf("prev_status\t%d\n",q->prev_status);
  printf("load_av\t\t%d\n",*q->load_avg_ptr);
  printf("alive\t\t%d\n",q->alive);
  printf("lt_heard_from\t%d\n",*q->lt_heard_from_ptr);
  printf("soc\t\t%d\n",q->soc);
  printf("acl\n");
  dqs_showlist(q->acl,DQS_STDOUT|DQS_STR0,4);
  printf("xacl\n");
  dqs_showlist(q->xacl,DQS_STDOUT|DQS_STR0,4);
  printf("owner_list\n");
  dqs_showlist(q->owner_list,DQS_STDOUT|DQS_STR0,4);
  printf("subordinate_list\n");
  dqs_showlist(q->subordinate_list,DQS_STDOUT|DQS_STR0,4);
  printf("q_activation_list\n");
  dqs_showlist(q->q_activation_list,DQS_STDOUT|DQS_STR0,4);
  printf("complex_list\n");
  if (Complex_head)
    {
      lp=q->complex_list;
      while (lp)
	{
	  if(!strcmp(lp->str0,"REQUIRED") ){
	    printf("\tREQUIRED ");
	    lp=lp->next;
	    continue;
	  }
	  lp2=dqs_locate_complex(lp->str0);
	  if (!lp2)
	    {
	      ERROR((DQS_EVENT,"DQS_ERROR_0388 error: cannot locate complex\"%s\"",lp->str0));
	    }
	  else
	    {
	      printf("\tname %s\n",lp2->str0);
	      lp3=lp2->chain;
	      while (lp3)
		{
		  printf ("\t\t%s",lp3->str0);
		  if (lp3->int1==EQ_OP)
		    printf("=");
		  if (lp3->str1)
		    printf ("\"%s\"",lp3->str1);
		  else if (lp3->int0)
		    printf ("%d",lp3->int0);
		  printf("\n");
		  lp3=lp3->next;
		}
	    }
	  lp=lp->next;
	}
    }
  else
    {
      dqs_showlist(q->complex_list,DQS_STDOUT|DQS_STR0|DQS_STR0,4);
    }
  printf("consumables\n");
  dqs_showlist(q->consumables,DQS_STDOUT|DQS_STR0,4);
  
  printf("job_list\n");
  dqs_showlist(q->job_list,DQS_STDOUT|DQS_STR0,4);
  
  DEXIT;
  return;
  
}

