/* 
 *      XSitecopy, for managing remote web sites with a GNOME interface.
 *      Copyright (C) 1999, Lee Mallabone <lee0@callnetuk.com
 *                                                                        
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *     
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *     
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  
 */
#ifndef FE_GTK_SITE_OPS_H
#define FE_GTK_SITE_OPS_H

#include <pthread.h>
#include <gtk/gtk.h>
#include "gcommon.h"

/* Updates */
void close_main_update_window (GtkWidget *button, gpointer data);
void *actual_main_update (void *a_site);
int start_main_update (void);
int main_update_please (GtkWidget *update_button, gpointer data);

/* File List changes */
int fe_catchup_site (void);
void catchup_selected (gint button_number, gpointer data);
int fe_init_site (void);
void initialize_selected (gint button_number, gpointer data);

/* Disk accesses */
void save_default (void); /* Saves site definitions to current value of 'rcfile' */

/* Site List changes */
void delete_a_site (GtkWidget *button_or_menu, gpointer data);
struct site_t *find_prev_site (struct site_t *a_site); /* Used for delete_a_site */
void delete_selected (gint button_number);

#endif /* FE_GTK_SITE_OPS_H */
