/* 
 *      XSitecopy, for managing remote web sites with a GNOME interface.
 *      Copyright (C) 1999, Lee Mallabone <lee0@callnetuk.com
 *                                                                        
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *     
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *     
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *  
 */

#ifndef FE_GTK_MAIN_H
#define FE_GTK_MAIN_H

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>

#include "mguru.h"
#include "new_site.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "sites.h"
#include "common.h"

#define IS_A_FILE 1
#define IS_A_SITE 2

#define ORGANIZED 1
#define MESSY 2

#define SAVEAS 1
#define OPENNEW 2

struct ctree_attachment {
   int file_or_site;
   int sorted_yet;
   void *info_struct;
};

struct site_info {
   GtkWidget *container;
   GtkWidget *frame;

   GtkWidget *site_details_frame;
   GtkWidget *sitename;
   GtkWidget *servername; /* Do we want port number? */
   GtkWidget *port;
   
   GtkWidget *protocol;   /* Option menu */
   GtkWidget *proto_box;  /* Actual menu container */
   GtkWidget *proto_ftp;  /* Protocol options themselves */
   GtkWidget *proto_dav;
   
   GtkWidget *username;
   GtkWidget *password; /* Some users might want it on screen?
			 * Configurable. Default=no display */

   /* Directory details */
   GtkWidget *dir_frame;
   GtkWidget *local_dir;
   GtkWidget *remote_dir;
   GtkWidget *url;
   
   /* Check boxes */
   GtkWidget *flags_frame;
   GtkWidget *ftp_mode; /* passive? */
   GtkWidget *is_http_persistant; /* This not implemented */
#ifdef USE_DAV
   GtkWidget *http_expect_continue; 
   GtkWidget *limit_connections;
#endif
   GtkWidget *nodelete; /* delete remote files? */
   GtkWidget *checkmoved; /* Bother with moved files? */
   GtkWidget *nooverwrite;
   
   /* Couple of option menus for permissions & sym links */

   GtkWidget *file_attrib_frame;

   GtkWidget *perms_mode;
   GtkWidget *perms_mode_menu;
   GtkWidget *perms_ignore;
   GtkWidget *perms_exec;
   GtkWidget *perms_all;
   
   GtkWidget *sym_link_mode;
   GtkWidget *sym_link_mode_menu;
   GtkWidget *sym_follow;
   GtkWidget *sym_ignore; /* Default: follow */   
   GtkWidget *sym_maintain;
   
   /* Information Frame */
   GtkWidget *info_frame;
   GtkWidget *evbox;
   GtkWidget *change_details; /* Number of files changed, new, deleted, etc */
   GtkWidget *summary; /* Eg. Site has not changed. Site has just 3 additions*/

   /* Bottom right quarter.*/
   GtkWidget *advanced_frame;
   GtkWidget *advanced_notebook;
   
   GtkWidget *excludes_vbox;
   GtkWidget *excludes_scroller;
   GtkWidget *excludes_hbox;
   GtkWidget *excludes_new;
   GtkWidget *excludes_delete;
/*   GtkWidget *excludes_up; Maybe
   GtkWidget *excludes_down;*/
   
   GtkWidget *name_map_vbox;
   GtkWidget *name_map_scroller;
   GtkWidget *name_map_hbox;
   GtkWidget *name_map_new;
   GtkWidget *name_map_delete;
   
};

struct current_name_map {
   GtkWidget *tmp;
   GtkWidget *local_entry;
   GtkWidget *remote_entry;
   struct current_name_map *next;
};

void backup_infofile(void);
void backup_rcfile (void);
void restore_rcfile (void);
void restore_rc (gint button_number);
int copy_a_file (gchar *input_name, gchar *output_name);
void restore_infofile(void);
void actual_restoration(gint button_number);

/* Exit functions */

void quit_please (void);

gint exit_handler (GtkWidget *widget, GdkEvent *event, gpointer data);
void open_new_request (void);
void open_newrc (GtkWidget *ok, GtkFileSelection *fileb);
void saveas_request (void);
void save_sites_as (GtkWidget *ok, GtkFileSelection *fileb);
void filename_request (gint mode_num);

int make_defaults (struct site_t *a_site);
void add_site (GtkButton *apply_button, gpointer user_data);

void select_ctree_cb (GtkCTree *tree, GtkCTreeNode *node, gpointer data);

GtkWidget *create_default_main_area (void);
GtkWidget *create_initial_main_area (void);
void site_report (void);
void site_web_report (void);
void redraw_main_area (void);
void clear_main_area (void);

void populate_site_node (GtkCTreeNode *site_node, struct site_t *current);
int check_dir (GtkCTree *bler, GtkCTreeNode *node, gpointer data);
void check_site_and_record_errors(struct site_t *current);
void fill_tree_from_all_sites(GtkWidget *a_ctree);
GtkWidget *ctree_create_sites (void);

void refresh_node_pixmap (GtkCTree *tree, GtkCTreeNode *node);
void refresh_selected (void);
void pixmap_refresh (GtkCTreeNode *a_site_node);
void make_error_window (void);
GtkWidget *create_site_errors_dialog (void);

#endif /* FE_GTK_MAIN */

   
