<?php 
# ---------------------------------------------------------------
# bookmarker
# A WWW based bookmark management, retrieval, and search tool.
# Copyright (C) 1998  Padraic Renaghan
# Licensed under terms of GNU General Public License
# (see http://www.renaghan.com/bookmarker/source/LICENSE)
# ---------------------------------------------------------------
# $Id: maintain.php3,v 1.12 1999/07/08 12:14:34 prenagha Exp $
# ---------------------------------------------------------------
include("bkprepend.php3");
page_open(array( "sess" => "bk_sess"
              ,"auth" => "bk_cr_auth"
	          ,"perm" => "bk_perm"
	          ,"user" => "bk_user"));

$tpl->define(array(
  standard   => "common.standard.tpl",
  body       => "maintain.body.tpl",
  msg        => "common.message.tpl",
  error_msg  => "common.error_message.tpl",
  notfound   => "maintain.notfound.tpl"
));

set_standard("maintain", &$tpl);
set_bkusername(); 

### Submit Handler
### Get a database connection
$db   = new bk_db;

## Check if there was a submission
while ( is_array($HTTP_POST_VARS) 
     && list($key, $val) = each($HTTP_POST_VARS)) {
  switch ($key) {

  ## Change bookmark
  case "bk_edit":
    ## Do we have permission to do so?
    if (!$perm->have_perm("editor")) {
      $error_msg .= "You do not have permission to change bookmarks.";
      break;
    }

    ## trim the form fields
		$url = $validate->strip_space($url);
		$name = trim($name);
		$desc = trim($desc);
    $keyw = trim($keyw);
		
    ## Do we have all necessary data?
    if (empty($url) || empty($name)) {
      $error_msg .= "Please fill out <strong>URL</strong> and <strong>Name</strong>!";
      break;
    }

    ## Must set these codes
    if (isset($category) AND isset($subcategory) AND isset($rating)) {
    } else {
      $error_msg .= "Please select a <strong>Category</strong>, <strong>Subcategory</strong>, and <strong>Rating</strong>!";
      break;
    }

  ## does the admin want us to check URL format
	  if ($bookmarker->url_format_check > 0 ) {
	## Is the URL format valid
      if (!$validate->is_url($url))  { 
        $format_msg = "URL invalid. Format must be <strong>http://</strong> or <strong>ftp://</strong> followed by a valid hostname and URL!<br><small> $validate->ERROR </small>";

	## does the admin want this formatted as a warning or an error?
				if ( $bookmarker->url_format_check == 2 ) {
				echo "must equal two!!!";
				  $error_msg .= $format_msg;
          break;
				} else {
				  $msg .= $format_msg;
			  }
	    }
    }		

    ## Update bookmark information.
    $query = sprintf("update bookmark set url='%s', name='%s', ldesc='%s' , keywords='%s', category_id=%s, subcategory_id=%s, rating_id=%s where id=%s and username='%s'", $url, addslashes($name), addslashes($desc), addslashes($keyw), $category, $subcategory, $rating, $id, $bkusername);
    $db->query($query);
    if ($db->affected_rows() == 0) {
      $error_msg .= "<b>Update failed:</b> $query";
      break;
    }
    
    $msg .= "Bookmark changed sucessfully.";
  	## Does the URL respond
    if (!$validate->url_responds($url))  { 
      $msg .= "<BR><strong>**WARNING**</strong>: The URL you entered is not responding!<br><small> $validate->ERROR </small>";
	}
		
	break;

  ## Delete the bookmark
  case "bk_delete":
    ## Do we have permission to do so?
    if (!$perm->have_perm("editor")) {
      $error_msg .= "You do not have permission to delete bookmarks.";
      break;
    }
    
    ## Delete that bookmark.
    $query = sprintf("delete from bookmark where id='%s' and username='%s'", $id, $bkusername);
    $db->query($query);
    if ($db->affected_rows() == 0) {
      $error_msg .= "<b>Delete failed:</b> $query";
      break;
    }
    
    $msg .= "Bookmark deleted sucessfully.";

    ## Update the PHPLIB user variable that keeps track of how
		## many bookmarks this user has.
		$user->register("user_total_bookmarks");
    $query = sprintf("select count(*) as nbr_bookmarks from bookmark where username = '%s'", $bkusername);
    $db->query($query);
    if ($db->next_record()){
      $user_total_bookmarks = $db->f("nbr_bookmarks");
    }

  break;
  
  default:
  break;
 }
}

if (isset ($error_msg)) {
  $tpl->assign(ERROR_MSG_TEXT, $error_msg);
  $tpl->parse(ERROR_MSG, "error_msg");
}

if (isset ($msg)) {
  $tpl->assign(MSG_TEXT, $msg);
  $tpl->parse(MSG, "msg");
}

## get record to update
$query = sprintf("select * from bookmark where id ='%s' and username='%s'", $id, $bkusername);
$db->query($query);
if ($db->next_record()){

# if dislpaying b/c of error, show previous data
  if ($url > "") {
    $default_url = $url;
  } else {
    $default_url = $db->f("url");
  }

# if dislpaying b/c of error, show previous data
  if ($name > "") {
    $default_name = $name;
  } else {
    $default_name = $db->f("name");
  }

# if dislpaying b/c of error, show previous data
  if ($desc > "") {
    $default_desc = $desc;
  } else {
    $default_desc = $db->f("ldesc");
  }

# if dislpaying b/c of error, show previous data
  if ($keyw > "") {
    $default_keyw = $keyw;
  } else {
    $default_keyw = $db->f("keywords");
  }

# if dislpaying b/c of error, show previous data
  if (isset ($category)) {
    $default_category = $category;
  } else {
    $default_category = $db->f("category_id");
  }

# if dislpaying b/c of error, show previous data
  if (isset ($subcategory)) {
    $default_subcategory = $subcategory;
  } else {
    $default_subcategory = $db->f("subcategory_id");
  }

# if dislpaying b/c of error, show previous data
  if (isset($rating)) {
    $default_rating = $rating;
  } else {
    $default_rating = $db->f("rating_id");
  }

  load_ddlb("category", $default_category, $bkusername, &$category_select, FALSE);
  load_ddlb("subcategory", $default_subcategory, $bkusername, &$subcategory_select, FALSE);  
	load_ddlb("rating", $default_rating, $bkusername, &$rating_select, FALSE);

  $maillink_url = "maillink.php3?id=".$db->f("id");

  $tpl->assign(array(
    FORM_ACTION            => $sess->self_url(),
    MAIL_THIS_LINK_URL     => $sess->url("maillink.php3?id=".$db->f("id")),
    ID                     => $db->f("id"),
    URL                    => $db->f("url"),
    DEFAULT_URL            => $default_url,
    DEFAULT_NAME           => htmlspecialchars(stripslashes($default_name)),
    DEFAULT_DESC           => htmlspecialchars(stripslashes($default_desc)),
    DEFAULT_KEYW           => htmlspecialchars(stripslashes($default_keyw)),
    DEFAULT_CATEGORY       => $default_category,
    DEFAULT_SUBCATEGORY    => $default_subcategory,
    DEFAULT_RATING         => $default_rating,
	  CATEGORY_SELECT        => $category_select,
	  SUBCATEGORY_SELECT     => $subcategory_select,
	  RATING_SELECT          => $rating_select,
	  IMAGE_URL_PREFIX       => $bookmarker->image_url_prefix
  ));

  $tpl->parse(BODY, "body");

} else {
  $tpl->parse(BODY, "notfound");
}

$tpl->parse(MAIN, "standard");
  
$tpl->FastPrint();
page_close();
?>
