# 
# $Header: /aol/cvs/host/aolserver3/scripts/nsd.tcl,v 1.9 1999/09/27 19:37:35 jimbo Exp $

set home [ns_info home]
set host [ns_info hostname]
set server "server1"

ns_section "ns/parameters"
ns_param debug        off
ns_param Home         "/usr/lib/aolserver"
ns_param ServerLog    "/var/log/aolserver/aolserver.${server}.log"
ns_param PidFile      "/var/run/aolserver/aolserver.${server}.pid"
ns_param User         "www-data"


ns_section "ns/servers"
ns_param server1      "Virtual Server One"

ns_section "ns/server/${server}"
ns_param DirectoryFile "index.html, index.htm"
ns_param EnableTclPages on

ns_section "ns/server/${server}/fastpath"
ns_param PageRoot     "/var/www"

ns_section "ns/server/${server}/adp"
ns_param Map          "/*.adp"

ns_section "ns/server/${server}/adp/parsers"
#ns_param fancy        ".adp"
ns_param adp         ".adp"

ns_section "ns/server/${server}/module/nssock"
ns_param Port         80
ns_param Hostname     $host

ns_section "ns/server/${server}/modules"
ns_param nssock       nssock.so
ns_param nslog        nslog.so
ns_param nscgi        nscgi.so
ns_param nscp         nscp.so

ns_section "ns/server/${server}/module/nscgi"
ns_param Map          "GET /*.pl"
ns_param Map          "GET /*.py"
ns_param Map          "GET /cgi /usr/lib/cgi-bin/"
ns_param Map          "GET /cgi-bin /usr/lib/cgi-bin/"
ns_param Map          "POST /*.pl"
ns_param Map          "POST /*.py"
ns_param Interps      CGIinterps

ns_section "ns/interps/CGIinterps"
ns_param .pl          "/usr/bin/perl"
ns_param .sh          "/bin/sh"
ns_param .py          "/usr/bin/python"

ns_section "ns/server/${server}/module/nscp/users"
ns_param user         "www-data::"

ns_section "ns/server/${server}/module/nscp"
ns_param port         9999
ns_param address      127.0.0.1
ns_param reconnection off
ns_param binary       "/usr/lib/aolserver/bin/nscp"

ns_section "ns/server/${server}/module/nslog"
ns_param File        "/var/log/aolserver/access.${server}.log"

