// Aspell SC_Error defination
// Copyright 1998 by Kevin Atkinson under the terms of the LGPL

#ifndef __aspell_error__
#define __aspell_error__

#include <string>
#include "file_exceps.hh"

namespace aspell {

  using namespace autil;

  struct LanguageException : virtual public Exception {
    string language;
    LanguageException(const string & l, const string & m)
      : Exception(m), language(l) {}
  protected:
    LanguageException(const string & l)
      : language(l) {}
  };
  
  struct UnknownLang : public LanguageException, public RethrowWFile {
    UnknownLang(const string & l);
    void rethrow_w_file(const string &f) const;
  };

  struct UnknownSoundslike : public LanguageException {
    string soundslike;
    string soundslike_path;
    UnknownSoundslike(const string & s, const string & f, const string & l);
  };
  
  struct MismatchedLang : public LanguageException, public RethrowWFile {
    string current_language;
    MismatchedLang(const string & c, const string & tried_language);
    void rethrow_w_file(const string &f) const;
  };

  struct UnknownLangInFile : public UnknownLang, public FileException
  {
    UnknownLangInFile(const string & u, const string & f);
  };

  struct MismatchedLangInFile : public MismatchedLang,
				public FileException
  {
    MismatchedLangInFile(const string & t, const string & m, const string & f);
  };
}


#endif
