#ifndef __repl_uril__
#define __repl_uril__

#include <vector>

namespace afilter {

  template <class T>
  class DummyBufferItr {
    T c_;
  public:
    void operator += (T c) {c_ = c;}

    DummyBufferItr & operator++() {return *this;}
    T operator *() const {return c_;}
  };

  template <typename T>
  class SimpleBuffer {
  public:
    typedef vector<T> String;
  private:
    String                 str;
    String::const_iterator i;
  public:
    SimpleBuffer() {}
    SimpleBuffer(String::size_type i) : str(i) {}
    SimpleBuffer(const SimpleBuffer & other) 
      : str(other.str), 
      i(str.begin() + (other.i - other.str.begin())) 
    {}
    SimpleBuffer & operator = (const SimpleBuffer & other) 
    {
      str = other.str; 
      i = str.begin() + (other.i - other.str.begin());
      return *this;
    }

    void operator = (const String & other) {str = other;}
    void operator += (T v) {str.push_back(v);}
    void operator++ () {++i;}
  
    void reset() {i = str.begin();}
    void clear() {str.resize(0); reset();}
    T operator* () const {return *i;}
    bool at_end() const {return i == str.end();}
  };
}

#endif


#if 0 // to end of file
  class simple_buffer {
  private:
    const char   * c_str_;
    char   * i_;
  public:
    simple_buffer(int l) {c_str_ = i_ = new char[l+1];}

    void operator ++() {++i_;}
  
    void clear() {i_ = const_cast<char *>(c_str_);}
    void reset() {*i_ = '\0'; i_ = const_cast<char *>(c_str_);}
    void operator += (char c) {*i_ = c; ++i_;}
    void operator += (const char * s) {for(;*s;++s) operator+=(*s);}
    char operator *() const {return *i_;}
    bool at_end() const {return !*i_;}
    ~simple_buffer() {delete[] c_str_;}
  };

  class cstr_buffer {
  private:
    const char   * c_str_;
    const char   * i_;
  public:
    cstr_buffer() {}
    cstr_buffer(const char * s) : c_str_(s), i_(s) {}
    void operator = (const char * s) {c_str_ = s; i_ = s;}
    void operator++ () {++i_;}

    void reset() {i_ = c_str_;}
    char operator* () const {return *i_;}
    bool at_end() const {return !*i_;}
  };

#endif

  
