#!/bin/sh
# edit the line below if you need to use
# a specific wish on your system
# the next line restarts using tclsh \
                exec tclsh "$0" "$@"


## This script is a filtering wrapper to pap. All commandline arguments
## except filenames are passed directly to pap. Each file is filtered
## through the default filter or the user's defined tkchooser filter.
## The global tkchooser filter is not supported yet - I'm falling asleep
## at the keyboard.
## Ethan Gold <etgold@cs.columbia.edu> 3/22/99
## This script is part of tkchooser. Tkchooser's license terms apply.

## appletalk location
set libdir "/usr/local/lib/tkchooser2"

if {[file readable "/etc/chooser.cfg"]} {
    source "/etc/chooser.cfg"
} elseif {[file readable "$libdir/chooser.cfg"]} {
    source "$libdir/chooser.cfg"
} else {
    puts "$libdir/chooser.cfg unreadable. exiting."
    exit
}

set pap "$appletalkdir/bin/pap"

## config file locations
set filter "enscript -Z -p -"
if ![info exists env(HOME)] {
    set env(HOME) "~"
}

## read the filter or use enscript
## open user file if it exists
if [file readable $env(HOME)/printfilter] {
    set filtfd [open $env(HOME)/printfilter r]
    gets $filtfd filter
    close $filtfd
    unset filtfd
}

## separate the files and arguments
## the assumption is that arguments won't also happen
## to be the names of readable files in the filesystem
set notfiles ""
foreach arg $argv {
    if {[file readable $arg]} {
	lappend files $arg
    } else {lappend notfiles $arg}
}

set cmdstring "$filter | $pap $notfiles"

## filter and print each file
if [info exists files] {
    foreach file $files {
	#puts "eval exec cat $file | $cmdstring"
	catch {eval exec cat $file | $filter | $pap $notfiles} errors
	#puts $errors
    }
} else {
    ## otherwise read from stdin
    #puts "|$cmdstring"
    eval set pipefd [open "|$cmdstring" r+]
    while {[gets stdin line] >= 0} {
	puts $pipefd $line
	#puts $line
    }
    catch close $pipefd
}

exit
