/* The source section of Gtogo */

#include <gtk/gtk.h>
#include <string.h>

#include "int.h"

#include "main.h"
#include "getdir.h"
#include "filelist.h"
#include "internal.h"
#include "cdsource.h"
#include "fileman.h"
#include "dircache.h"
#include "treedroppatch.h"
#include "preferences.h"
#include "varman.h"
#include "preview.h"
#include "tracklist.h"
#include "helpings.h"

/* uncomment for debugging */
/* #define DEBUG */

GtkWidget *source;
GtkWidget *sourcetree;

filelist_info *unixtree;

tracklist_info *intstruct;

GtkWidget *cddrivelist; /* The tree item containing the cdrom drives subtree */

int source_doubleclickfile(char *s,char *p)
{
   char dirname[256];
	
   if (dircache_isdir((char*)(strchr(s,":"[0])+1)))
     {
	fileman_strippath((char*)(strchr(s,":"[0])+1),(char*)&dirname);
	getdir_selectsubdir(GTK_WIDGET(unixtree->treeentry),
			    (char*)&dirname);
     }
   else
     {	
	/* play file if the user double-clicks on it */
	preview_playtrack(s,&preview_info);
#ifdef DEBUG
 	printf ("source_doubleclickfile: starting media player\n");
#endif	  
     };
    return 1;
}
;

void source_doubleclick(selectlist_info *info)
{
   char *files;
   
   files=selectlist_getselection(info);
#ifdef DEBUG
	printf ("source_doubleclick: got doubleclick event for %s\n",
		files);
#endif
   fileman_selectionhandler(files,NULL,source_doubleclickfile);
};

void source_cb_dir_select(GtkWidget *w,getdir_dirinfo *i)
{
	unixtree=filelist_create((char*)&i->dirname,
				 NULL, /* no vdirs here */
				 NULL,TRUE,
				 NULL, /* not editable,hence no popup */
				 GTK_TREE_ITEM(w),
				 GTK_SIGNAL_FUNC(source_doubleclick));
	gtk_paned_add2(GTK_PANED(source),unixtree->widget);
	gtk_widget_show(unixtree->widget);	
}
;

void source_cb_dir_unselect(GtkWidget *w,getdir_dirinfo *i)
{
	filelist_destroy(unixtree);
}
;

void source_cb_internalselect(GtkWidget *w,gpointer data)
{
	intstruct=internal_create();
	gtk_paned_add2(GTK_PANED(source),intstruct->widget);
	gtk_widget_show(intstruct->widget);
}
;

void source_cb_internalunselect(GtkWidget *w,gpointer data)
{
	internal_destroy(intstruct);
}
;

/* tracklist_create and tracklist_destroy do create/destroy a tracklist
 * within the cdsource_cdinfo structure,not the structure itself,which is
 * essentially left untouched */
void source_cb_cdromselect(GtkWidget *w,gpointer data)
{
	cdsource_cdinfo *info;
	
	info=(cdsource_cdinfo*)data;
	cdsource_tracklist_create(info);
	gtk_paned_add2(GTK_PANED(source),info->widget);
	gtk_widget_show(info->widget);
}
;

void source_cb_cdromdeselect(GtkWidget *w,gpointer data)
{
	cdsource_tracklist_destroy((cdsource_cdinfo*)data);
}
;

GtkWidget *source_create()
{
	GtkWidget *sourcetreescroll;
	GtkWidget *device;
	    	    
	source=gtk_hpaned_new();
   	main_settip(source,_("Source Area"));
	
	sourcetreescroll=gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sourcetreescroll),
				       GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_AUTOMATIC);
	sourcetree=gtk_tree_new();
	gtk_tree_set_selection_mode(GTK_TREE(sourcetree),GTK_SELECTION_BROWSE);
	treedroppatch_install(sourcetree);
	
	/* Main File selection Tree */
	device=gtk_tree_item_new_with_label(_("Unix Tree"));
	gtk_tree_append(GTK_TREE(sourcetree),device);	
	gtk_tree_item_set_subtree(GTK_TREE_ITEM(device),
				  gtk_tree_new());
	gtk_widget_show(device);
	getdir_connectstdsignals(device,
				 NULL,
				 getdir_dirinfo_create("/",
						       source_cb_dir_select,
						       source_cb_dir_unselect,
						       NULL, /* no additional data passed to callbacks */
						       1,    /* allow dragging tree items */
						       NULL, /* no drop support */
						       NULL  /* no popup */
						       )
				 );
	/* Internal structures - currently the filesystem from fsedit only */
	internal_init();
	device=gtk_tree_item_new_with_label(_("Internal structures"));
	gtk_tree_append(GTK_TREE(sourcetree),device);
	gtk_signal_connect(GTK_OBJECT(device),"select",
			   source_cb_internalselect,NULL);
	gtk_signal_connect(GTK_OBJECT(device),"deselect",
			   source_cb_internalunselect,NULL);
	gtk_widget_show(device);

	/* CDROMs as source for track streams */
	cddrivelist=gtk_tree_item_new_with_label(_("CDROM drives"));
	gtk_tree_append(GTK_TREE(sourcetree),cddrivelist);
	gtk_tree_item_set_subtree(GTK_TREE_ITEM(cddrivelist),
				  GTK_WIDGET(cdsource_cdtree(GTK_SIGNAL_FUNC(source_cb_cdromselect),
							     GTK_SIGNAL_FUNC(source_cb_cdromdeselect))));
	gtk_widget_show(cddrivelist);
	
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sourcetreescroll),sourcetree);
	gtk_widget_show(sourcetree);
	gtk_paned_pack1(GTK_PANED(source),sourcetreescroll,1,1);
	gtk_widget_show(sourcetreescroll);
	
	gtk_paned_compute_position(GTK_PANED(source),INITSIZE_X,140,500);
	gtk_paned_set_position(GTK_PANED(source),(int)(INITSIZE_X/3));

	
	return source;
}
;

void source_update_cddl()
{
	gtk_tree_select_child(GTK_TREE(sourcetree),cddrivelist);
	/* FIXME: cdsource_cdinfo structs do not get freed */
	gtk_tree_item_remove_subtree(GTK_TREE_ITEM(cddrivelist));
	
	gtk_tree_item_set_subtree(GTK_TREE_ITEM(cddrivelist),
				  GTK_WIDGET(cdsource_cdtree(GTK_SIGNAL_FUNC(source_cb_cdromselect),
							     GTK_SIGNAL_FUNC(source_cb_cdromdeselect))));
}
;

void source_init()
{
	gtk_tree_select_item(GTK_TREE(sourcetree),0);

	/* its probably secure to make the updating depend on the varman var
	 * as this is the best indicator for a changed drive list anyway ;-)
	 * make sure source_init() is called *after* cddrives_init() though,
	 * as otherwise the changes in the drivelist wont apply to the redraw
	 * as theyll be applied after the redraw */
	varman_install_handler(global_defs,
			       "cddrives_drives",
			       source_update_cddl,
			       NULL);
}
;
