#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#include "config.h"

#ifdef HAVE_GNOME
# include <gnome.h>
#else
# include <gtk/gtk.h>
#endif

#include "int.h"
#include "varman.h"
#include "varmanwidgets.h"
#include "preferences.h"
#include "configfile.h"
#include "layoutconfig.h"

#include "defaultentries.h"

GtkWidget *preferences_editmain;
GtkWidget *preferences_editpad;
GtkWidget *preferences_edit_ok,*preferences_edit_apply,
          *preferences_edit_cancel,*preferences_edit_undo;

GtkWidget *preferences_common;
	
varman_database *global_defs;
/* all those things that shouldnt be saved to the config file */
varman_database *dynamic_defs;

int preferences_freshinstall;
int preferences_saveonexit=1;

void preferences_edit_hide(GtkWidget *w,gpointer data)
{
        layoutconfig_widget_hide(preferences_editmain,"preferences");
}
;

void preferences_setapplyhandler(GtkSignalFunc handler,
				 gpointer data)
{
	gtk_signal_connect(GTK_OBJECT(preferences_edit_ok),"clicked",
			   handler,data);
	gtk_signal_connect(GTK_OBJECT(preferences_edit_apply),"clicked",
			   handler,data);
}
;

void preferences_setundohandler(GtkSignalFunc handler,
				gpointer data)
{
	gtk_signal_connect(GTK_OBJECT(preferences_edit_cancel),"clicked",
			   handler,data);
	gtk_signal_connect(GTK_OBJECT(preferences_edit_undo),"clicked",
			   handler,data);
}
;

void preferences_removeapplyhandler_by_data(gpointer data)
{
	gtk_signal_disconnect_by_data(GTK_OBJECT(preferences_edit_ok),data);
	gtk_signal_disconnect_by_data(GTK_OBJECT(preferences_edit_apply),data);
}
;

void preferences_removeundohandler_by_data(gpointer data)
{
	gtk_signal_disconnect_by_data(GTK_OBJECT(preferences_edit_cancel),data);
	gtk_signal_disconnect_by_data(GTK_OBJECT(preferences_edit_undo),data);
}
;

void preferences_removeapplyhandler_by_func(GtkSignalFunc func)
{
	gtk_signal_disconnect_by_func(GTK_OBJECT(preferences_edit_ok),func,NULL);
	gtk_signal_disconnect_by_func(GTK_OBJECT(preferences_edit_apply),func,NULL);
}
;

void preferences_removeundohandler_by_func(GtkSignalFunc func)
{
	gtk_signal_disconnect_by_func(GTK_OBJECT(preferences_edit_cancel),func,NULL);
	gtk_signal_disconnect_by_func(GTK_OBJECT(preferences_edit_undo),func,NULL);
}
;


gint preferences_delete_event(GtkWidget *widget,
			      GdkEvent *event,
			      gpointer data)
{
	/* One maybe should expand setundohandler/removeundohandler, call all undo funcs in here 
	 * and hide the window -> delete_event == Cancel Button*/
	return TRUE; /* Yeah, i wanna keep the window */
};

void preferences_init()
{
   GtkWidget *label;
	
   varmanwidgets_widget *td;
	
	global_defs=varman_vardatabase_create_new(MAX_GLOBAL_DEFS);
	dynamic_defs=varman_vardatabase_create_new(MAX_DYNAMIC_DEFS);

	/* the most important environment variables */
	varman_setvar(dynamic_defs,"$HOME",getenv("HOME"));	

   	/* everything before the introduction of configfile versioning
	 * is 0.
	 * Whenever an essential thing changes in Gnometoaster's configuration,
	 * we inform the user upgrading from an earlier version and 
	 * reset the changed configuration entries to their new default
	 * values (if the user chooses to do so,otherwise he'll get some infor-
	 * mations about what has been changed in particular and then be
	 * left alone to do the necessary changes himself. */
   	varman_setvar(global_defs,"configfile_version","0");
   
	/* initialize with default definitions */
	varman_setvar(global_defs,"fsedit_destpath",
		      DEFAULTENTRIES_FSEDIT_DESTPATH);
	varman_setvar(global_defs,"tempdir",
		      DEFAULTENTRIES_TEMPDIR);
	varman_setvar(global_defs,"recorder",
		      DEFAULTENTRIES_RECORDER);   
	varman_setvar(global_defs,"rec_mountpoint",
		      DEFAULTENTRIES_REC_MOUNTPOINT);   
	varman_setvar(global_defs,"rec_scsiid",
		      DEFAULTENTRIES_REC_SCSIID);
	varman_setvar(global_defs,"rec_client",
		      DEFAULTENTRIES_REC_CLIENT);
	varman_setvar(global_defs,"rec_fixate",
		      DEFAULTENTRIES_REC_FIXATE);
	varman_setvar(global_defs,"rec_writetrack",
		      DEFAULTENTRIES_REC_WRITETRACK);
	varman_setvar(global_defs,"rec_cleardisc",
		      DEFAULTENTRIES_REC_CLEARDISC);
	varman_setvar(global_defs,"rec_blankingmode",
		      DEFAULTENTRIES_REC_BLANKINGMODE);
	varman_setvar(global_defs,"rec_ejectdisc",
		      DEFAULTENTRIES_REC_EJECTDISC);
	varman_setvar(global_defs,"rec_getmsinfo",
		      DEFAULTENTRIES_REC_GETMSINFO);
	varman_setvar(global_defs,"rec_doeject",
		      DEFAULTENTRIES_REC_DOEJECT);
	varman_setvar(global_defs,"rec_dummymode",
		      DEFAULTENTRIES_REC_DUMMYMODE);
	varman_setvar(global_defs,"rec_dofixate",
		      DEFAULTENTRIES_REC_DOFIXATE);
	varman_setvar(global_defs,"rec_multisession",
		      DEFAULTENTRIES_REC_MULTISESSION);
	varman_setvar(global_defs,"rec_speed",
		      DEFAULTENTRIES_REC_SPEED);
	varman_setvar(global_defs,"isotrack_client",
		      DEFAULTENTRIES_ISOTRACK_CLIENT);
	varman_setvar(global_defs,"isotrack_client_ms",
		      DEFAULTENTRIES_ISOTRACK_CLIENT_MS);
	varman_setvar(global_defs,"isotrack_tsclient",
		      DEFAULTENTRIES_ISOTRACK_TSCLIENT);
	varman_setvar(global_defs,"isotrack_mount",
		      DEFAULTENTRIES_ISOTRACK_MOUNT);
	varman_setvar(global_defs,"isotrack_umount",
		      DEFAULTENTRIES_ISOTRACK_UMOUNT);
	varman_setvar(global_defs,"isotrack_precache",
		      DEFAULTENTRIES_ISOTRACK_PRECACHE);
	varman_setvar(global_defs,"isotrack_fseditdelonexit",
		      DEFAULTENTRIES_ISOTRACK_FSEDITDELONEXIT);
	varman_setvar(global_defs,"isotrack_bootimage",
		      DEFAULTENTRIES_ISOTRACK_BOOTIMAGE);
	varman_setvar(global_defs,"isotrack_makebootable",
		      DEFAULTENTRIES_ISOTRACK_MAKEBOOTABLE);
	varman_setvar(global_defs,"isotrack_eltorito",
		      DEFAULTENTRIES_ISOTRACK_ELTORITO);
	varman_setvar(global_defs,"audiotrack_client",
		      DEFAULTENTRIES_AUDIOTRACK_CLIENT);
	varman_setvar(global_defs,"audiotrack_read",
		      DEFAULTENTRIES_AUDIOTRACK_READ);
	varman_setvar(global_defs,"audiotrack_precache",
		      DEFAULTENTRIES_AUDIOTRACK_PRECACHE);
	varman_setvar(global_defs,"cddrives_drives",
		      DEFAULTENTRIES_CDDRIVES_DRIVES);   
        varman_setvar(global_defs,"statistics_leadoutsize",
		      DEFAULTENTRIES_STATISTICS_LEADOUTSIZE);   
        varman_setvar(global_defs,"statistics_fastblank",
		      DEFAULTENTRIES_STATISTICS_FASTBLANK);
        varman_setvar(global_defs,"statistics_allblank",
		      DEFAULTENTRIES_STATISTICS_ALLBLANK);
       
   /* esd is the most amazing sound engine I ever saw. It works flawlessly and
    * its comfortable for both user and author - so we make this the default
    * if its available */

   varman_setvar(global_defs,"audio_default",DEFAULTENTRIES_AUDIO_DEFAULT_NOSOUND);
   #ifdef HAVE_OSS
     varman_setvar(global_defs,"audio_default",DEFAULTENTRIES_AUDIO_DEFAULT_OSS);
   #endif     
   #ifdef HAVE_ESD
     varman_setvar(global_defs,"audio_default",DEFAULTENTRIES_AUDIO_DEFAULT_ENLIGHTENMENT);
   #endif

	/* load the GnomeToaster Configuration file,overwriting the defaults
	 * defined above if present 
	 * set "fresh install" flag if no config file could be found */
     	preferences_freshinstall=!varman_loaddatabase(global_defs,
						      varman_replacevars_copy(dynamic_defs,"$HOME/.gtoasterrc"),
						      "[global_defs]");
	
	/* register store call for settings */
	configfile_registersection("[global_defs]",				   
				   (configfile_store)varman_savedatabase_fd,
				   (gpointer)global_defs);
	
	preferences_editmain=gtk_dialog_new();
	gtk_widget_set_usize(preferences_editmain,640,300);
	gtk_window_set_title(GTK_WINDOW(preferences_editmain),_("GnomeToaster Preferences"));
	gtk_signal_connect(GTK_OBJECT(preferences_editmain),"delete_event",
			   GTK_SIGNAL_FUNC(preferences_delete_event),NULL);

	preferences_editpad=gtk_notebook_new();
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(preferences_editmain)->vbox),
			   preferences_editpad,TRUE,TRUE,1);
	gtk_widget_show(preferences_editpad);
	
   #ifdef HAVE_GNOME
     	preferences_edit_undo=gnome_stock_button(GNOME_STOCK_BUTTON_PREV);
   #else
	preferences_edit_undo=gtk_button_new_with_label(_("Undo"));
   #endif
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(preferences_editmain)->action_area),
			   preferences_edit_undo,FALSE,FALSE,0);
	gtk_widget_show(preferences_edit_undo);
	
   #ifdef HAVE_GNOME
     	preferences_edit_apply=gnome_stock_button(GNOME_STOCK_BUTTON_APPLY);
   #else
	preferences_edit_apply=gtk_button_new_with_label(_("Apply"));
   #endif
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(preferences_editmain)->action_area),
			   preferences_edit_apply,FALSE,FALSE,0);
	gtk_widget_show(preferences_edit_apply);
   
   #ifdef HAVE_GNOME
     	preferences_edit_ok=gnome_stock_button(GNOME_STOCK_BUTTON_OK);
   #else
	preferences_edit_ok=gtk_button_new_with_label("OK");
   #endif
	gtk_signal_connect(GTK_OBJECT(preferences_edit_ok),"clicked",
			   preferences_edit_hide,NULL);	
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(preferences_editmain)->action_area),
			   preferences_edit_ok,FALSE,FALSE,0);
	gtk_widget_show(preferences_edit_ok);

   #ifdef HAVE_GNOME
     	preferences_edit_cancel=gnome_stock_button(GNOME_STOCK_BUTTON_CANCEL);
   #else
	preferences_edit_cancel=gtk_button_new_with_label(_("Cancel"));
   #endif
	gtk_signal_connect(GTK_OBJECT(preferences_edit_cancel),"clicked",
			   preferences_edit_hide,NULL);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(preferences_editmain)->action_area),
			   preferences_edit_cancel,FALSE,FALSE,0);
	gtk_widget_show(preferences_edit_cancel);
	

	preferences_common=gtk_vbox_new(0,0);
	gtk_widget_show(preferences_common);
	label=gtk_label_new(_("Common"));
	gtk_widget_show(label);
	gtk_notebook_append_page(GTK_NOTEBOOK(preferences_editpad),
				 preferences_common,
				 label);

	td=varmanwidgets_entry_new(_("Temp Files"),
				   "tempdir",
				   global_defs,APPLYMODE_BUTTON,160,320);
	gtk_box_pack_start(GTK_BOX(preferences_common),td->visual,0,0,0);      
};

void preferences_save()
{
   if (preferences_saveonexit)
     configfile_save(varman_replacevars_copy(dynamic_defs,"$HOME/.gtoasterrc"));
};
