/* piping functions for data filters and cd writing */

#ifndef PIPING_H
#define PIPING_H

#include <gtk/gtk.h>

#define PIPING_MAX_ARGS 50
#define PIPING_PIDWATCH_TIMEOUT 500

typedef int(*piping_finishcb)(int status,gpointer data);

/* that kind of function is called when forking to a background function using
 * piping_create_function() */
typedef void(*piping_pipefunc)(int c_stdin,int c_stdout,int c_stderr,gpointer data);

typedef struct 
{
	int  pid;
	int  status;  // status as given back by waitpid
	int  handle;  // handle for timer
	piping_finishcb finishcb;
	gpointer data;
} piping_watch;

#define PIPING_WATCHALL 0xff
#define PIPING_WATCHSTDOUT 0x01
#define PIPING_WATCHSTDERR 0x02

int piping_create(char *command,int *in,int *out,int *err);
/* run a function in background and connect to the main process using pipes
 * the same way as in piping_create */
int piping_create_function(piping_pipefunc,gpointer,int *in,int *out,int *err);
/* call a client and store the output specified by mask to the buffer 
 * until maxoutput count is reached */
void piping_create_getoutput(char *command,
			     char *buf,
			     int maxoutput,
			     char watchmask);
piping_watch *piping_pidwatch_add(int pid,
				  piping_finishcb,
				  gpointer data);
void piping_pidwatch_remove(piping_watch*);

#endif PIPING_H
