/* contains some litte helper functions used by parts of Gnometoaster */

#ifndef HELPINGS_H
#define HELPINGS_H

#include <gtk/gtk.h>

/* build sum of all a numbers digits */
int helpings_dsum(int val);
GList *helpings_buildglist(char *stringlist[]);
char *helpings_getlinestart(char *s,int n);
/* get line number n,cut the rest so that this particular line is the only
 * thing remaining. Make a copy first,of course... */
char *helpings_getlineno(char *s,int n);
/* get the n-th value occurring in a string */
float helpings_getvalueinstring(char *s,int n);

void helpings_formatnumber(char *buf,int bufsize,long long unsigned int number);

/* set verbose to 1 if you want the meaning of the different numbers
 * to be spelled out like "01 hour(s) 23 minute(s) 23 sec." */
char *helpings_secs2hms(int secs,int verbose);

/* compare a word to a list of words separated by "sep" and return true if
 * it was found */
int helpings_listcomp(char *list,char *word,char *sep);

/* get valid location of a file out of a list of possible locations */
char *helpings_locate(char *paths[]);

/* translate a list of strings using gettext and store the results in the
 * new stringlist returned by this function */
char **helpings_translatestringlist(char **list);  

#endif // HELPINGS_H
