#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <regex.h>

#include "npfile.h"
#include "nptext.h"

void NP_Text::iso8859_1()
{
   iso8859_1_headers();
   iso8859_1_body();

   return;
}

void NP_Text::iso8859_1_headers()
{
   static regex_t regex;
   static int compiled = 0;

   if ( text == NULL )
   {
      if ( compiled )
         regfree( &regex );
      return;
   }

   if ( strstr( text, "8859-1" ) == NULL )
      return;

   if ( !compiled )
   {
      int result = regcomp( &regex, 
            "^([A-Z][^:]+:[^=]+)"
            "=\\?[Ii][Ss][Oo]-8859-1\\?[Qq]\\?([^?]+)\\?=([^\r]*)\r", 
            REG_EXTENDED );
      if ( result )
      {
         char buffer[ 128 ], error[ 64 ];
         regerror( result, &regex, error, sizeof error );
         snprintf( buffer, sizeof buffer, "NP_Text: do_header: %s\n", error );
         fprintf( stderr, buffer );
         return;
      }
      else
         compiled = 1;
   }

   regmatch_t matches[ 4 ];

   char *endpoint = strstr( text, "\r\n\r\n" );
   if ( endpoint == NULL )
      endpoint = strstr( text, ".\r\n" );
   else
      endpoint += 2;

   for( char *pointer = text;
        pointer < endpoint;
        pointer = strchr( pointer, '\n' ) + 1 )
   {
      int result = regexec( &regex, pointer, 4, matches, 0 );
      if ( result == REG_NOMATCH )
         continue;
      else if ( result )
      {
         char buffer[ 128 ], error[ 64 ];
         regerror( result, &regex, error, sizeof error );
         snprintf( buffer, sizeof buffer, "NP_Text: do_header: %s\n", error );
         fprintf( stderr, buffer );
         return;
      }

      if ( matches[ 2 ].rm_so == -1 || matches[ 2 ].rm_eo == -1 )
         continue;

      char buffer[ 1024 ], second_buffer[ 1024 ];
      char *end = pointer + matches[ 2 ].rm_eo;
      char *s_pointer = pointer + matches[ 2 ].rm_so;
      char *d_pointer = buffer;

      while( s_pointer < end )
      {
         if ( *s_pointer == '=' )
         {
            *d_pointer++ = 
               ( *( s_pointer + 1 ) - 55 ) * 16 + *( s_pointer + 2 ) - 55;
            s_pointer += 3;
         }
         else
            *d_pointer++ = *s_pointer++;
      }

      *d_pointer = '\0';

      int len = matches[ 1 ].rm_eo - matches[ 1 ].rm_so;
      strncpy( second_buffer, pointer, len );
      second_buffer[ len ] = '\0';
      strcat( second_buffer, buffer );

      if ( matches[ 3 ].rm_so != -1 )
      {
         int old_len = strlen( second_buffer );
         len = matches[ 3 ].rm_eo - matches[ 3 ].rm_so;
         strncat( second_buffer, pointer + matches[ 3 ].rm_so, len );
         second_buffer[ old_len + len ] = '\0';
      }

      len = strlen( second_buffer );
      strncpy( pointer, second_buffer, len );

      d_pointer = pointer + len;
      while( *d_pointer != '\r' )
         *d_pointer++ = ' ';
   }

   return;
}

void NP_Text::iso8859_1_body()
{
   static regex_t regex, regex2;
   static int compiled1 = 0, compiled2 = 0;

   if ( header )
      return;

   if ( text == NULL )
   {
      if ( compiled1 )
         regfree( &regex );
      if ( compiled2 )
         regfree( &regex2 );

      return;
   }

   if ( strstr( text, "8859-1" ) == NULL )
      return;

   if ( !compiled1 )
   {
      int result = regcomp( &regex, 
            "^Content-[Tt]ransfer-[Ee]ncoding:"
            " +quoted-printable", REG_EXTENDED );
      if ( result )
      {
         char buffer[ 128 ], error[ 64 ];
         regerror( result, &regex, error, sizeof error );
         snprintf( buffer, sizeof buffer, "NP_Text: do_body: %s\n", error );
         fprintf( stderr, buffer );
         return;
      }
      else
         compiled1 = 1;
   }

   int encoding = 0;

   char *endpoint = strstr( text, "\r\n\r\n" );
   if ( endpoint == NULL )
      return;
   else 
      endpoint += 2;

   for( char *pointer = text; 
        pointer < endpoint; 
        pointer = strchr( pointer, '\n' ) + 1 )
   {
      int result = regexec( &regex, pointer, 0, NULL, 0 );
      if ( result == REG_NOMATCH )
         continue;
      else if ( result )
      {
         char buffer[ 128 ], error[ 64 ];
         regerror( result, &regex, error, sizeof error );
         snprintf( buffer, sizeof buffer, "NP_Text: do_body: %s\n", error );
         fprintf( stderr, buffer );
         return;
      }

      encoding = 1;
      break;
   }

   if ( !encoding )
      return;

   if ( !compiled2 )
   {
      int result = regcomp( &regex2, 
            "^Content-[Tt]ype: +text/plain; +charset=[Ii][Ss][Oo]"
            "-8859-1", 
            REG_EXTENDED );
      if ( result )
      {
         char buffer[ 128 ], error[ 64 ];
         regerror( result, &regex, error, sizeof error );
         snprintf( buffer, sizeof buffer, "NP_Text: do_body: %s\n", error );
         fprintf( stderr, buffer );
         return;
      }
      else
         compiled2 = 1;
   }

   int charset = 0;

   for( char *pointer = text;
        pointer < endpoint;
        pointer = strchr( pointer, '\n' ) + 1 )
   {
      int result = regexec( &regex, pointer, 0, NULL, 0 );
      if ( result == REG_NOMATCH )
         continue;
      else if ( result )
      {
         char buffer[ 128 ], error[ 64 ];
         regerror( result, &regex, error, sizeof error );
         snprintf( buffer, sizeof buffer, "NP_Text: do_body: %s\n", error );
         fprintf( stderr, buffer );
         return;
      }

      charset = 1;
      break;
   }

   if ( !charset )
      return;

   char *pointer = strstr( text, "\r\n\r\n" );
   if ( pointer == NULL )
      return;

   if ( !*( pointer += 4 ))
      return;

   char *replacement_text;
   
   if (( replacement_text = ( char *)malloc( strlen( text ))) == NULL )
   {
      perror( "malloc" );
      exit( 1 );
   }

   char *d_pointer = replacement_text, *second_pointer = text;

   while( second_pointer != pointer )
      *d_pointer++ = *second_pointer++;

   while( *pointer )
   {
      if ( *pointer == '=' )
      {
         *d_pointer++ = 
            ( *( pointer + 1 ) - 55 ) * 16 + *( pointer + 2 ) - 55;
         pointer += 3;
      }
      else
         *d_pointer++ = *pointer++;
   }

   strcpy( text, replacement_text );
   free( replacement_text );

	return;
}
