#include <stdlib.h>
#include <stdio.h>
#include <regex.h>
#include <string.h>

#include "npfile.h"
#include "npstringarray.h"
#include "nppex.h"

void NP_Pex::adjust_time( int *hours, int *minutes, int *seconds,
                          int *day, int *month, int *year )
{
   if ( *minutes < 0 )
   {
      *minutes += 60;
      ( *hours )--;
   }
   else
      if ( *minutes > 59 )
      {
         *minutes -= 60;
         ( *hours )++;
      }

   if ( *hours < 0 )
   {
      *hours += 24;
      ( *day )--;
   }
   else
      if ( *hours > 23 )
      {
         *hours -= 24;
         ( *day )++;
      }

   if ( *day < 1 )
   {
      switch( *month )
      {
      case 3:
         /* 
            Determine leap year.
            Don't use this program after a hundred years :)
         */

         if ( ( div( *year, 4 )).rem )
            *day = 28;
         else
            *day = 29;

         break;

      case 5:
      case 7:
      case 10:
      case 12:
         *day = 30;
         break;

      default:
         *day = 31;
         break;
      }

      ( *month )--;
   }
   else
      if ( *day > 28 )
      {
         switch( *month )
         {
         case 2:
            if ( ( div( *year, 4 )).rem )
               *day = 1;
            else
               *day = 29;

            ( *month )++;
            break;

         case 4:
         case 6:
         case 9:
         case 11:
            if ( *day > 30 )
            {
               *day -= 30;
               ( *month )++;
            }
            break;

         default:
            if ( *day > 31 )
            {
               *day -= 31;
               ( *month )++;
            }
            break;
         }
      }

   if ( *month < 1 )
   {
      *month += 12;
      ( *year )--;
   }
   else
      if ( *month > 12 )
      {
         *month -= 12;
         ( *year )++;
      }

   return;
}
