#include "npconfig.h"
#include "ctype.h"
#include "string.h"

void NP_Config::create_server_list( GtkWidget *outer_box )
{
   int total;
   if(( total = subscription.get_total() ) < 0 )
   {
      subscription.print_error();
      return;
   }

   if ( server_frames != NULL )
      free( server_frames );

   if (( server_frames = ( GtkWidget **)calloc( total,
                                               sizeof *server_frames ))
       == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   if ( total )
   {
      for( int i = 0; i < total; ++i )
      {
         const char *server;
         if (( server = subscription[ i ] ) == NULL )
         {
            subscription.print_error();
            return;
         }

         create_server_frame( outer_box, i, server );
      }
   }

   return;
}
