#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <signal.h>
#include <ctype.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

void undelete_all_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   if ( !collections->deleted )
   {
      collections->show_message( "There are no deleted messages on file.", 0 );
      return;
   }
   
   for( int i = 0; i < collections->deleted; ++i )
   {
      collections->undelete_selection = 0;
      undelete_callback( NULL, data );
   }

   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/DELETED",
             getenv( "HOME" ));
   truncate( buffer, 0 );

   undelete_refresh( collections );
   collections->update_tree();
   
   return;
}

void undelete_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   if ( !collections->deleted )
   {
      collections->show_message( "There are no deleted messages on file.", 0 );
      return;
   }

   if ( collections->undelete_selection == -1 )
   {
      collections->show_message( "No message in the list is selected.", 0 );
      return;
   }
   
   char *server;
   gtk_clist_get_text( GTK_CLIST( collections->undelete_clist ),
                       collections->undelete_selection,
                       0, &server );

   char *group;
   gtk_clist_get_text( GTK_CLIST( collections->undelete_clist ),
                       collections->undelete_selection, 1, &group );

   char *home, buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/%s-%s",
             home = getenv( "HOME" ), server, group );

   NP_File file;
   if ( file.opena( buffer ))
   {
      file.print_error();
      return;
   }

   int read_file = 0;
   NP_File read;
   if ( !strcmp( group, "Folders" ))
   {
      read_file = 1;
      strcat( buffer, ":read" );
      if ( read.opena( buffer ))
      {
         read.print_error();
         return;
      }
   }

   char del_path[ 1024 ];
   snprintf( del_path, sizeof del_path, "%s/.peruser_spool/DELETED", home );

   NP_File del;
   if ( del.openr( del_path ))
   {
      del.print_error();
      return;
   }

   NP_File temp_del;
   char temp_del_path[ 1024 ];
   snprintf( temp_del_path, sizeof temp_del_path, "%s:tmp", del_path );
   if ( temp_del.openw( temp_del_path ))
   {
      temp_del.print_error();
      return;
   }

   char *line;

   while( collections->undelete_selection-- )
   {
      do
      {
         if (( line = del.get_string()) == NULL )
            break;

         if ( temp_del.put_string( line ))
         {
            temp_del.print_error();
            break;
         }
      }
      while( strncmp( line, ".\r\n", 3 ));
   }

   for( int i = 0; i < 5; ++i )
   {
      if (( line = del.get_string()) == NULL )
         break;
   }

   if (( line = del.get_string()) == NULL )
      return;

   int header = 0;
   if ( *line == '@' )
      header = 1;

   do
   {
      if ( file.put_string( line ))
      {
         file.print_error();
         break;
      }

      if (( line = del.get_string()) == NULL )
         break;
   }
   while( strncmp( line, ".\r\n", 3 ));
   
   if ( file.put_string( line ))
   {
      file.print_error();
      return;
   }

   if ( read_file && read.put_string( "u\n" ))
   {
      read.print_error();
      return;
   }

   while(( line = del.get_string()) != NULL )
      if ( temp_del.put_string( line ))
      {
         temp_del.print_error();
         break;
      }

   del.close();
   temp_del.close();

   file.close();
   if ( read_file )
      read.close();

   rename( temp_del_path, del_path );

   if ( widget != NULL )
   {
      collections->update_tree();
      undelete_refresh( collections );
   }
   
   return;
}

void close_undelete_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   gtk_widget_destroy( collections->undelete_window );

   collections->undelete_window = NULL;
   collections->undelete_selection = -1;

   return;
}

void remove_undelete_all_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   if ( !collections->deleted )
   {
      collections->show_message( "There are no deleted messages on file.", 0 );
      return;
   }
   
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/DELETED",
             getenv( "HOME" ));

   truncate( buffer, 0 );

   undelete_refresh( collections );

   return;
}

void remove_undelete_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   if ( !collections->deleted )
   {
      collections->show_message( "There are no deleted messages on file.", 0 );
      return;
   }

   if ( collections->undelete_selection == -1 )
   {
      collections->show_message( "No message in the list is selected.", 0 );
      return;
   }
   
   char *home, deleted_path[ 1024 ];
   snprintf( deleted_path, sizeof deleted_path, "%s/.peruser_spool/DELETED",
             home = getenv( "HOME" ));

   char temp_deleted_path[ 1024 ];
   snprintf( temp_deleted_path, sizeof temp_deleted_path, "%s:tmp",
             deleted_path );

   NP_File del, temp_del;

   if ( del.openr( deleted_path ))
   {
      del.print_error();
      return;
   }

   if ( temp_del.openw( temp_deleted_path ))
   {
      temp_del.print_error();
      return;
   }

   int idx = collections->undelete_selection;
   char *line;

   while( idx-- )
   {
      do
      {
         line = del.get_string();
         if ( line == NULL )
            break;

         if ( temp_del.put_string( line ))
         {
            temp_del.print_error();
            return;
         }
      }
      while( strncmp( line, ".\r\n", 3 ));
   }

   do
   {
      line = del.get_string();
      if ( line == NULL )
         break;
   }
   while( strncmp( line, ".\r\n", 3 ));

   while(( line = del.get_string()) != NULL )
      if ( temp_del.put_string( line ))
      {
         temp_del.print_error();
         return;
      }

   temp_del.close();
   del.close();

   rename( temp_deleted_path, deleted_path );

   undelete_refresh( collections );

   return;
}

void undelete_refresh( NP_Collections *collections )
{
   collections->undelete_selection = -1;

   NP_File file;
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser_spool/DELETED",
             getenv( "HOME" ));
   if ( file.openr( buffer ))
   {
      if ( errno == ENOENT )
         return;
      
      file.print_error();
      return;
   }

   gtk_clist_clear( GTK_CLIST( collections->undelete_clist ));
   gtk_clist_freeze( GTK_CLIST( collections->undelete_clist ));

   collections->deleted = 0;

   char *line;
   while(( line = file.get_string()) != NULL )
   {
      char *text[ 5 ];

      text[ 0 ] = strdup( strtok( line, "\r\n" ));
      if ( text[ 0 ] == NULL )
      {
         perror( "strdup" );
         exit( 1 );
      }

      for( int i = 1; i < 5; ++i )
      {
         if (( line = file.get_string()) == NULL )
            break;

         text[ i ] = strdup( strtok( line, "\r\n" ));
         if ( text[ i ] == NULL )
         {
            perror( "strdup" );
            exit( 1 );
         }
      }

      gtk_clist_append( GTK_CLIST( collections->undelete_clist ), text );
      ++collections->deleted;

      for( int i = 0; i < 5; ++i )
         free( text[ i ] );

      do
         if (( line = file.get_string()) == NULL )
         {
            file.print_error();
            break;
         }
      while( strncmp( line, ".\r\n", 3 ));
   }

   file.close();

   gtk_clist_thaw( GTK_CLIST( collections->undelete_clist ));

   snprintf( buffer, sizeof buffer, "There are %d deleted messages which "
             "can be undeleted.", collections->deleted );
   gtk_label_set( GTK_LABEL( collections->undelete_label ), buffer );
   
   return;
}

void undelete_clist_callback( GtkWidget *widget, gint row, gint col,
                              GdkEvent *event, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   collections->undelete_selection = row;

   return;
}

void undelete_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   if ( collections->undelete_window != NULL )
   {
      gdk_window_raise( collections->undelete_window->window );
      return;
   }

   collections->undelete_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
   GtkWidget *undelete_window = collections->undelete_window;
   gtk_widget_set_usize( undelete_window, 500, 300 );
   gtk_window_set_title( GTK_WINDOW( undelete_window ),
                         "News Peruser Undelete" );
   gtk_object_set_data( GTK_OBJECT( undelete_window ), "doit", ( gpointer)0 );
   gtk_signal_connect( GTK_OBJECT( undelete_window ), "delete_event",
                       GTK_SIGNAL_FUNC( close_undelete_callback ),
                       collections );
   gtk_signal_connect( GTK_OBJECT( undelete_window ), "destroy",
                       GTK_SIGNAL_FUNC( close_undelete_callback ),
                       collections );

   GtkWidget *frame = gtk_frame_new( NULL );
   gtk_widget_show( frame );
   gtk_container_border_width( GTK_CONTAINER( frame ), 10 );
   gtk_container_add( GTK_CONTAINER( undelete_window ), frame );

   GtkWidget *table = gtk_table_new( 20, 20, FALSE );
   gtk_widget_show( table );
   gtk_table_set_row_spacings( GTK_TABLE( table ), 10 );
   gtk_container_add( GTK_CONTAINER( frame ), table );
   gtk_container_border_width( GTK_CONTAINER( table ), 10 );

   collections->undelete_label = gtk_label_new( "" );
   gtk_widget_show( collections->undelete_label );
   gtk_table_attach_defaults( GTK_TABLE( table ), collections->undelete_label,
                              0, 20, 0, 1 );

   GtkWidget *undelete_scroll = gtk_scrolled_window_new( NULL, NULL );
   gtk_widget_show( undelete_scroll );

   static char *titles[] = { "Server", "Group", "Subject", "Author", "Date" };
   collections->undelete_clist = gtk_clist_new_with_titles( 5, titles );
   gtk_signal_connect( GTK_OBJECT( collections->undelete_clist ), "select_row",
                       GTK_SIGNAL_FUNC( undelete_clist_callback ),
                       collections );
   gtk_signal_connect( GTK_OBJECT( collections->undelete_clist ),
                       "unselect_row",
                       GTK_SIGNAL_FUNC( undelete_clist_callback ),
                       collections );
   gtk_widget_show( collections->undelete_clist );
   gtk_clist_set_column_width( GTK_CLIST( collections->undelete_clist ),
                               0, 150 );
   gtk_clist_set_column_width( GTK_CLIST( collections->undelete_clist ),
                               1, 150 );
   gtk_clist_set_column_width( GTK_CLIST( collections->undelete_clist ),
                               2, 300 );
   gtk_clist_set_column_width( GTK_CLIST( collections->undelete_clist ),
                               3, 300 );
   gtk_clist_set_column_width( GTK_CLIST( collections->undelete_clist ),
                               4, 300 );
   gtk_scrolled_window_add_with_viewport( 
         GTK_SCROLLED_WINDOW( undelete_scroll), collections->undelete_clist );
   gtk_table_attach_defaults( GTK_TABLE( table ), undelete_scroll,
                              0, 20, 1, 19 );

   GtkWidget *toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                                         GTK_TOOLBAR_TEXT );
   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 0, 19, 19, 20 );
   gtk_widget_show( toolbar );
   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Undelete ",
                            "Undelete the currently-selected deleted message."
                            " It will be put back into the newsgroup from "
                            "which it was deleted.",
                            NULL, NULL,
                            GTK_SIGNAL_FUNC( undelete_callback ),
                            collections );

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Undelete All ",
                            "Undelete all of the listed messages, putting"
                            " them back into the groups from which they "
                            "were deleted.",
                            NULL, NULL,
                            GTK_SIGNAL_FUNC( undelete_all_callback ),
                            collections );

   gtk_toolbar_append_space( GTK_TOOLBAR( toolbar ));

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Remove ",
                            "Remove the currently-selected message from"
                            " the DELETED file. Once removed, a message "
                            "is gone forever, and cannot be undeleted.",
                            NULL, NULL,
                            GTK_SIGNAL_FUNC( remove_undelete_callback ),
                            collections );

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Remove All ",
                            "Remove all of the messages from the DELETED"
                            " file. Once removed, they are gone forever, "
                            "and connot be undeleted.", NULL, NULL,
                            GTK_SIGNAL_FUNC( remove_undelete_all_callback ),
                            collections );
   
   toolbar = gtk_toolbar_new( GTK_ORIENTATION_HORIZONTAL,
                              GTK_TOOLBAR_TEXT );
   gtk_table_attach_defaults( GTK_TABLE( table ), toolbar, 19, 20, 19, 20 );
   gtk_widget_show( toolbar );

   gtk_toolbar_append_item( GTK_TOOLBAR( toolbar ), " Close ",
                            "Close the undelete window", NULL, NULL,
                            GTK_SIGNAL_FUNC( close_undelete_callback ),
                            collections );

   undelete_refresh( collections );

   gtk_widget_show( undelete_window );

   return;
}
