#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <ctype.h>

#include "npnews.h"

int NP_News::transfer( char *server, char *group_name,
                       np_news_t what, int how_many )
{
   if ( server == NULL )
   {
      strcpy( error_message, "NP_News: transfer(): NULL server address "
              "passed as argument." );
      return 1;
   }

   if ( group_name == NULL )
   {
      strcpy( error_message, "NP_News: transfer(): NULL group name passed "
              "as argument." );
      return 1;
   }

   if ( address != NULL )
      free( address );

   if (( address = strdup( server )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   if ( group != NULL )
      free( group );

   if (( group = strdup( group_name )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   total_messages_transferred = 0;

   if ( !strcasecmp( group, "OUTBOX" ))
      return sendmail();

   if ( !strcasecmp( server, "Folders" ))
      return get_folder_requests();

   if ( fd < 0 )
      if ( do_connect( server, "rw" ))
         return 1;

   if ( !strcasecmp( group, "FOLLOW-UPS" ))
      return post_articles();

   NP_File file;
   char buffer[ 1024 ];
   snprintf( buffer, sizeof buffer, "%s/.peruser4-newsrc", home );
   if ( file.openr( buffer ))
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "transfer(): ~/.peruser4-newsrc: %s",
                file.get_error());
      return 1;
   }

   int idx = 0;
   char *line;
   while(( line = file.get_string()) != NULL )
   {
      if ( isspace( *line ))
         continue;

      if ( !strcmp( server, strtok( line, "\n" )))
         break;

      ++idx;
   }

   if ( file.status() == EOF )
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "transfer(): no such server is listed in ~/.peruser4-newsrc: "
                "%s.", server );
      return 1;
   }

   file.close();
   
   snprintf( buffer, sizeof buffer, "%s/.peruser4-config", home );
   if ( file.openr( buffer ))
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "transfer(): could not retrieve authentication info: %s",
                file.get_error());
      return 1;
   }

   int i = 4;
   while( i-- )
      if ( file.get_string() == NULL )
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "transfer(): could not retrieve authentication info: %s",
                   file.get_error());
         return 1;
      }         

   while( idx-- )
   {
      int i = 3;
      while( i--)
         if ( file.get_string() == NULL )
         {
            snprintf( error_message, sizeof error_message, "NP_News: "
                      "transfer(): could not retrieve authentication info: %s",
                      file.get_error());
            return 1;
         }
   }

   if (( line = file.get_string()) == NULL )
   {
      snprintf( error_message, sizeof error_message, "NP_News: "
                "transfer(): could not retrieve authentication info: %s",
                file.get_error());
      return 1;
   }

   char user[ 1024 ], pass[ 1024 ];
   *user = '\0';
   *pass = '\0';

   if ( atoi ( line ))
   {
      if (( line = file.get_string()) == NULL )
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "transfer(): could not retrieve authentication info: %s",
                   file.get_error());
         return 1;
      }

      strcpy( user, line );

      if (( line = file.get_string()) == NULL )
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "transfer(): could not retrieve authentication info: %s",
                   file.get_error());
         return 1;
      }

      strcpy( pass, line );
   }

   file.close();

   if ( *user != '\0' && *pass != '\0' && *user != '\n' && *pass != '\n'  )
   {
      snprintf( buffer, sizeof buffer, "authinfo user %s\r\n",
                strtok( user, "\n" ));
      if ( put_string( buffer ))
         return 1;

      if ( get_string( buffer, sizeof buffer ))
         return 1;
      
      if ( strncmp( buffer, "381", 3 ))
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "transfer(): server responded to user name with: %s.",
                   buffer );
         return 1;
      }

      snprintf( buffer, sizeof buffer, "authinfo pass %s\r\n",
                strtok( pass, "\n" ));
      if ( put_string( buffer ))
         return 1;

      if ( get_string( buffer, sizeof buffer ))
         return 1;
      
      if ( strncmp( buffer, "281", 3 ))
      {
         snprintf( error_message, sizeof error_message, "NP_News: "
                   "transfer(): server responded to password with %s.",
                   buffer );
         return 1;
      }
   }

   int result = NP_HEADERS;
   switch( what )
   {
   case NP_HEADERS:
      result = get_messages( how_many, 1 );
      break;

   case NP_ARTICLES:
      result = get_messages( how_many, 0 );
      break;

   case NP_REQUESTS:
      result = get_requests();
      break;
   }

   return result;
}

