/*
 * Pan - A Newsreader for X
 * Copyright (C) 1999  Pan Development Team (pan@superpimp.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

#include <config.h>

#include "acache.h"
#include "articlelist.h"
#include "text.h"

/*---[ message_previous ]---------------------------------------------
 * called from the toolbar 'Previous' button, it changes the contents
 * of the MessageWindow to be the article directly above the selected
 * one in the articlelist.
 *
 * FIXME: what if they have nothing selected (but a message open in a
 * window, or a different message in the window than what's selected)?
 *--------------------------------------------------------------------*/
void
message_previous (GtkWidget *widget, Message *msg)
{
	const article_data *adata = articlelist_get_previous_article ();

	if (adata != NULL)
	{
		articlelist_set_selected_message_id ( adata->message_id );

		if ( adata->message_id )
			text_set_from_message_id ( articlelist_get_current_server (),
					articlelist_get_current_group (),
					adata->message_id, NNTP_ARTICLE_READ, FALSE );
	}
}


/*---[ message_next ]-------------------------------------------------
 *
 *--------------------------------------------------------------------*/
void
message_next (GtkWidget *widget, Message *msg)
{
	const article_data *adata = articlelist_get_next_article ();
	if (adata != NULL)
	{
		articlelist_set_selected_message_id ( adata->message_id );

		if (adata->message_id)
			text_set_from_message_id ( articlelist_get_current_server (),
					articlelist_get_current_group (),
					adata->message_id, NNTP_ARTICLE_READ, FALSE );

	}
}


/*---[ message_copy ]-------------------------------------------------
 * copy a Message structure (should rename this to message_dup)
 *--------------------------------------------------------------------*/
Message *
message_copy (const Message *src)
{
	Message *dest = g_malloc0 (sizeof (Message));
	
	dest->to = g_strdup (src->to);
	dest->from = g_strdup (src->from);
	dest->reply_to = g_strdup (src->reply_to);
	dest->date = g_strdup (src->date);
	dest->subject = g_strdup (src->subject);
	dest->body = g_strdup (src->body);

        dest->references = g_strdup (src->references);

        dest->newsgroups = g_strdup (src->newsgroups);
        dest->followup_to = g_strdup (src->followup_to);

	dest->message_id = g_strdup (src->message_id);

	dest->type = src->type;
	dest->window = src->window;

	dest->needs_window = src->needs_window;

	return dest;
}


/*---[ message_free ]-------------------------------------------------
 * free up all the memmory used by a Message data structure
 *--------------------------------------------------------------------*/
void
message_free (Message *msg)
{
	if (!msg)
		return;

	g_free (msg->to);
	g_free (msg->from);
        g_free (msg->reply_to);
	g_free (msg->organization);
	g_free (msg->date);
	g_free (msg->subject);
	g_free (msg->body);
	g_free (msg->references);
        g_free (msg->newsgroups);
        g_free (msg->followup_to);

	g_free (msg->message_id);
	g_free (msg);
}


void
message_import_adata (Message *msg, const article_data *adata)
{
	struct tm lcltime;
	gchar date[40];

	g_return_if_fail (adata!=NULL);

	g_free (msg->from);
	msg->from = g_strdup (adata->author);

	g_free (msg->reply_to);
	msg->reply_to = g_strdup (adata->reply_to);

	// FIXME: article_data needs "Organization" field
	// msg->organization = g_strdup (article->organization);

	g_free (msg->newsgroups);
	msg->newsgroups = g_strdup (adata->newsgroups);

	g_free (msg->followup_to);
	msg->followup_to = g_strdup (adata->followup_to);

	g_free (msg->date);
	localtime_r (&adata->date, &lcltime);
	strftime (date, sizeof(date), "%A, %B %e, %Y %l:%M %p", &lcltime);
	msg->date = g_strdup (date);

	g_free (msg->subject);
	msg->subject = g_strdup (adata->subject);

	g_free (msg->body);
	msg->body = acache_load_body (adata->message_id);

	g_free (msg->references);
	msg->references = g_strdup (adata->references);
}


/*---[ message_new ]--------------------------------------------------
 *
 *--------------------------------------------------------------------*/
Message*
message_new (
	const server_data *sdata,
	group_data *gdata,
	const article_data *adata)
{
	Message *msg;
	struct tm *lcltime;
	gchar date[40];

	msg = g_malloc0 (sizeof (Message));
	msg->sdata = sdata;
	msg->gdata = gdata;

	if (adata)
	{
		/* FIXME
		msg->to = g_strdup (Pan.active_group->name);
		*/
		msg->from = g_strdup (adata->author);
/* can't do this while article_data doesn't keep the "Organization" field...
 		msg->organization = g_strdup (article->organization); */

		lcltime = localtime (&adata->date);
		strftime (date, 40, "%A, %B %e, %Y %l:%M %p", lcltime);
		msg->date = g_strdup (date);
		msg->subject = g_strdup (adata->subject);
		msg->message_id = g_strdup (adata->message_id);
		msg->body = acache_load_body (adata->message_id);
		msg->reply_to = g_strdup (adata->reply_to);
		msg->followup_to = g_strdup (adata->followup_to);

		msg->references = g_strdup (adata->references);
	}
	else
	{

	}

	return msg;
}
