#
# Copyright (c) 1995 Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#	This product includes software developed by the Network Research
#	Group at Lawrence Berkeley National Laboratory.
# 4. Neither the name of the University nor of the Laboratory may be used
#    to endorse or promote products derived from this software without
#    specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

set rtp_type(126) raw
set rtp_type(22) bvc
set rtp_type(25) cellb
set rtp_type(26) jpeg
set rtp_type(27) cuseeme
set rtp_type(28) nv
set rtp_type(29) picw
set rtp_type(30) cpv
set rtp_type(31) h261
set rtp_type(32) mpeg
set rtp_type(42) h263+
set rtp_type(34) h263
set rtp_type(127) h261v1

proc vic_main {} {
	global V tcl_platform
	set V(class) Vic    
	set V(app) vic
	set V(media) video
	init_local
	init_confbus
	init_network
	if [yesno relateInterface] {
		if {$tcl_platform(platform) == "windows"} {
			after 9000
		}
		build.new.interface
	} else {
		init_gui
	}
	if [yesno logFrameRate] {
		global logFrameChannel
		set logFrameChannel [open [resource logFrameFile] "w"]
	}
	init_late
	build.menu
    if [yesno transmitOnStartup] {
		global transmitButton
		$transmitButton invoke
	}
}
