/*
 *  Copyright (C) 1998-99 Luca Deri <deri@unipi.it>
 *                      
 *  			  Centro SERRA, University of Pisa
 *  			  http://www-serra.unipi.it/
 *  					
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "ntop.h"

extern pcap_t *pcapPtr;

extern unsigned int netmask;
extern char *dirs[];
extern FlowFilterList *flowsList;
extern void sendString(char *theString);
extern char* getRowColor();
extern int webMode;

/* #define DEBUG */

/* ******************* */

int handlePluginHTTPRequest(char* url) {
  FlowFilterList *flows = flowsList;

  while(flows != NULL)
    if((flows->pluginPtr != NULL)
       && (flows->pluginPtr->pluginURLname != NULL)
       && (flows->pluginPtr->httpFunct != NULL)
       && (strncmp(flows->pluginPtr->pluginURLname, 
		   url, strlen(flows->pluginPtr->pluginURLname)) == 0)) {     
	void (*httpFunc)(char*);
	char *arg;
	
	httpFunc = (void(*)(char*))flows->pluginPtr->httpFunct;

	if(strlen(url) == strlen(flows->pluginPtr->pluginURLname))
	  arg = "";
	else
	  arg = &url[strlen(flows->pluginPtr->pluginURLname)+1];

	/* printf("Found %s [%s]\n", flows->pluginPtr->pluginURLname, arg); */
	httpFunc(arg);
	return(1);
    } else
      flows = flows->next;

  return(0); /* Plugin not found */
}

/* ******************* */

#if (defined(HAVE_DIRENT_H) && defined(HAVE_DLFCN_H)) || defined(WIN32) || defined(HPUX)
void loadPlugin(char* dirName, char* pluginName) {
  char pluginPath[256];
  char tmpBuf[BUF_SIZE];
#ifdef HPUX /* Courtesy Rusetsky Dmitry <dima@nbkbr.rosmail.com> */
  shl_t pluginPtr;
#else   
  void *pluginPtr;
#endif     
  void *pluginEntryFctnPtr;
  PluginInfo* pluginInfo;
  struct bpf_program fcode;
  int rc;
  PluginInfo* (*pluginJumpFunc)();
  FlowFilterList *newFlow;
    

  sprintf(pluginPath, "%s/%s", dirName, pluginName);

#ifdef DEBUG
  printf("Loading plugin '%s'...\n", pluginPath);
#endif


#ifdef HPUX /* Courtesy Rusetsky Dmitry <dima@nbkbr.rosmail.com> */
  /* Load the library */
  pluginPtr = shl_load(pluginPath, BIND_IMMEDIATE|BIND_VERBOSE|BIND_NOSTART ,0L); 
#else
#ifdef WIN32
  pluginPtr = LoadLibrary(TEXT(pluginPath));
#else
  pluginPtr = dlopen(pluginPath, RTLD_NOW /* RTLD_LAZY */); /* Load the library */
#endif /* WIN32 */
#endif /* HPUX  */

  if(pluginPtr == NULL) {
#if HPUX /* Courtesy Rusetsky Dmitry <dima@nbkbr.rosmail.com> */ 
    printf("WARNING: unable to load plugin '%s'\n[%s]\n", pluginPath,strerror(errno) );
#else
#ifdef WIN32
    printf("WARNING: unable to load plugin '%s'\n[%li]\n", pluginPath, GetLastError());
#else
    printf("WARNING: unable to load plugin '%s'\n[%s]\n", pluginPath, dlerror());
#endif /* WIN32 */
#endif /* HPUX */
    return;
  }

#ifdef HPUX /* Courtesy Rusetsky Dmitry <dima@nbkbr.rosmail.com> */
  if(shl_findsym(&pluginPtr ,PLUGIN_ENTRY_FCTN_NAME,
		 TYPE_PROCEDURE, &pluginEntryFctnPtr) == -1)
    pluginEntryFctnPtr = NULL;
#else    
#ifdef WIN32
  pluginEntryFctnPtr = (void*)GetProcAddress((HANDLE)pluginPtr, (LPCSTR)PLUGIN_ENTRY_FCTN_NAME);
#else
  pluginEntryFctnPtr = dlsym(pluginPtr, PLUGIN_ENTRY_FCTN_NAME);
#endif /* WIN32 */
#endif /* HPUX */


  if(pluginEntryFctnPtr == NULL) {
#ifdef HPUX /* Courtesy Rusetsky Dmitry <dima@nbkbr.rosmail.com> */
    printf("\nWARNING: unable to local plugin '%s' entry function [%s] \n",pluginPath,
	   strerror(errno)); 
#else
#ifdef WIN32
    printf("WARNING: unable to local plugin '%s' entry function [%li]\n", pluginPath, GetLastError());
#else
    printf("WARNING: unable to local plugin '%s' entry function [%s]\n", pluginPath, dlerror());
#endif /* WIN32 */
#endif /* HPUX */
    return;
  }
    
  pluginJumpFunc = (PluginInfo*(*)())pluginEntryFctnPtr;
  pluginInfo = pluginJumpFunc();

  if(pluginInfo == NULL) {
    printf("WARNING: %s call of plugin '%s' failed.\n", 
	   PLUGIN_ENTRY_FCTN_NAME, pluginPath);
    return;
  }

  if((pluginInfo->bpfFilter == NULL)
     || (pluginInfo->bpfFilter[0] == '\0')) {
/*
    printf("WARNING: plugin '%s' has an empty BPF filter.\n", pluginPath);
*/
    fcode.bf_insns = NULL;
  } else {
    strcpy(tmpBuf, pluginInfo->bpfFilter);
    rc = pcap_compile(pcapPtr, &fcode, tmpBuf, 1, netmask);
  
    if(rc < 0) {
      printf("WARNING: plugin '%s' contains a wrong filter specification\n"
	     "         \"%s\" (%s).\n",
	     pluginPath, pluginInfo->bpfFilter, pcap_geterr(pcapPtr));    
      return;
    }
  }

  newFlow = (FlowFilterList*)calloc(1, sizeof(FlowFilterList));
  
  if(newFlow == NULL) {
    printf("Fatal error: not enough memory. Bye!\n");
    exit(-1);
  } else {
    newFlow->flowName = strdup(pluginInfo->pluginName);
    newFlow->filterCode = fcode.bf_insns;
    newFlow->pluginPtr  = pluginInfo;
    newFlow->next = flowsList;
    flowsList = newFlow;
    printf("Adding: %s\n", pluginInfo->pluginName);
  }
  
#ifdef DEBUG
  printf("Plugin '%s' loaded succesfully.\n", pluginPath);
#endif
}

/* ******************* */

void loadPlugins() {
#ifndef WIN32
  char dirPath[256];
  struct dirent* dp;
  int idx;
  DIR* directoryPointer;
#else
  char tmpStr[512], _tmpnam[255];
  FILE *fd;
  int rc;
#endif

  if(webMode)
    printf("Loading plugins (if any)...\n");

#ifndef WIN32
  for(idx=0; dirs[idx] != NULL; idx++) {    
    sprintf(dirPath, "%s/plugins", dirs[idx]);    
    
    directoryPointer = opendir(dirPath);
    
    if(directoryPointer != NULL)
      break;
  }
 
  if(directoryPointer == NULL) {
    printf("WARNING: Unable to find the plugins/ directory.\n");
    return;
  } 
  
  while((dp = readdir(directoryPointer)) != NULL)
    {
      if(dp->d_name[0] == '.')
	continue;
      else if(strlen(dp->d_name) < strlen(PLUGIN_EXTENSION))
	continue;
      else if(strcmp(&dp->d_name[strlen(dp->d_name)-strlen(PLUGIN_EXTENSION)], PLUGIN_EXTENSION))
	continue;
      
      loadPlugin(dirPath, dp->d_name);
    }
#else /* WIN32 */
 
  tmpnam(_tmpnam); /* Get temporary file name */
  sprintf(tmpStr, "dir /B .\\plugins\\ > %s", _tmpnam);
  rc = system(tmpStr);

  if((rc == 0) && ((fd = fopen(_tmpnam, "r")) != NULL))
    {
      while(fgets(tmpStr, 255, fd) && 
	    (tmpStr[0] != '\n' /* Empty line -> end of the file */))
	{
	  tmpStr[strlen(tmpStr)-1] = '\0';
	  	  
	  if(tmpStr[0] == '.')
	    continue;
	  else if(strlen(tmpStr) < strlen(PLUGIN_EXTENSION))
	    continue;
	  else if(strcmp(&tmpStr[strlen(tmpStr)-strlen(PLUGIN_EXTENSION)], PLUGIN_EXTENSION))
	    continue;
          else       
	    loadPlugin(".\\plugins\\", tmpStr);
      
	  fclose(fd);
	}
    }

  _unlink(_tmpnam);

#endif /* WIN32 */
}

/* ******************* */

void unloadPlugins() {
  FlowFilterList *flows = flowsList;

  printf("Unloading plugins (if any)...\n");

  while(flows != NULL) {
    if(flows->pluginPtr != NULL) {  
#ifdef DEBUG
      printf("Unloading plugin '%s'...\n", flows->pluginPtr->pluginName);
#endif
      if(flows->pluginPtr->termFunc != NULL) {
	void (*termFunc)();

	termFunc = (void(*)())flows->pluginPtr-> termFunc;
	termFunc();
      }

#ifdef HPUX /* Courtesy Rusetsky Dmitry <dima@nbkbr.rosmail.com> */
      shl_unload((shl_t)flows->pluginPtr);
#else
#ifdef WIN32
      FreeLibrary((HANDLE)flows->pluginPtr);
#else
      dlclose(flows->pluginPtr);
#endif /* WIN32 */
#endif /* HPUX */
      flows->pluginPtr = NULL;
    }
    flows = flows->next;
  }
}

/* ************************************* */

void showPluginsList() {
  FlowFilterList *flows = flowsList;
  short printHeader = 0;
  char tmpBuf[BUF_SIZE];

  while(flows != NULL) {
    if((flows->pluginPtr != NULL)
       && (flows->pluginPtr->pluginURLname != NULL)) {
      
      if(!printHeader) {
		sendString("<HTML><BODY BGCOLOR=#FFFFFF>"
			   "<CENTER><FONT FACE=Helvetica>"
			   "<H1>Active Plugins</H1>\n<p>"
			   "<TABLE BORDER><TR>\n");
		sendString("<TR><TH>Name</TH><TH>Description</TH>"
			   "<TH>Version</TH>"
			   "<TH>Author</TH></TR>\n");
		printHeader = 1;
      }

      sprintf(tmpBuf, "<TR %s><TH ALIGN=LEFT><A HREF=/plugins/%s>%s</TH>"
	      "<TD ALIGN=LEFT>%s</TD>"
	      "<TD ALIGN=CENTER>%s</TD>"
	      "<TD ALIGN=LEFT>%s</TD></TR>\n", 
	      getRowColor(),
	      flows->pluginPtr->pluginURLname, 
	      flows->pluginPtr->pluginURLname, 
	      flows->pluginPtr->pluginDescr,
	      flows->pluginPtr->pluginVersion,
	      flows->pluginPtr->pluginAuthor);
      sendString(tmpBuf);
    }

    flows = flows->next;
  }

  if(!printHeader) {
   sendString("<HTML><BODY BGCOLOR=#FFFFFF><P><CENTER><H1>"
	       "<i>No Plugins available</i></H1>"
	      "</CENTER></FONT></CENTER><p>\n");    
  } else {
    sendString("</TABLE><p>\n");
  }
}
#else /* defined(HAVE_DIRENT_H) && defined(HAVE_DLFCN_H) */

int handlePluginHTTPRequest(char* url) {
  return(0); /* Plugin not found */
}

void loadPlugins() {
  ;
}

void unloadPlugins() {
  ;
}

#endif /* defined(HAVE_DIRENT_H) && defined(HAVE_DLFCN_H) */
