/*
 * funny.c: Well, I put some stuff here and called it funny.  So sue me. 
 *
 * written by michael sandrof
 *
 * copyright(c) 1990 
 *
 * see the copyright file, or do a help ircii copyright 
 */

#if 0
static	char	rcsid[] = "@(#)$Id: funny.c,v 1.9 1994/07/02 02:32:13 mrg Exp $";
#endif

#include "irc.h"
#include "funny.h"
#include "hook.h"
#include "ircaux.h"
#include "lastlog.h"
#include "names.h"
#include "numbers.h"
#include "output.h"
#include "parse.h"
#include "server.h"
#include "term.h"
#include "vars.h"

struct	WideListInfoStru
{
	char	*channel;
	int	users;
};

typedef	struct WideListInfoStru WideList;

static	WideList **wide_list = (WideList **) 0;
static	int	wl_size = 0;
static	int	wl_elements = 0;

static	char	*names_channel = (char *) 0;
static	char	*mode_channel = (char *) 0;
static	char	*match = (char *) 0;
static	int	ignore_mode = 0;

static	int	funny_min;
static	int	funny_max;
static	int	funny_flags;

extern int funny_is_ignore_channel _((void))
{
	return (names_channel != (char *) 0);
}

#ifdef __STDC__
extern void	funny_match (char *stuff)
#else
extern void	funny_match (stuff) 
	char	*stuff;
#endif
{
	malloc_strcpy(&match, stuff);
}

extern void	funny_set_ignore_mode _((void))
{
	mode_channel = names_channel;
	names_channel = (char *) 0;
	ignore_mode++;
}

#ifdef __STDC__
extern void	funny_set_ignore_channel (char *str)
#else
extern void	funny_set_ignore_channel (str) 
	char	*str;
#endif
{
	malloc_strcpy(&names_channel, str);
}

#ifdef __STDC__
extern void	set_funny_flags (int min, int max, int flags)
#else
extern void	set_funny_flags (min, max, flags) 
	int	min,
		max,
		flags;
#endif
{
	funny_min = min;
	funny_max = max;
	funny_flags = flags;
}

#ifdef __STDC__
static int	funny_widelist_users (WideList **left, WideList **right)
#else
static int	funny_widelist_users (left, right)	 
	WideList	**left,
			**right;
#endif
{
	if ((**left).users > (**right).users)
		return -1;
	else if ((**right).users > (**left).users)
		return 1;
	else
		return my_stricmp((**left).channel, (**right).channel);
}

#ifdef __STDC__
static int	funny_widelist_names (WideList **left, WideList **right)
#else
static int	funny_widelist_names (left, right) 
	WideList	**left,
			**right;
#endif
{
	int	comp;

	if ((comp = my_stricmp((**left).channel, (**right).channel)) != 0)
		return comp;
	else if ((**left).users > (**right).users)
		return -1;
	else if ((**right).users > (**left).users)
		return 1;
	else
		return 0;
}


extern void	funny_print_widelist _((void))
{
	int	i;
	char	buffer1[BIG_BUFFER_SIZE];
	char	buffer2[BIG_BUFFER_SIZE];
	char	*ptr;

	if (!wide_list)
		return;

	if (funny_flags & FUNNY_NAME)
		qsort((void *) wide_list, wl_elements, sizeof(WideList *),
		(int (*) _((const void *, const void *)))funny_widelist_names);
	else if (funny_flags & FUNNY_USERS)
		qsort((void *) wide_list, wl_elements, sizeof(WideList *),
		(int (*) _((const void *, const void *)))funny_widelist_users);

	*buffer1 = '\0';
	for (i = 1; i < wl_elements; i++)
	{
		sprintf(buffer2, "%s(%d) ", wide_list[i]->channel,
				wide_list[i]->users);
		ptr = index(buffer1, '\0');
		if (strlen(buffer1) + strlen(buffer2) > CO - 5)
		{
			if (do_hook(WIDELIST_LIST, "%s", buffer1))
				say("%s", buffer1);
			*buffer1 = '\0';
			strcat(buffer1, buffer2);
		}
		else
			strcpy(ptr, buffer2);
	}
	if (*buffer1 && do_hook(WIDELIST_LIST, "%s", buffer1))
		say("%s" , buffer1);
	for (i = 0; i < wl_elements; i++)
	{
		new_free(&wide_list[i]->channel);
		new_free((char **)&wide_list[i]);
	}
	new_free((char **)&wide_list);
	wl_elements = wl_size = 0;
}

#ifdef __STDC__
extern void	funny_list (char *from, char **ArgList)
#else
extern void	funny_list (from, ArgList) 
	char	*from;
	char	**ArgList;
#endif
{
	char	*channel,
		*user_cnt,
		*line;
	WideList **new_list;
	int	cnt;
	static	char	format[25];
	static	unsigned int	last_width = -1;

	if (last_width != get_int_var(CHANNEL_NAME_WIDTH_VAR))
	{
		if ((last_width = get_int_var(CHANNEL_NAME_WIDTH_VAR)) != 0)
			sprintf(format, "*** %%-%u.%us %%-5s  %%s",
				(unsigned char) last_width,
				(unsigned char) last_width);
		else
			strcpy(format, "*** %s\t%-5s  %s");
	}
	channel = ArgList[0];
	user_cnt = ArgList[1];
	line = PasteArgs(ArgList, 2);
	if (funny_flags & FUNNY_TOPIC && !(line && *line))
			return;
	cnt = atoi(user_cnt);
	if (funny_min && (cnt < funny_min))
		return;
	if (funny_max && (cnt > funny_max))
		return;
	if ((funny_flags & FUNNY_PRIVATE) && (*channel != '*'))
		return;
	if ((funny_flags & FUNNY_PUBLIC) && (*channel == '*'))
		return;
	if (match)
	{
		if (wild_match(match, channel) == 0)
			return;
	}
	if (funny_flags & FUNNY_WIDE)
	{
		if (wl_elements >= wl_size)
		{
			new_list = (WideList **) new_malloc(sizeof(WideList *) *
			    (wl_size + 50));
			bzero(new_list, sizeof(WideList *) * (wl_size + 50));
			if (wl_size)
				bcopy(wide_list, new_list, sizeof(WideList *)
					* wl_size);
			wl_size += 50;
			new_free((char **)&wide_list);
			wide_list = new_list;
		}
		wide_list[wl_elements] = (WideList *)
			new_malloc(sizeof(WideList));
		wide_list[wl_elements]->channel = (char *) 0;
		wide_list[wl_elements]->users = cnt;
		malloc_strcpy(&wide_list[wl_elements]->channel,
				(*channel != '*') ? channel : "Prv");
		wl_elements++;
		return;
	}
	if (do_hook(current_numeric, "%s %s %s %s", from,  channel, user_cnt,
	    line) && do_hook(LIST_LIST, "%s %s %s", channel, user_cnt, line))
	{
		if (channel && user_cnt)
		{
			if (*channel == '*')
				put_it(format, "Prv", user_cnt, line);
			else
				put_it(format, channel, user_cnt, line);
		}
	}
}

#ifdef __STDC__
extern void	funny_namreply (char *from, char **Args)
#else
extern void	funny_namreply (from, Args)
	char	*from;
	char	**Args;
#endif
{
	char	*type,
		*nick,
		*channel;
	static	char	format[40];
	static	unsigned int	last_width = -1;
	int	cnt;
	char	*ptr;
	char	*line;

	PasteArgs(Args, 2);
	type = Args[0];
	channel = Args[1];
	line = Args[2];
	message_from(channel, LOG_CRAP);
	if (names_channel && !my_stricmp(names_channel, channel))
	{
		if (do_hook(current_numeric, "%s %s %s %s", from, type, channel,
			line) && get_int_var(SHOW_CHANNEL_NAMES_VAR))
			say("Users on %s: %s", channel, line);
		while ((nick = next_arg(line, &line)) != NULL)
			add_to_channel(channel, nick, from_server, 0, 0);
		message_from(NULL, LOG_CURRENT);
		return;
	}
	if (last_width != get_int_var(CHANNEL_NAME_WIDTH_VAR))
	{
		if ((last_width = get_int_var(CHANNEL_NAME_WIDTH_VAR)) != 0)
			sprintf(format, "%%s: %%-%u.%us %%s",
				(unsigned char) last_width,
				(unsigned char) last_width);
		else
			strcpy(format, "%s: %s\t%s");
	}
	ptr = line;
	for (cnt = -1; ptr; cnt++)
	{
		if ((ptr = index(ptr, ' ')) != NULL)
			ptr++;
	}
	if (funny_min && (cnt < funny_min))
		return;
	else if (funny_max && (cnt > funny_max))
		return;
	if ((funny_flags & FUNNY_PRIVATE) && (*type == '='))
		return;
	if ((funny_flags & FUNNY_PUBLIC) && (*type == '*'))
		return;
	if (type && channel)
	{
		if (match)
		{
			if (wild_match(match, channel) == 0)
				return;
		}
		if (do_hook(current_numeric, "%s %s %s %s", from, type, channel,
			line) && do_hook(NAMES_LIST, "%s %s", channel, line))
		{
			switch (*type)
			{
			case '=':
				if (last_width &&(strlen(channel) > last_width))
				{
					channel[last_width-1] = '>';
					channel[last_width] = (char) 0;
				}
				put_it(format, "Pub", channel, line);
				break;
			case '*':
				put_it(format, "Prv", channel, line);
				break;
			case '@':
				put_it(format, "Sec", channel, line);
				break;
			}
		}
	}
	message_from(NULL, LOG_CURRENT);
}

#ifdef __STDC__
extern void	funny_mode (char *from, char **ArgList)
#else
extern void	funny_mode (from, ArgList)
	char	*from,
		**ArgList;
#endif
{
	char	*mode, *channel;

	if (!ArgList[0]) return;
	channel = ArgList[0];
	mode = ArgList[1];
	PasteArgs(ArgList, 1);
	if (ignore_mode)
	{
		update_channel_mode(channel ? channel : mode_channel, mode);
		update_all_status();
		ignore_mode--;
		new_free(&mode_channel);
	}
	else
	{
		if (channel)
		{
			message_from(channel, LOG_CRAP);
			if (do_hook(current_numeric, "%s %s %s", from, channel, mode))
				put_it("%s Mode for channel %s is \"%s\"",
					numeric_banner(), channel, mode);
		}
		else
		{
			if (do_hook(current_numeric, "%s %s", from, mode))
				put_it("%s Channel mode is \"%s\"",
					numeric_banner(), mode);
		}
	}
}

#ifdef __STDC__
extern void	update_user_mode (char *modes)
#else
extern void	update_user_mode (modes)
	char	*modes;
#endif
{
	int	onoff = 1;

	for (; *modes; modes++)
	{
		if (*modes == '-')
			onoff = 0;
		else if (*modes == '+')
			onoff = 1;

		else if   ((*modes >= 'a' && *modes <= 'z')
			|| (*modes >= 'A' && *modes <= 'Z'))
		{
			char c = tolower(*modes);
			size_t idx = (size_t) (index(umodes, c) - umodes);

			set_server_flag(from_server, USER_MODES << idx, onoff);

			if (c == 'o')
				set_server_operator(from_server, onoff);
		}
	}
}

extern void	reinstate_user_modes _((void))
{
	char *modes = get_umode(from_server);
	if (modes && *modes)
		send_to_server("MODE %s +%s", get_server_nickname(from_server), modes);
}
