/*
 * input.h: header for input.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: input.h,v 1.4 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _INPUT_H_
#define _INPUT_H_

#include "irc.h"

/* miscelaneous functions */
extern	void	change_input_prompt 	_((int));
extern	void	cursor_to_input 	_((void));
extern	char *	get_input 		_((void));
extern	char *	get_input_prompt 	_((void));
extern	void	init_input 		_((void));
extern	void	input_move_cursor 	_((int));
extern	char	input_pause 		_((char *));
extern	void	set_input 		_((char *));
extern	void	set_input_prompt 	_((char *));
extern	void	update_input 		_((int));

/* keybinding functions */
extern	void 	backward_character 	_((char, char *));
extern	void 	backward_history 	_((char, char *));
extern	void 	clear_screen 		_((char, char *));
extern	void	command_completion 	_((char, char *));
extern	void 	forward_character	_((char, char *));
extern	void 	forward_history 	_((char, char *));
extern	void	highlight_off 		_((char, char *));
extern	void	input_add_character 	_((char, char *));
extern	void	input_backspace 	_((char, char *));
extern	void	input_backward_word 	_((char, char *));
extern	void	input_beginning_of_line _((char, char *));
extern	void	input_clear_line 	_((char, char *));
extern	void	input_clear_to_bol 	_((char, char *));
extern	void	input_clear_to_eol 	_((char, char *));
extern	void	input_delete_character 	_((char, char *));
extern	void	input_delete_next_word 	       _((char, char *));
extern	void	input_delete_previous_word     _((char, char *));
extern	void	input_delete_to_previous_space _((char, char *));
extern	void	input_end_of_line 	       _((char, char *));
extern	void	input_forward_word 	       _((char, char *));
extern  void	input_transpose_characters     _((char, char *));
extern	void	input_yank_cut_buffer 	       _((char, char *));
extern	void	insert_bold 		_((char, char *));
extern	void	insert_reverse 		_((char, char *));
extern	void	insert_underline 	_((char, char *));
extern	void 	meta1_char 		_((char, char *));
extern	void 	meta2_char 		_((char, char *));
extern	void 	meta3_char 		_((char, char *));
extern	void 	meta4_char 		_((char, char *));
extern	void 	meta5_char 		_((char, char *));
extern	void 	meta6_char 		_((char, char *));
extern	void 	meta7_char 		_((char, char *));
extern	void 	meta8_char 		_((char, char *));
extern	void 	meta9_char 		_((char, char *));
extern	void 	parse_text 		_((char, char *));
extern	void 	quote_char 		_((char, char *));
extern	void	refresh_inputline 	_((char, char *));
extern	void 	send_line 		_((char, char *));
extern	void 	toggle_insert_mode 	_((char, char *));
extern	void 	type_text 		_((char, char *));

/* used by update_input */
#define NO_UPDATE 0
#define UPDATE_ALL 1
#define UPDATE_FROM_CURSOR 2
#define UPDATE_JUST_CURSOR 3

#endif /* _INPUT_H_ */
