/*--------------------------------------------------------------------
 *    The GMT-system:	@(#)psbasemap.c	2.53  11/29/99
 *
 *	Copyright (c) 1991-1999 by P. Wessel and W. H. F. Smith
 *	See COPYING file for copying and redistribution conditions.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; version 2 of the License.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	Contact info: www.soest.hawaii.edu/gmt
 *--------------------------------------------------------------------*/
/*
 * psbasemap plots out a basemap for the given area using the specified map
 * projection.
 *
 * Author:	Paul Wessel
 * Date:	08-NOV-1999
 * Version:	3.3.3
 *
 */
 
#include "gmt.h"

main (int argc, char **argv)
{
	int i;
	
	BOOLEAN error = FALSE, paint = FALSE, draw_scale = FALSE, gave_xy = FALSE;
	BOOLEAN fancy = FALSE, set_z = FALSE;
	
	double w = 0.0, e = 0.0, s = 0.0, n = 0.0, new_z_level = 0.0, x0, y0, scale_lat, length;

	char measure = '\0';

	struct GMT_FILL fill;
	
	argc = GMT_begin (argc, argv);
		
	for (i = 1; i < argc; i++) {
		if (argv[i][0] != '-') error = TRUE;
		
		switch (argv[i][1]) {
		
			/* Common parameters */
			
			case 'B':
			case 'J':
			case 'K':
			case 'O':
			case 'P':
			case 'R':
			case 'U':
			case 'V':
			case 'X':
			case 'x':
			case 'Y':
			case 'y':
			case 'c':
			case '\0':
				error += GMT_get_common_args (argv[i], &w, &e, &s, &n);
				break;
				
			/* Supplemental options */
			
			case 'E':
				sscanf (&argv[i][2], "%lf/%lf", &z_project.view_azimuth, &z_project.view_elevation);
				break;
				
			case 'G':
				if (GMT_getfill (&argv[i][2], &fill)) {
					GMT_fill_syntax ('G');
					error++;
				}
				paint = TRUE;
				break;
				
			case 'L':
				error += GMT_getscale (&argv[i][2], &x0, &y0, &scale_lat, &length, &measure, &fancy, &gave_xy);
				draw_scale = TRUE;
				break;
				
			case 'Z':
				if (argv[i][2]) {
					new_z_level = atof (&argv[i][2]);
					set_z = TRUE;
				}
				break;
				
			/* Illegal options */
			
			default:
				error = TRUE;
				GMT_default_error (argv[i][1]);
				break;
		}
	}
	
	if (GMT_quick || argc == 1) {
		fprintf (stderr,"psbasemap %s - To plot PostScript basemaps\n\n", GMT_VERSION);
		fprintf (stderr, "usage: psbasemap -B<tickinfo> -J<params> -R<west/east/south/north> [-Eaz/el]\n");
		fprintf (stderr, "	[-G<fill>] [-K] [-L[f][x]<lon0>/<lat0>/<slat>/<length>[m|n|k]] [-O] [-P]\n");
		fprintf (stderr, "	[-U[dx/dy/][label]] [-V] [-X<xshift>] [-Y<yshift>] [-Z<zlevel>] [-c<ncopies>]\n\n");
		
		if (GMT_quick) exit (EXIT_FAILURE);
		
		GMT_explain_option ('B');
		GMT_explain_option ('J');
		GMT_explain_option ('R');
		fprintf (stderr, "\n\tOPTIONS:\n");
		fprintf (stderr, "\t-E set azimuth and elevation of viewpoint for 3-D perspective [180/90]\n");
		fprintf (stderr, "      -G fill inside of basemap with the specified color\n");
		GMT_explain_option ('K');
		fprintf (stderr, "      -L draws a simple map scaLe centered on <lon0>/<lat0>.  Use -Lx to specify cartesian coordinates instead.\n");
		fprintf (stderr, "         Scale is calculated at latitude <slat>. <length> is in km, or [nautical] miles if [n] m is appended\n");
		fprintf (stderr, "         -Lf draws a \"fancy\" scale [Default is plain]\n");
		GMT_explain_option ('O');
		GMT_explain_option ('P');
		GMT_explain_option ('U');
		GMT_explain_option ('V');
		GMT_explain_option ('X');
		fprintf (stderr, "      -Z For 3-D plots: Set the z-level of map [0]\n");
		GMT_explain_option ('c');
		GMT_explain_option ('.');
		exit (EXIT_FAILURE);
	}
	
	if (!project_info.region_supplied) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR:  Must specify -R option\n", GMT_program);
		error++;
	}
	if (!(frame_info.plot || draw_scale || paint)) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR:  Must specify at least one of -B, -G, -L\n", GMT_program);
		error++;
	}
	if (z_project.view_azimuth > 360.0 || z_project.view_elevation <= 0.0 || z_project.view_elevation > 90.0) {
		fprintf (stderr, "%s: GMT SYNTAX ERROR -E option:  Enter azimuth in 0-360 range, elevation in 0-90 range\n", GMT_program);
		error++;
	}
	
	if (error) exit (EXIT_FAILURE);

	GMT_put_history (argc, argv);	/* Update .gmtcommands */

	if (gmtdefs.verbose) fprintf (stderr, "psbasemap: Constructing basemap\n");

	GMT_map_setup (w, e, s, n);
	
	ps_plotinit (CNULL, gmtdefs.overlay, gmtdefs.page_orientation, gmtdefs.x_origin, gmtdefs.y_origin,
		gmtdefs.global_x_scale, gmtdefs.global_y_scale, gmtdefs.n_copies,
		gmtdefs.dpi, GMT_INCH, gmtdefs.paper_width, gmtdefs.page_rgb, GMT_epsinfo (argv[0]));
		
	GMT_echo_command (argc, argv);
	if (gmtdefs.unix_time) GMT_timestamp (argc, argv);
	
	if (project_info.three_D) ps_transrotate (-z_project.xmin, -z_project.ymin, 0.0);

	if (paint) {
		GMT_map_clip_on (fill.rgb, 3);
		GMT_map_clip_off ();
	}
	
	ps_setpaint (gmtdefs.basemap_frame_rgb);
	
	if (set_z) project_info.z_level = new_z_level;
	
	if (frame_info.plot) GMT_map_basemap ();
	
	if (draw_scale) GMT_draw_map_scale (x0, y0, scale_lat, length, measure, gave_xy, fancy);
	
	if (project_info.three_D) ps_rotatetrans (z_project.xmin, z_project.ymin, 0.0);
	ps_plotend (gmtdefs.last_page);
	
	GMT_end (argc, argv);
}
