/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: info.c,v 0.5 1999/08/16 23:42:44 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_NCURSES_H
#include <ncurses.h>
#else
#include <curses.h>
#endif

#include "appindex.h"

#define INFO_ROWS 8

char *
endofstring (char *s, int n)
{
  if (strlen (s) > n)
    return s + (strlen (s) - n);
  return s;
}


void
info ()
{
  clear ();

  attrset (COLOR_PAIR (CP_HEADER));
  mvprintw (0, 0, "%-*.*s", COLS, COLS,
	    "appindex browser (c) 1999 Martin Hinner <mhi@penguin.cz>");

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (LINES - INFO_ROWS + 1, 0, "Appindex database");
  attrset (COLOR_PAIR (CP_INFOVAL));
  mvprintw (LINES - INFO_ROWS + 3, 0, "Created : %s", gendate);
  mvprintw (LINES - INFO_ROWS + 4, 0, "Entries : %u", total_apps);
  mvprintw (LINES - INFO_ROWS + 5, 0, "File    : %s",
	    endofstring (dbfile, COLS / 2 - 11));

  attrset (COLOR_PAIR (CP_INFOKEY) | A_BOLD);
  mvprintw (LINES - INFO_ROWS + 1, COLS / 2, "Appindex browser");
  attrset (COLOR_PAIR (CP_INFOVAL));
  mvprintw (LINES - INFO_ROWS + 3, COLS / 2, "Created  : $Date: 1999/08/16 23:42:44 $");
  mvprintw (LINES - INFO_ROWS + 4, COLS / 2, "Revision : $Revision: 0.5 $");
  mvprintw (LINES - INFO_ROWS + 5, COLS / 2, "Compiled : " __DATE__ ", " __TIME__);

  refresh ();
  error ("Press any key.");
}
