/*
 *  Appindex browser
 *  Copyright (C) 1999 Martin Hinner <mhi@penguin.cz>
 *  $Id: load_db.c,v 0.5 1999/08/16 23:42:44 mhi Exp root $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "appindex.h"

#define APPINDEX_PREFIX "http://freshmeat.net/appindex/"

#ifndef HAVE_DB_H
typedef unsigned short u_int16_t;	/* FIXME */
#endif


int
getstr (FILE * db, char *string)
{
  u_int16_t len;		/* FIXME: Only little-endian ints :-( */

  if (fread (&len, 1, 2, db) != 2)
    return -1;
  if (len > LINE_LEN)
    die ("Corrupted db-file");
  if (fread (string, 1, len, db) != len)
    return -1;
  string[len] = 0;
  return len;
}

void
load_db (FILE * f)
{
  char *line;
  struct app *app;
  char *category;

  line = (char *) malloc (LINE_LEN);
  if (!line)
    return;

  getstr (f, line);
  if (strcmp (line, "Version1"))
    {
      die ("Unrecognized database format.");
    }

  getstr (f, line);
  strcpy (gendate, line);

  while (getstr (f, line) > 0)
    {
      app = (struct app *) malloc (sizeof (struct app));
      if (!app)
	return;

      app->name = strdup (line);
      if (!app->name)
	return;
#define GET_ITEM(x) \
      if (getstr(f,line)==-1) \
        die("Broken data file"); \
      x = strdup(line); \
      if (!x) \
        return ;

      GET_ITEM (app->stable);
      GET_ITEM (app->devel);
      GET_ITEM (category);
      GET_ITEM (app->license);
      GET_ITEM (app->homepage);
      GET_ITEM (app->download);
      GET_ITEM (app->changelog);
      GET_ITEM (app->deb);
      GET_ITEM (app->rpm);
      GET_ITEM (app->link);
      GET_ITEM (app->oneliner);
      GET_ITEM (app->description);
      GET_ITEM (app->author);
      GET_ITEM (app->coauthor);
      GET_ITEM (app->dependancy);
      if (!strncmp (app->link, APPINDEX_PREFIX, strlen (APPINDEX_PREFIX)))
	{
#define ATON(x) (x-'0')
	  app->day = ATON (app->link[strlen (APPINDEX_PREFIX) + 8]) * 10 +
	    ATON (app->link[strlen (APPINDEX_PREFIX) + 9]);
	  app->month = ATON (app->link[strlen (APPINDEX_PREFIX) + 5]) * 10 +
	    ATON (app->link[strlen (APPINDEX_PREFIX) + 6]);
	  app->year = ATON (app->link[strlen (APPINDEX_PREFIX)]) * 1000 +
	    ATON (app->link[strlen (APPINDEX_PREFIX) + 1]) * 100 +
	    ATON (app->link[strlen (APPINDEX_PREFIX) + 2]) * 10 +
	    ATON (app->link[strlen (APPINDEX_PREFIX) + 3]);
#undef  ATON
	}
      else
	{
	  app->day = app->month = app->year = 0;
	}
#undef GET_ITEM
      total_apps++;
      add_app (category, app);
      loadstat (total_apps);
      free (category);
      /* Skip further items */
      do
	{
	  getstr (f, line);
	}
      while (line[0] != 0);
    }				/*while() */

  free (line);
}
