/*
 * File:	WIN_glcanvas.h
 * Purpose:	wxWindows interface for OpenGL using the GLX extension
 * Author:	Wolfram Gloger
 * Created:	1995
 * Updated:     Jul 1996 for wx-Xt 1.65
 * Updated:     Jul 1997 for wx-Xt 1.66c
 */

#ifndef _GL_CANV_H
#define _GL_CANV_H

#include <GL/glx.h>

class wxGLCanvas: public wxItem
{
public:
    wxGLCanvas(wxWindow *parent, int x, int y, int w, int h,
	       int style = 0, Constdata char *name = "wxGLCanvas",
	       int *attrib_list = 0,
	       wxColourMap* colour_map = 0,
	       Bool direct = TRUE,
	       const wxGLCanvas* shareList = 0);
    ~wxGLCanvas();
    Bool Create(wxWindow *parent,
		int x = -1, int y = -1, int width = -1, int height = -1,
		int style = 0, Constdata char *name = "wxGLCanvas",
		int *attrib_list = 0,
		wxColourMap* colour_map = 0,
		Bool direct = TRUE,
		const wxGLCanvas* shareList = 0);
    int  SetCurrent();
    void SwapBuffers();
    void SetColour(const char* col);
    Bool IsRGBA() { return (Bool)is_rgba; }

    // override from wxWindow
    void AfterRealize();

    static Bool HaveVisual(int* attrib_list);

protected:
    GLXContext glx_cx;
private:
    GLboolean is_rgba;
    wxColourMap* gl_cmap;
};

#endif
