/*								-*- C++ -*-
 * $Id: WIN_gauge.h,v 1.2 1997-01-15 14:57:59+01 mho Exp $
 *
 * Purpose: gauge panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Gauge_h
#define Gauge_h

#ifdef __GNUG__
#pragma interface
#endif

class wxPanel;

class wxGauge: public wxItem {
DECLARE_DYNAMIC_CLASS(wxGauge)
public:
    wxGauge(void);
    wxGauge(wxPanel *panel, Const char *label, int range,
	    int x = -1, int y = -1, int width = -1, int height = -1,
	    long style = wxHORIZONTAL, Constdata char *name = wxGaugeNameStr);

    Bool Create(wxPanel *panel, Const char *label, int range,
		int x = -1, int y = -1, int width = -1, int height = -1,
		long style = wxHORIZONTAL, Constdata char *name = wxGaugeNameStr);

    void  SetBezelFace(int WXUNUSED(w)) {}
    void  SetButtonColour(wxColour &col);
    void  SetRange(int r);
    void  SetShadowWidth(int WXUNUSED(w)) {}
    void  SetValue(int pos);
    int   GetValue(void) {return value;}
    int   GetRange(void) {return range;}
private:
    int range, value;
};

#endif // Gauge_h
