/*								-*- C++ -*-
 * $Id: GDI_font.h,v 1.1 1996-09-25 11:06:18+02 mho Exp $
 *
 * Purpose: wxWindows font handling
 *
 * Authors: Markus Holzem, Julian Smart, and Matthew Flatt
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Font_h
#define Font_h

#ifdef __GNUG__
#pragma interface
#endif

class wxFontRep;

class wxFont : public wxObject {
DECLARE_DYNAMIC_CLASS(wxFont)
public:
    wxFont(void);
    wxFont(wxFont& new_font);
    wxFont(int PointSize, int FontIdOrFamily, int Style, int Weight,
	   Bool underlined = FALSE, const char *Face=NULL);
    wxFont(int PointSize, const char *Face, int Family, int Style, int Weight, 
	   Bool underlined = FALSE);
    ~wxFont(void);

    wxFont& operator = (wxFont& new_font);
    void    operator = (wxFont* new_font);

    int   GetPointSize(void);
    char* GetFaceName(void);
    int   GetFamily(void);
    char* GetFamilyString(void);
    int   GetFontId(void);
    char* GetFaceString(void);
    int   GetStyle(void);
    char* GetStyleString(void);
    int   GetWeight(void);
    char* GetWeightString(void);
    Bool  GetUnderlined(void);

#ifdef Have_X_Types
    XFontStruct* GetInternalFont(float scale = 1.0);
#endif
private:
    // needed to delete the internal fonts
    void FreeInternalFonts(void);

    wxFontRep *rep;
};

class wxFontList : public wxList {
DECLARE_DYNAMIC_CLASS(wxFontList)
public:
    wxFontList(void);
    ~wxFontList(void);

    void AddFont(wxFont *font)    { Append(font); }
    void RemoveFont(wxFont *font) { DeleteObject(font); }

    wxFont *FindOrCreateFont(int PointSize, int FontIdOrFamily, int Style, 
			     int Weight, Bool Underline = FALSE,
			     const char *Face=NULL);
    wxFont *FindOrCreateFont(int PointSize, const char *Face, int Family, 
			     int Style, int Weight, Bool Underline = FALSE);
};

class wxFontNameDirectory : public wxObject {
DECLARE_DYNAMIC_CLASS(wxFontNameDirectory)
    class wxHashTable *table;
    int   nextFontId;
public:
    wxFontNameDirectory(void);
    ~wxFontNameDirectory();

    void  Initialize(void);
    void  Initialize(int fontid, int family, const char *name);

    int   FindOrCreateFontId(const char *name, int family);
    char* GetAFMName(int fontid, int weight, int style);
    int   GetFamily(int fontid);
    int   GetFontId(const char *name);
    char* GetFontName(int fontid);
    int   GetNewFontId(void);
    char* GetPostScriptName(int fontid, int weight, int style);
    char* GetScreenName(int fontid, int weight, int style);
};

#endif // Font_h
