/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * =========================== 
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/panedform.h"
#include "vdk/vdkobj.h"
#include "vdk/boxes.h"

VDKPanedForm::VDKPanedForm(VDKApplication* app, 
				 gchar* title, 
				 int mode,
				 GtkWindowType display):
  VDKForm(app,title,mode,display)
{
if(mode == v_box)
  panedWindow = new VDKObject(this,gtk_vpaned_new());
else
  panedWindow = new VDKObject(this,gtk_hpaned_new());
VDKForm::Add(panedWindow);
}


VDKPanedForm::VDKPanedForm(VDKForm* owner,
				 gchar* title, 
				 int mode,
				 GtkWindowType display) :
  VDKForm(owner,title,mode,display)
{
if(mode == v_box)
  panedWindow = new VDKObject(this,gtk_vpaned_new());
else
  panedWindow = new VDKObject(this,gtk_hpaned_new());
VDKForm::Add(panedWindow);
}  
 
void 
VDKPanedForm::Add(VDKObject* obj, int pane,int,int)
{
items.add(obj);
if(pane == 1)
  gtk_paned_add1(GTK_PANED(panedWindow->Widget()),obj->Widget());
else
  gtk_paned_add2(GTK_PANED(panedWindow->Widget()),obj->Widget());
gtk_widget_show(obj->Widget());
obj->Parent(this);
}




