/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 

#ifndef VDKDATE_H
#define VDKDATE_H

#include <math.h>
//#include <iostream.h>

#ifndef CALDATEDEBUG
#define Assert(condition) /* do nothing */
#else
#include <assert.h>
#define Assert(condition) assert(condition)
#endif

/* gregorian calendar adopted on oct 15, 1582 */
#define IGREG (15L+31L*(10L+12L*1582L))
enum { ddmmyyyy,mmddyyyy };
/*
  ===================
  CALENDAR DATE CLASS
  ===================
  */
class calendardate
{
protected:
  int day,month,year;
  long julian;
  long Julian(void);
  void Caldate(void);
  //friend ostream& operator<<(ostream& os, calendardate& d);
  char* InternalBuffer();
  int mode;
public:
  calendardate(int mode = mmddyyyy);
  calendardate(int day, int month, int year, int mode = mmddyyyy):
    day(day),month(month),year(year),mode(mode) 
    { 
      julian = Julian(); 
    }
  calendardate(long julian, int mode = mmddyyyy) : 
    julian(julian),mode(mode) 
    { 
      Caldate(); 
    }
  calendardate(char* s, int mode = mmddyyyy, char* sep =".-/");
  virtual ~calendardate() {}

  /* return as julian date */
  operator long() { return julian; }
  /* return day index:
     0 = sunday, 1 = monday,... 6 = saturday 
     */
  int DayIndex() { return (julian+1) % 7; }
  int Day() { return day; }
  int Month() { return month; }
  int Year() { return year; }
  char* CalendarDate();
  /*
    date operations
    */
  calendardate operator+(long d)
    { return calendardate(julian+d); }
  calendardate operator-(long d)
    { return calendardate(julian-d); }
  long operator-(calendardate& d)
    { return julian - d.julian; }
  calendardate& operator+=(long d)
    { *this = calendardate (julian+d); return *this; }
  calendardate& operator-=(long d)
    { *this = calendardate (julian-d); return *this; }
  /*
    return an internal buffer formatted in
    "day_name dd month_name yyyy" format
    be careful, do not modify directly
    this buffer, copy it before use
    */
  operator char*();
  char* AsString();
  /* validation */
  bool Valid() { return julian >= 0; }
  /*
    relational operations
    */
  bool operator==(calendardate& d)
    { return julian == d.julian; }
  bool operator<(calendardate& d)
    { return julian < d.julian; }
  bool operator!=(calendardate& d)
    { return julian != d.julian; }
  bool operator>(calendardate& d)
    { return julian > d.julian; }
  bool operator>=(calendardate& d)
    { return julian >= d.julian; }
  bool operator<=(calendardate& d)
    { return julian <= d.julian; }
};
/*
  leap year 
  */
inline bool Leap(int y)
{ return !(y%4) && ( y%100 || !(y%400)); }

calendardate MakeDate(char*);

#endif

