/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.5
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */

#ifndef VDKCLIST_H
#define VDKCLIST_H
#include <vdk/vdkcustom.h>
#include <vector>
#include <string>
/*
 */
class VDKCustomList;

typedef VDKReadWriteValueProp<VDKCustomList,VDKPoint>
                               CustomListSelProperty;

class SelectionProp: public CustomListSelProperty
{
 public:
  SelectionProp(
		char* name,
	       	VDKCustomList* object,
	       	VDKPoint defValue,
	       	void (VDKCustomList::*write)(VDKPoint),
	       	VDKPoint (VDKCustomList::*read)(void) =
		(VDKPoint (VDKCustomList::*)(void)) NULL
	       	):CustomListSelProperty(name,object,defValue,write,read)
    { }

  int Row() { VDKPoint p = *this; return p.X(); }
  int Col() { VDKPoint p = *this; return p.Y(); }

};

/*
 */
class VDKCustomList: public VDKCustom
{

 protected:
  IntArray WideSelection;
  VDKPoint selection, unselection; // selected row,column
  // extended selection
  int pointer;
  // wide selection
  int start,end;
  void _update_pix(int row,char* s, char** pixdata = NULL, int col = 0);
  void _update_size(int row,int *W, int *H);
  void SetStyle(int row);
  void ConnectSignals();
  // handle title clicks
  static void ColumnClick(GtkWidget* w,
			  gint column,
			  gpointer s);

  // handle selection in modes != EXTENDED
  static void RowSelection(GtkWidget *wid,
			   gint row,
			     gint column,
			   GdkEvent *event,
			   gpointer data);
  static void RowUnselection(GtkWidget *wid,
			     gint row,
			     gint column,
			     GdkEventButton *event,
			     gpointer data);


 public:
    // properties
    SelectionProp Selected;
    SelectionProp Unselected;
    TupleList Tuples;

 public:
  VDKCustomList(VDKForm* owner,
		int columns = 1,
		char **titles = NULL,
		GtkSelectionMode mode = GTK_SELECTION_SINGLE);
  virtual ~VDKCustomList();
  void AddRow(vector<string> v, char** pixdata = NULL, int col = 0);
  void AddRow(char **texts, char** pixdata = NULL, int col = 0);
  void UpdateRow(int row, char** s,
	      char** pixdata = NULL, int col = 0);
  void UpdateRow(int row, Tuple& t,
	      char** pixdata = NULL, int col = 0);
  void UpdateCell(int row, int col,
		  char* s, char** pixdata = NULL);
  void RemoveRow(int row);
  VDKPoint Selection() { return selection; }
  VDKPoint Unselection() { return unselection; }
  void SelectRow(int row, int col);
  void SelectRow(VDKPoint p) { SelectRow(p.X(),p.Y()); }
  void UnselectRow(int row, int col);
  void UnselectRow(VDKPoint p) { UnselectRow(p.X(),p.Y()); }
  virtual void Clear();
  IntArray& Selections();
#ifdef USE_SIGCPLUSPLUS
 public:
  VDKSignal2<void, int, int> OnRowSelect; // or use VDKPoint?
  VDKSignal2<void, int, int> OnRowUnselect; // "

  VDKSignal2<void, int, int> OnRowMove;
  /*   VDKSignal2<void, int, const char**> OnRowInsert; */ // gone???
/*   VDKSignal1<void, int> OnRowRemove; */
 protected:
  static void make_gtksigc_connection(VDKCustomList*);
 private:
  static void _handle_row_move(GtkWidget* wid, int, int,
			       gpointer obj);
/*   static void _handle_row_insert(GtkWidget* wid, int, char**, */
/* 				 gpointer obj); */
/*   static void _handle_row_remove(GtkWidget* wid, int row, */
/* 				 gpointer obj); */
#endif /* USE_SIGCPLUSPLUS */
};
#endif

