/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#ifndef RADIOBTNGROUP_H
#define RADIOBTNGROUP_H
#include <vdk/widcontain.h>
#include <vdk/checkbutton.h>
#include <vdk/boxes.h>
#include <vdk/vdkprops.h>
class VDKRadioButton;

typedef VDKList<VDKRadioButton> RadioButtonList;
typedef VDKListiterator<VDKRadioButton> RadioButtonListIterator;

class VDKRadioButtonGroup;
class VDKRadioButtonGroup: public VDKObjectContainer
{
 protected:
  VDKBox *box;
  GSList* gs_group;
 public:

  // properties
  VDKReadWriteValueProp<VDKRadioButtonGroup,int> Selected;
  VDKReadOnlyValueProp<VDKRadioButtonGroup, RadioButtonList*> ButtonList;
  RadioButtonList Buttons;
  //
  VDKRadioButtonGroup(VDKForm* owner,int mode = v_box);
  ~VDKRadioButtonGroup(){}
  void SetDefault(int buttonNumber);
  void SetSelected(int index);
  int  GetSelected() { return Selected; }
  void Add(VDKObject* obj, int j = l_justify, 
	   int e = false, int f = false, int p = false);
  void RemoveButton(VDKRadioButton* button);
  GSList* GsGroup(GSList* gs = NULL)
  { if(gs) gs_group = gs; return gs_group; }
  VDKBox* GBox() { return box; }
  static void ToggleEvent(GtkWidget *wid, gpointer bn);
};

class VDKRadioButton: public VDKCheckButton
{
protected:
  int buttonId;
  VDKRadioButtonGroup *rbgroup;
  friend class VDKRadioButtonGroup;
public:
  VDKRadioButton(VDKRadioButtonGroup* group, char* label = NULL);
  VDKRadioButton(VDKForm* owner,char* label);
  virtual ~VDKRadioButton() {}
  VDKRadioButtonGroup* Group(VDKRadioButtonGroup* g = NULL) 
    { if(g) rbgroup = g; return rbgroup; }

};

#endif










