/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  PROGRESSBAR_H
#define  PROGRESSBAR_H
#include <vdk/vdkobj.h>
#include <vdk/vdkprops.h>
class VDKForm;

class VDKProgressBar: public VDKObject
{
 
protected:
  double min,max;
public:
  VDKReadWriteValueProp<VDKProgressBar, double>  Value;
  VDKReadWriteValueProp<VDKProgressBar, int>  BlockCount;
  VDKReadWriteValueProp<VDKProgressBar, int>  BarStyle;
  VDKReadWriteValueProp<VDKProgressBar, int>  BarOrientation;
  VDKReadWriteValueProp<VDKProgressBar, bool> ActivityMode;
public:
  VDKProgressBar(VDKForm* owner,
		 double min = 0.0, double max = 1.0);
  virtual ~VDKProgressBar();
  void Update(double val);
  double Position();
  void SetBlockCount(int bc)
    { 
      gtk_progress_bar_set_discrete_blocks (GTK_PROGRESS_BAR (widget),
					    bc);
    }
  /*
    GTK_PROGRESS_CONTINUOUS,
    GTK_PROGRESS_DISCRETE
  */
  void SetBarStyle(int style)
    {
      gtk_progress_bar_set_bar_style (GTK_PROGRESS_BAR (widget),
				  (GtkProgressBarStyle) style);
    }
  /*
    GTK_PROGRESS_LEFT_TO_RIGHT,
    GTK_PROGRESS_RIGHT_TO_LEFT,
    GTK_PROGRESS_BOTTOM_TO_TOP,
    GTK_PROGRESS_TOP_TO_BOTTOM
   */
  void SetBarOrientation(int or)
    {
      gtk_progress_bar_set_orientation (GTK_PROGRESS_BAR (widget),
			    (GtkProgressBarOrientation) or);
    }
  /*
   */
  void SetActivityMode(bool flag)
    {
      gtk_progress_set_activity_mode (GTK_PROGRESS (widget),
				  flag);
    }
};
#endif
