/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef APPLICATION_H
#define APPLICATION_H

#include <gtk/gtk.h>
#include <vdk/vdktypes.h>
#include <vdk/vdkstring.h>


class VDKForm;

class VDKApplication
{
  int gcTag,idleTag;
  VDKString rcfile;
protected:
  static int GcCallback(gpointer app);
public:
  VDKForm* MainForm;
  VDKApplication(int* argc, char** argv, char* rcf = (char*) NULL,
		 bool have_locale = false);
  virtual ~VDKApplication();
  void Run(void);
  void Terminate(void);
  GtkWidget* MainWindow();
  virtual void Setup() = 0;
  gint MessageBox(char* caption,
	 	  char* text,
 		  int mode = MB_OK,
	 	  char *oktext = (char*) NULL,
		  char *canceltext = (char*) NULL,
		  unsigned int wait = 0);
  void SetIdleCallback(GtkFunction idlecb = NULL ,
		       gpointer data = (gpointer) NULL);
  void SetGarbageCollection(unsigned int tick = 1000);
  void RemoveGarbageCollection();
  void SetResourceFile(char* rcf);
  bool HasResources() { return ! rcfile.isNull(); }
};

#endif







