/*
 * $Id: hashtable.cc,v 1.2 1999/07/10 12:58:28 mario Exp $
 *
 * Copyright (c) Paul D. Gear
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA  02111-1307  USA, or go to
 * <http://www.gnu.org/copyleft/lgpl.html> on the World Wide Web.
 *
 */

/*
 * Brief:       VDKHashTable test code
 * Author:      Paul D. Gear
 * Created:     Sat Jun 26 17:41:18 EST 1999
 *
 * Notes:	This program simply uses each of its command line parameters
 *		as keys in the hash table, and generates a random integer for
 *		the data.
 *
 * Usage:	./hashtable *	# This uses the names of the files in the
 *				# current directory as the hash table keys.
 *
 * Bugs:	Needs to exercise more of the VDKHashTable API.
 *
 */

#include <vdk/hashtable.h>


#include <stdlib.h>

int
main( int argc, char *argv[] )
{
    VDKHashTable<char,int> *ht;
    int i, *rint;

    // Create the hash table
    g_print( "Creating...\n" );
    ht = new VDKHashTable<char,int>( g_str_hash, g_str_equal );

    // Generate a random number for each command line parameter and put it in
    // the hash table with the parameter as the key and the random number as
    // the value.
    g_print( "Inserting:\n" );
    for (i = 0; i < argc; ++i) {
	rint = new int( rand() );
	g_print( "	%s: %d\n", argv[ i ], *rint );
	ht->Insert( argv[ i ], rint );
    }

    // Read back the values in the hash table, then print and delete them.
    g_print( "Reading back:\n" );
    for (i = 0; i < argc; ++i) {
	rint = ht->Lookup( argv[ i ] );
	g_print( "	%s: %d\n", argv[ i ], *rint );
	delete rint;
    }

    // Remove all the keys we put in the hash table
    g_print( "Removing:\n" );
    for (i = 0; i < argc; ++i) {
	ht->Remove( argv[ i ] );
	g_print( "	%s\n", argv[ i ] );
    }

    // Destroy the hash table itself
    g_print( "Destroying...\n" );
    delete ht;

    return 0;
}
