/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 1.0.4
 * December 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef GNOME_DATE_EDIT_H
#define GNOME_DATE_EDIT_H

#if HAVE_GNOME
#include <vdk/vdkobj.h>
#include <vdk/vdkdate.h>
#include <gnome.h>
class VDKForm;
class VDKGnomeDateEdit: public VDKObject
{
 protected:
    VDKObjectSignal s_activated;
    void ConnectSignals();
    static int FocusInEvent(GtkWidget *,
			    GdkEventFocus *,
			    gpointer wid);
    static int FocusOutEvent(GtkWidget *,
			    GdkEventFocus *,
			    gpointer wid);
    static void HandleDateChange(GtkWidget *wid, gpointer gp);
    static void HandleTimeChange(GtkWidget *wid, gpointer gp);
    // either mmddyyyy or ddmmyyyy	
    // reserved for future use,
    // doesn't work now, waiting for i18n
    // of gnome date edit widget.
    int mode;
 public:
__rwproperty(VDKGnomeDateEdit, time_t) AbsoluteTime;
__rwproperty(VDKGnomeDateEdit, calendardate) Date;

 VDKGnomeDateEdit(VDKForm* owner,
		  time_t the_time = (time_t) NULL,
		  bool show_time = false,
		  bool format24 = true,
		  int mode = mmddyyyy);
 VDKGnomeDateEdit(VDKForm* owner,
		  char* the_date = NULL,
		  bool show_time = false,
		  bool format24 = true,
		  int mode = mmddyyyy);

 virtual ~VDKGnomeDateEdit();

 void SetAbsoluteTime(time_t t)
     {
	 gnome_date_edit_set_time (GNOME_DATE_EDIT(Widget()), t);
     }
 time_t	GetAbsoluteTime()
     {
	 return gnome_date_edit_get_date (GNOME_DATE_EDIT(Widget()));
     }
 void SetDate(calendardate d);
 calendardate GetDate();	
};
#endif

#endif
