/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#ifndef SLIDER_H
#define SLIDER_H
#include <vdk/vdkobj.h>
#include <vdk/vdkprops.h>

class VDKSlider: public VDKObject
{
  GtkObject* adj; 
  static void ValueChanged(GtkWidget *wid, gpointer gp);
 public:
  //properties
VDKReadOnlyValueProp<VDKSlider,float> Value;
VDKReadWriteValueProp<VDKSlider, int> Digits;
VDKReadWriteValueProp<VDKSlider, VDKUpdateType> UpdatePolicy;
  VDKSlider(VDKForm* owner,
	    float defValue,
	    float lower,
	    float upper,
	    float step_increment,
	    int mode = h_box,
	    int w = 100,
	    int h = 30);
  virtual ~VDKSlider();
  float GetValue() { return Value; }
  int GetDigit() { return Digits; }
  VDKUpdateType  GetUpdatePolicy() { return UpdatePolicy; }
  void SetDigits(int digits) 
    { gtk_scale_set_digits(GTK_SCALE(widget), digits); }
  void SetUpdatePolicy(VDKUpdateType policy)
    { gtk_range_set_update_policy(GTK_RANGE(widget), (GtkUpdateType) policy); }
#ifdef USE_SIGCPLUSPLUS
     VDKSignal1<void, float> OnSliderValueChanged;
#endif
};
#endif
