/*
 * titler.c - (c) 1998 Andreas Beck   andreas.beck@ggi-project.org
 *
 *   This software is placed in the public domain and can be used freely
 *   for any purpose. It comes without any kind of warranty, either
 *   expressed or implied, including, but not limited to the implied
 *   warranties of merchantability or fitness for a particular purpose.
 *   Use it at your own risk. the author is not responsible for any damage
 *   or consequences raised by use or inability to use this program.
 *
 * This is a demonstration of LibGGI's functions, but it should not be used
 * as a reference programming example. It is very very badly coded, and I am
 * not proud of it. The reason it's there, is that you can nicely make
 * presentations on top of LibGGI with it ...
 *
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <ggi/ggi.h>

/* OUCH ! Tons of global variables for the GIF decoder ... well my early days ...
 */

int  h,bpp,hx,hy,interlace,loaded,realbytes,EC,IC;
unsigned char anz;
int Code[4096];
unsigned char Col[4096],Anf[4096],Conv[256];

struct gifhead {char ID[6];short int wide,high;char gidb,backcol;} gih;
struct imghead {short int dx,dy,br,hi;char lidb;} imh;

struct shortcol { unsigned char r,g,b; };
typedef struct shortcol dregs[256];

dregs locregs,hlpregs,colregs[17];

int getint(char **str);

int bitsinbuf,numbits,numb2;
unsigned long bitbuf;

ggi_visual_t vis;

/* Emulate DOSish style palette setting with 8 bit values ...
 */
void ggiSetpalvec2(int start,int anz,struct shortcol *inp)
{
	ggi_color copy[256];
	int bla;

	for(bla=0;bla<anz;bla++) {
		copy[bla].r=256*inp[bla].r;
		copy[bla].g=256*inp[bla].g;
		copy[bla].b=256*inp[bla].b;
	}

	ggiSetPalette(vis,0,256,copy);

}

/* Get a number of bits from the GIF input file.
 */
int getbits(void)
{
	int ret;
	static unsigned char buf[256];

	while(bitsinbuf<numbits) {

		if (realbytes==anz) {
			read(h,&anz,1);
			realbytes=0;
                        read(h,buf,anz);
		}

		bitbuf+=(long)buf[realbytes++]<<bitsinbuf;
		bitsinbuf+=8;
	}

	bitsinbuf-=numbits;
	ret=bitbuf&(numb2-1);
	bitbuf>>=numbits;

	return(ret);
}

unsigned char linbuffer[2048];

void outcode(register int num)
{
	register int x;
	unsigned char cols[4096];	/* Should be plenty */
  
	for(x=0;num!=-1&&x<4096;x++) {
		cols[x]=Col[num];
		num=Code[num];
	}

	while(x--) { 
		if (hx<sizeof(linbuffer)) 
			linbuffer[hx++]=Conv[cols[x]];

		if (--loaded==0) {
			hx=0;
			loaded=imh.br;
			ggiPutHLine(vis,imh.dx,hy,imh.br,linbuffer);
			memset(linbuffer,gih.backcol,sizeof(linbuffer));

			switch(interlace) {
				case 0:	hy++;
					break;
				case 1:	hy+=8;
					if (hy-imh.dy>=imh.hi) {
						interlace++;
						hy=imh.dy+4;
					}
					break;
				case 2:	hy+=8;
					if (hy-imh.dy>=imh.hi) {
						interlace++;
						hy=imh.dy+2;
					}
					break;
				case 3:	hy+=4;
					if (hy-imh.dy>=imh.hi) {
						interlace++;
						hy=imh.dy+1;
					}
					break;
				case 4: hy+=2;
					if (hy-imh.dy>=imh.hi) {
						interlace++;
						hy=imh.dy;
					}
					break;
			}
		}
	}
}

void palconv(int palnr);
void stdconv(void);

void loadimg(int delx,int dely,int mode)
{
	int bpp2,z,alt;
	register int lastcol,neu;

	read(h,&imh,/*sizeof(imh)*/9);
	if (imh.lidb&64) interlace=1;
	else interlace=0;

	bpp2=bpp;
	hx=0;
	imh.dx+=delx;
	hy=(imh.dy+=dely);

	if ( imh.lidb & 0x80 ) {
		bpp2=(imh.lidb&7)+1;
		for(z=0;z<(1<<bpp2);z++) {
			read(h,&(locregs[z]),sizeof(locregs[0]));
		}
	}

	switch(mode) {
		case 0:stdconv();break;
		case 1:return;
		case 2:palconv(16);break;
		case 3:stdconv();ggiSetpalvec2(0,256,locregs);break;
	}

	read(h,&bpp2,1); /* Needed for 1Bit Gifs */

	numb2=1<<(numbits=bpp2+1);
	lastcol=1+(EC=1+(IC=1<<bpp2));

	for(z=0;z<(1<<bpp2);z++) {
		Col[z]=z;Code[z]=-1;Anf[z]=z;
	}
	loaded=imh.br;
	memset(linbuffer,gih.backcol,sizeof(linbuffer));

	red:
	alt=getbits();
	if (alt==IC) goto red;
	else outcode(alt);

	while(1) {
		if (lastcol>=numb2&&numbits<12) {
			numbits++;
			numb2<<=1;
		}
		
		neu=getbits();
		if (neu==IC) {
			numbits=bpp2+1;
			numb2=1<<numbits;
			lastcol=1+(EC=1+(IC=1<<bpp2));
			goto red;
		}

		if (neu==EC) return;

		if  (neu< lastcol) {
			outcode(neu);
			Col[lastcol]=Anf[neu];
		} else
		if (neu==lastcol) {
			outcode(alt);
			outcode(Anf[alt]);
			Col[lastcol]=Anf[alt];
		} else {
			puts("Illegal code !");
			return;
		}

		Code[lastcol]=alt;
		Anf[lastcol]=Anf[alt];
		alt=neu;
		lastcol++;
	}
}

void loadgif(char *path,int delx,int dely,int mode)
{
	int x,z;

	if ((h=open(path,O_RDONLY))==-1) return;

	bitsinbuf=anz=realbytes=0;bitbuf=0L;

	locregs[0].r=locregs[0].g=locregs[0].b=0;
	locregs[1].r=locregs[1].g=locregs[1].b=255;
	
	read(h,&gih,sizeof(gih));
	if (strncmp(gih.ID,"GIF87a",6) &&
		strncmp(gih.ID,"GIF89a",6)  ) {
		close(h);
		return;
	}
/*  ggi_getpalvec(0,256,colregs[16]);*/

	read(h,&x,1);/* SKIP */
	if (gih.gidb&0x80) { 
		x=((gih.gidb&0x70)>>4)+1;
		bpp=(gih.gidb&7)+1;
		for(z=0;z<(1<<bpp);z++) {
			read(h,&(locregs[z]),sizeof(locregs[0]));
		}
	}

	x=0;
	read(h,&x,1);
	switch(x) {
		case ',':loadimg(delx,dely,mode);
			break;
	}
	
	close(h);
}

void fade2pal(dregs *to,int sp)
{ 
	dregs hlp;
	int x,y;
	
	for(x=256;x>=0;x--) { 
		for(y=0;y<256;y++) { 
			hlp[y].r=(((unsigned int)locregs[y].r)*x+((unsigned int)(*to)[y].r)*(256-x))>>8;
			hlp[y].g=(((unsigned int)locregs[y].g)*x+((unsigned int)(*to)[y].g)*(256-x))>>8;
			hlp[y].b=(((unsigned int)locregs[y].b)*x+((unsigned int)(*to)[y].b)*(256-x))>>8;
		}
		ggiSetpalvec2(0,256,hlp);
		ggUSleep(sp*1000);
	}
}

void fade3pal(dregs *to,int sp)
{
	dregs hlp;
	int x,y;

	for(x=0;x<255;x++) {
		for(y=0;y<256;y++) {
			hlp[y].r=((unsigned int)locregs[y].r*x+(unsigned int)(*to)[y].r*(255-x))/255;
			hlp[y].g=((unsigned int)locregs[y].g*x+(unsigned int)(*to)[y].g*(255-x))/255;
			hlp[y].b=((unsigned int)locregs[y].b*x+(unsigned int)(*to)[y].b*(255-x))/255;
		}
		ggiSetpalvec2(0,256,hlp);
		ggUSleep(sp*1000);
	}
}

void fill(int x,int y,int br,int ho,int col)
{
	ggiSetGCForeground(vis,col);
	ggiDrawBox(vis,x,y,br,ho);
}

void stdconv(void)
{
	int x;
	for(x=0;x<256;x++) 
		Conv[x]=x;
}

void palconv(int palnr)
{
	int x,y,del,dh1,dh;

	for(x=0;x<256;x++) {
		del=32000;
		for(y=0;y<256&&del;y++) {
			dh=abs(locregs[x].r-colregs[palnr][y].r);dh*=dh;dh1 =dh;
			dh=abs(locregs[x].g-colregs[palnr][y].g);dh*=dh;dh1+=dh;
			dh=abs(locregs[x].b-colregs[palnr][y].b);dh*=dh;dh1+=dh;
			if (dh1<del) {
				del=dh1;
				Conv[x]=y;
			}
		}
	}
}

int copyeffect(char *type,int percent,int br,int h,char *src,char *src2,char *target)
{

	int help1,help2;

	if (strcmp(type,"plain")==0) {
		memcpy(target,src,br*h);
		return(-1);
	}
	else if (strcmp(type,"down")==0) {
		memcpy(target,src,br*h*percent/100);
		return(0);
	}
	else if (strcmp(type,"up")==0){
		help1=br*h*percent/100;
		help2=br*h-help1;
		memcpy(target+help2,src+help2,help1);
		return(0);
	}
	else if (strcmp(type,"left")==0) {
		for(help1=0;help1<h;help1++) 
			for(help2=br*percent/100-1;help2>=0;help2--)
				target[help1*br+help2]=src[help1*br+help2];
		return(0);
	}
	else if (strcmp(type,"right")==0) {
		for(help1=0;help1<h;help1++) 
			for(help2=br*(100-percent)/100;help2<br;help2++)
				target[help1*br+help2]=src[help1*br+help2]; 
		return(0);
	}
	else if (strcmp(type,"blend")==0) {
		static char field[10][10];
		int x,y;
		if (percent==0) { 
			for(help1=0;help1<10;help1++) 
				for(help2=0;help2<10;help2++) 
					field[help1][help2]=0;
			return(0);
		}
		do { 
			x=rand()%10;y=rand()%10;
		} while(field[x][y]);

		field[help1=x][help2=y]=1;

		for(y=help1;y<h ;y+=10)
			for(x=help2;x<br;x+=10)
				target[y*br+x]=src[y*br+x];
		return(0);
	}
	else if (strcmp(type,"expand")==0) {
		int x,y,xh,yh,z,zz;
		
		y=-1;yh=-percent;
		for(help1=0;help1<h;help1++) {
			if (yh>=0) {
				yh-=percent; 
				if (yh>0) continue;
			}
			yh+=100;
			y++;
			z=y*br;
			zz=help1*br;
			x=-1;
			xh=-percent;
			for(help2=0;help2<br;zz++,help2++) { 
				if (xh>=0) {
					xh-=percent; 
					if (xh>0) continue;
				}
				xh+=100;
				x++;
				z++;
				target[z]=src[zz];
			}
	  	}
		return(0); 
	}
	else if (strcmp(type,"mosaic")==0) {
		int yy,xx;
		char what;
		
		if (102/(percent+2)==102/(percent+1)) 
			return 0;
		percent=102/(percent+2);
		
		for(help1=0;help1<h;help1+=percent) 
			for(help2=0;help2<br;help2+=percent) {
				what=src[help1*br+help2];
				for(yy=0;yy<percent&&yy+help1<h;yy++)
					for(xx=0;xx<percent&&xx+help2<br;xx++)
						target[(yy+help1)*br+xx+help2]=what;
			}
		return(0); 
	}
	else 
		return(-1);
}

void copyrec(int x1,int y1,int br,int ho,int x2,int y2,char *type,char **para)
{
	void *src,*src2,*target;
	int perc,del,rc;

	if ((src   =malloc(br*ho))==NULL||
	    (src2  =malloc(br*ho))==NULL||
	    (target=malloc(br*ho))==NULL) return;
  
	ggiGetBox(vis,x1,y1,br,ho,src);
	ggiGetBox(vis,x2,y2,br,ho,src2);
	ggiGetBox(vis,x2,y2,br,ho,target);

	del=getint(para);

	for(perc=0;perc<=100;perc++) {
		rc=copyeffect(type,perc,br,ho,src,src2,target);
		ggiPutBox(vis,x2,y2,br,ho,target);
		if (rc) break;
		ggUSleep(del*1000);
	}
  
	free(src);
	free(src2);
	free(target);
}

void pathto(int x1,int y1,int br,int ho,int x2,int y2,char **para)
{
	int del,max,c;

#if 0
	if ((src   =malloc(br*ho))==NULL) return;
  
	ggiGetBox(vis,xx=x1,yy=y1,br,ho,src);
	del=getint(para);
	max=abs(x1-x2);if (max<abs(y1-y2)) max=abs(y1-y2);

	for(c=0;c<=max;c++)
		{ ggiPutBox(vis,x1+(x2-x1)*c/max,y1+(y2-y1)*c/max,br,ho,src);
		ggUSleep(del*1000);
		}
	free(src);
#else
	del=getint(para);
	max=abs(x1-x2);if (max<abs(y1-y2)) max=abs(y1-y2);

	for(c=1;c<=max;c++)
		{ ggiCopyBox(vis,x1+(x2-x1)*(c-1)/max,y1+(y2-y1)*(c-1)/max,br,ho,x1+(x2-x1)*c/max,y1+(y2-y1)*c/max);
		ggUSleep(del*1000);
		}
#endif
}

void glidestart(int x1,int y1,int x2,int y2,int dela)
{
	int dx,dy,sx,sy,cc;

	dx=x2-x1;dy=y2-y1;sx=1;sy=1;
	
	if (dx<0) {dx=-dx;sx=-1;}
	if (dy<0) {dy=-dy;sy=-1;}
	cc=(dx-dy)/2;

	while(1) {
		ggiSetOrigin(vis,x1,y1);
		if (x1==x2&&y1==y2) break;
		if (cc<0) {
			y1+=sy;cc+=dx;
		}
		else      {
			x1+=sx;cc-=dy;
		}
		ggUSleep(dela*1000);
	}
}


#define cmpstr(x) (strncmp(scp,x,strlen(x))==0&&(scp+=strlen(x))!=0)

int getint(char **str)
{
	int x,y;
	x=0;
	
	if (sscanf(*str," %d%n",&x,&y)==1) *str+=y;
	return(x);
}

char *getstr(char **str)
{
	int x;
	char *old;

	if ((x=strspn(*str,",; \t\r\n")))
		old=(*str+=x);

	if ((x=strcspn(old=*str,",; \t\r\n"))) {
		old[x]='\0';
		*str+=x+1;
	}
	
	return(old);
}

/* The main routine ... Wow that was unreadable.
 * Well good ol' DOS days ;-).
 */

int main(int argc,char *argv[])
{ 
	char script[120],*scp,*hlp;
	FILE *scrip;
	int x,y,br,h,x1,y1,col;

	if (argc!=2) {
		puts("USAGE : TITLER Scriptfile");
		return 1;
	}

	strcpy(script,argv[1]);

	if ((scrip=fopen(script,"rt"))==NULL) {
		puts("Can't find Scriptfile.");
		return 1;
	}

	if (ggiInit() != 0) {
		fprintf(stderr, "%s: unable to initialize libggi, exiting.\n",
			argv[0]);
		exit(1);
	}

	if ((vis=ggiOpen(NULL)) == NULL) {
		fprintf(stderr, "%s: unable to open default visual, exiting.\n",
			argv[0]);
		exit(1);
	}
  
	while(!feof(scrip))
	{
		fgets(scp=script,100,scrip);		/* Get one line */
		if (*scp=='#') continue;		/* Ignore comments */

		if (ggiKbhit(vis)) 
			switch(ggiGetc(vis))
		 	{
		 		case 27:strcpy(scp,"stop");break;
				case 32:ggiGetc(vis);break;
			}
     
		if (cmpstr("grafmode"))   {
			x =getint(&scp);
			y =getint(&scp);
			x1=x;y1=y;
			x1=getint(&scp);
			y1=getint(&scp);
			
			if (ggiSetGraphMode(vis,x,y,x1,y1,GT_8BIT))
				ggiPanic("Requested mode unavailable.");

			ggiSetGCForeground(vis,0);
			ggiFillscreen(vis);
		} else 
		if (cmpstr("loadgifpal")) {
			hlp=getstr(&scp);
			x=getint(&scp);
			y=getint(&scp);
			loadgif(hlp,x,y,1);
		} else 
		if (cmpstr("loadgifcon")) {
			hlp=getstr(&scp);
			x=getint(&scp);
			y=getint(&scp);
			loadgif(hlp,x,y,2);
		} else 
		if (cmpstr("loadgifvis")) {
			hlp=getstr(&scp);
			x=getint(&scp);
			y=getint(&scp);
			loadgif(hlp,x,y,3);
		} else 
		if (cmpstr("loadgif")) {
			hlp=getstr(&scp);
			x=getint(&scp);
			y=getint(&scp);
			stdconv();
			loadgif(hlp,x,y,0);
		}
/*    else if (cmpstr("textmode")) ggi_startupmode();*/
		 else 
		 if (cmpstr("conv2pal")) 
		 	palconv(getint(&scp));
		 else 
		 if (cmpstr("wait")) 
	 		ggUSleep(getint(&scp));
		 else 
		 if (cmpstr("copy")) {
	 		x=getint(&scp);
		 	y= getint(&scp);
		 	br=getint(&scp);
	 		h=getint(&scp);
		 	x1=getint(&scp);
		 	y1=getint(&scp);
	 		copyrec(x,y,br,h,x1,y1,getstr(&scp),&scp);
		 } else 
		 if (cmpstr("pathto")) {
	 		x=getint(&scp);
		 	y=getint(&scp);
		 	br=getint(&scp);
	 		h=getint(&scp);
		 	x1=getint(&scp);
		 	y1=getint(&scp);
			pathto(x,y,br,h,x1,y1,&scp);
		} else 
		if (cmpstr("fill")) {
			x=getint(&scp);
			y=getint(&scp);
			br=getint(&scp);
			h=getint(&scp);
			col=getint(&scp);
			fill(x,y,br,h,col);
		} else
		if (cmpstr("savepal")) 
			memcpy(&colregs[getint(&scp)],&locregs,sizeof(locregs));
		else 
		if (cmpstr("loadpal")) 
			memcpy(&locregs,&colregs[getint(&scp)],sizeof(locregs));
		else 
		if (cmpstr("showpal")) 
			ggiSetpalvec2(0,256,locregs);
		else 
		if (cmpstr("fade2pal")) {
			x=getint(&scp);
			fade2pal(&colregs[x],getint(&scp));
		} else 
		if (cmpstr("fade2col")) {
			x=getint(&scp);
			y=getint(&scp);
			br=getint(&scp);
			for(h=0;h<256;h++) {
				hlpregs[h].r=x;
				hlpregs[h].g=y;
				hlpregs[h].b=br;
			}
			fade2pal(&hlpregs,getint(&scp));
		} else 
		if (cmpstr("fade3pal")) {
			x=getint(&scp);
			fade3pal(&colregs[x],getint(&scp));
		} else 
		if (cmpstr("fade3col")) {
			x=getint(&scp);
			y=getint(&scp);
			br=getint(&scp);
			for(h=0;h<256;h++) {
				hlpregs[h].r=x;
				hlpregs[h].g=y;
				hlpregs[h].b=br;
			}
			fade3pal(&hlpregs,getint(&scp));
		} else 
		if (cmpstr("startpos")) {
			x=getint(&scp);
			y=getint(&scp);
			ggiSetOrigin(vis,x,y);
		} else 
		if (cmpstr("glidepos")) {
			x=getint(&scp);
			y=getint(&scp);
			x1=getint(&scp);
			y1=getint(&scp);
			glidestart(x,y,x1,y1,getint(&scp));
		 }
		 else 
		 if (cmpstr("stop")) 
	 		break;
		 else 
		 if (cmpstr("system")) 
	 		system(scp);
		 else 
		 if (cmpstr("save_c")) {
		 	ggi_pixel gp;
			printf("kgi_color coltab[256]={\n");
			for(x=0;x<255;x++)
				printf("  { %d,%d,%d },\n",
					locregs[x].r*0x101,
					locregs[x].g*0x101,
					locregs[x].b*0x101);
			printf("  { %d,%d,%d } };",
				locregs[x].r*0x101,
				locregs[x].g*0x101,
				locregs[x].b*0x101);

			printf("unsigned char pixels[320*200+1]={\n");

			for(y=0;y<200;y++)
				for(x=0;x<320;x++) {
					ggiGetPixel(vis,x,y,&gp);
					printf("%d,%c",
						gp&0xff, (x&0xf)==0x0f ? '\n' : ' ');
				}
			printf("\n};\n");
		 }
		 else 
		 if (cmpstr("key")) { 
	 		ggiGetc(vis); 
		 }
	}

	ggiClose(vis);
	ggiExit();
	return(0);
}
