/* $Id: hline.c,v 1.10 1999/01/15 03:00:15 marcus Exp $
******************************************************************************

   Graphics library for GGI. Horizontal lines for Xlib.

   Copyright (C) 1998 Marcus Sundberg [marcus@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include <ggi/display/xlib.h>

int GGI_Xlib_drawhline(ggi_visual *vis,int x,int y,int w)
{
	XDrawLine(XLIB_PRIV(vis)->display, XLIB_PRIV(vis)->window,
		  XLIB_PRIV(vis)->gc, x, y, x+w, y);
	
	XLIB_DOSYNC(vis);
	return 0;     
}

int GGI_Xlib_puthline(ggi_visual *vis, int x, int y, int w, void *data)
{
	XImage *ximg;
	
	ximg = XCreateImage(XLIB_PRIV(vis)->display,
			    XLIB_PRIV(vis)->visual.visual,
			    LIBGGI_PIXFMT(vis)->depth, ZPixmap, 0,
			    data, w, 1, 8, 0);
	XPutImage(XLIB_PRIV(vis)->display, XLIB_PRIV(vis)->window,
		  XLIB_PRIV(vis)->gc, ximg, 0, 0, x, y, w, 1);
	XFree(ximg);

	XLIB_DOSYNC(vis);
	return 0;
}
