/**
 *
 * $Id: ColorObj.h,v 1.1 1997/02/22 04:41:54 miers Exp $
 * 
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef XM_COLOROBJ_H
#define XM_COLOROBJ_H

#include <Xm/Xm.h>

#ifdef __cplusplus
extern "C" {
#endif

extern WidgetClass  _xmColorObjClass;

typedef struct _ColorObjClassRec *ColorObjClass;
typedef struct _ColorObjRec      *ColorObj;

#define XmNprimaryColorSetId          "primaryColorSetId"
#define XmCPrimaryColorSetId          "PrimaryColorSetId"
#define XmNsecondaryColorSetId        "secondaryColorSetId"
#define XmCSecondaryColorSetId        "SecondaryColorSetId"
#define XmNactiveColorSetId           "activeColorSetId"
#define XmCActiveColorSetId           "ActiveColorSetId"
#define XmNinactiveColorSetId         "inactiveColorSetId"
#define XmCInactiveColorSetId         "InactiveColorSetId"
#define XmNuseColorObj                "useColorObj"
#define XmCUseColorObj                "UseColorObj"

#define XmNtextColorSetId             "textColorSetId"
#define XmCTextColorSetId             "TextColorSetId"
#define XmNuseTextColor               "useTextColor"
#define XmCUseTextColor               "UseTextColor"
#define XmNuseTextColorForList        "useTextColorForList"
#define XmCUseTextColorForList        "UseTextColorForList"

#define XmNuseMask		"useMask"
#define XmCUseMask		"UseMask"
#define XmNuseMultiColorIcons	"useMultiColorIcons"
#define XmCUseMultiColorIcons	"UseMultiColorIcons"

/*
 * structures and macros
 */
typedef struct {
    Pixel fg;
    Pixel bg;
    Pixel ts;
    Pixel bs;
    Pixel sc;
} PixelSet;

#define DitherTopShadow(display, screen, pixelSet) \
    ((pixelSet)->bs == BlackPixel((display), (screen)))

#define DitherBottomShadow(display, screen, pixelSet) \
    ((pixelSet)->ts == WhitePixel((display), (screen)))

#define DITHER     "50_foreground"
#define NO_DITHER  "unspecified_pixmap"

/*
 * defines for color usage
 */
#define B_W           0
#define LOW_COLOR     1
#define MEDIUM_COLOR  2
#define HIGH_COLOR    3

#define COLOR_SRV_NAME "ColorServer"

/*
 * defines for palette.c
 */
#define VALUE_THRESHOLD 225

/*
 * defines for Atom strings
 */
#define PIXEL_SET        "Pixel Sets"

#define PALETTE_NAME     "DefaultPalette Name"
#define TYPE_OF_MONITOR  "Type Of Monitor"
#define UPDATE_FILE      "Update Default File"
#define CUST_DATA        "Customize Data:"

#define  MAX_NUM_COLORS  8
#define  NUM_COLORS  MAX_NUM_COLORS

#ifdef __cplusplus
}
#endif

#endif
