#
# $Header: /usr/local/cvsroot/pythondoc/formatters/SaveFormatter.py,v 1.2 1999/05/01 01:14:42 daniel Exp $
#
# Copyright (C) Daniel Larsson
# All Rights Reserved.
#
# See copyright notice in the file 'LICENSE.TXT', which should have accompanied
# this distribution.

import pickle, format_init

formatter_name = "_Save"
fileext = '.dtr'

def init(options):
    # Register formatter
    global _options
    _options = options

    format_init.add_formatter(formatter_name, Formatter)

class Formatter:
    def index(self, doctree): pass
    def finish(self): pass

    def document(self, doctree):
	modulename = doctree.attribute('id')
	savedir = _options.read_value('main', 'savedir')[1]

	import os
	path = os.path.join(savedir, modulename) + fileext
	try:
	    file = open(path, 'w')
	except IOError, msg:
	    from pythondoc.message import error
	    error("Couldn't open file %s: %s" % (path, msg))
	    return

	pickle.dump(doctree, file)

import os

def restore_all():
    savedir = _options.read_value('main', 'savedir')[1]
    files = filter(lambda file: file[-4:] == fileext, os.listdir(savedir))
    dtrees = map(lambda file, d=savedir: pickle.load(open(os.path.join(d, file))), files)
    return dtrees

#
# $Log: SaveFormatter.py,v $
# Revision 1.2  1999/05/01 01:14:42  daniel
# Removed Windows style line endings.
#
# 
# *****************  Version 3  *****************
# User: Daniel       Date: 98-12-13   Time: 16:16
# Updated in $/Pythondoc/formatters
# Use attribute 'id' instead of 'path'.
# 
# *****************  Version 2  *****************
# User: Daniel       Date: 98-08-11   Time: 20:51
# Updated in $/Pythondoc/formatters
# Prefixed formatter with '_' to make it "invisible".
# Fixed option reading bugs.
# Added dummy methods 'index' and 'finish'.
# 
# *****************  Version 1  *****************
# User: Daniel       Date: 98-08-06   Time: 20:15
# Created in $/Pythondoc/formatters
# 
